/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.utilities;

import java.util.Objects;
import org.freeplane.plugin.ai.tools.utilities.ToolCaller;

public class ToolCallSummary {
    private final String toolName;
    private final String summaryText;
    private final boolean hasError;
    private final ToolCaller toolCaller;

    public ToolCallSummary(String toolName, String summaryText, boolean hasError) {
        this(toolName, summaryText, hasError, ToolCaller.CHAT);
    }

    public ToolCallSummary(String toolName, String summaryText, boolean hasError, ToolCaller toolCaller) {
        this.toolName = Objects.requireNonNull(toolName, "toolName");
        this.summaryText = Objects.requireNonNull(summaryText, "summaryText");
        this.hasError = hasError;
        this.toolCaller = Objects.requireNonNull(toolCaller, "toolCaller");
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getSummaryText() {
        return this.summaryText;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public ToolCaller getToolCaller() {
        return this.toolCaller;
    }

    public ToolCallSummary withToolCaller(ToolCaller newToolCaller) {
        if (this.toolCaller == newToolCaller) {
            return this;
        }
        return new ToolCallSummary(this.toolName, this.summaryText, this.hasError, newToolCaller);
    }
}

