/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.output.structured.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.plugin.ai.tools.content.NodeContentRequest;
import org.freeplane.plugin.ai.tools.content.TextualContentRequest;
import org.freeplane.plugin.ai.tools.search.SearchCaseSensitivity;
import org.freeplane.plugin.ai.tools.search.SearchMatchingMode;
import org.freeplane.plugin.ai.tools.search.SearchResultSection;

public class SearchNodesRequest {
    private static final int DEFAULT_LIMIT = 200;
    private static final int DEFAULT_OFFSET = 0;
    private static final int DEFAULT_MAXIMUM_TOTAL_TEXT_CHARACTERS = 65536;
    private static final SearchMatchingMode DEFAULT_MATCHING_MODE = SearchMatchingMode.CONTAINS;
    private static final SearchCaseSensitivity DEFAULT_CASE_SENSITIVITY = SearchCaseSensitivity.CASE_INSENSITIVE;
    private static final NodeContentRequest DEFAULT_CONTENT_REQUEST = new NodeContentRequest(new TextualContentRequest(true, false, false), null, null, null, null);
    @Description(value={"Target map ID (from getSelectedMapAndNodeIdentifiers)."})
    private final String mapIdentifier;
    @Description(value={"Search query text."})
    private final String queryText;
    @JsonProperty(required=false)
    @Description(value={"Subtree root IDs to search (default: root)."})
    private final List<String> subtreeRootNodeIdentifiers;
    @JsonProperty(required=false)
    @Description(value={"Content fields to search (default: text only)."})
    private final NodeContentRequest nodeContentRequestForSearch;
    @JsonProperty(required=false)
    @Description(value={"Matching mode (default: CONTAINS)."})
    private final SearchMatchingMode matchingMode;
    @JsonProperty(required=false)
    @Description(value={"Case sensitivity (default: CASE_INSENSITIVE)."})
    private final SearchCaseSensitivity caseSensitivity;
    @JsonProperty(required=false)
    @Description(value={"Result sections to include (default: none)."})
    private final List<SearchResultSection> resultSections;
    @JsonProperty(required=false)
    @Description(value={"Result offset (default: 0)."})
    private final Integer offset;
    @JsonProperty(required=false)
    @Description(value={"Maximum results (default: 200)."})
    private final Integer limit;
    @JsonProperty(required=false)
    @Description(value={"Maximum response length in characters (default: 65536)."})
    private final Integer maximumTotalTextCharacters;
    private final boolean hasMatchingMode;
    private final boolean hasCaseSensitivity;
    private final boolean hasOffset;
    private final boolean hasLimit;
    private final boolean hasMaximumTotalTextCharacters;

    @JsonCreator
    public SearchNodesRequest(@JsonProperty(value="mapIdentifier") String mapIdentifier, @JsonProperty(value="queryText") String queryText, @JsonProperty(value="subtreeRootNodeIdentifiers") List<String> subtreeRootNodeIdentifiers, @JsonProperty(value="nodeContentRequestForSearch") NodeContentRequest nodeContentRequestForSearch, @JsonProperty(value="matchingMode") SearchMatchingMode matchingMode, @JsonProperty(value="caseSensitivity") SearchCaseSensitivity caseSensitivity, @JsonProperty(value="resultSections") List<SearchResultSection> resultSections, @JsonProperty(value="offset") Integer offset, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="maximumTotalTextCharacters") Integer maximumTotalTextCharacters) {
        this.mapIdentifier = mapIdentifier;
        this.queryText = queryText;
        this.subtreeRootNodeIdentifiers = subtreeRootNodeIdentifiers;
        this.nodeContentRequestForSearch = nodeContentRequestForSearch == null ? DEFAULT_CONTENT_REQUEST : nodeContentRequestForSearch;
        this.hasMatchingMode = matchingMode != null;
        this.matchingMode = matchingMode == null ? DEFAULT_MATCHING_MODE : matchingMode;
        this.hasCaseSensitivity = caseSensitivity != null;
        this.caseSensitivity = caseSensitivity == null ? DEFAULT_CASE_SENSITIVITY : caseSensitivity;
        this.resultSections = SearchNodesRequest.normalizeResultSections(resultSections);
        this.hasOffset = offset != null;
        this.offset = offset == null ? 0 : Math.max(0, offset);
        this.hasLimit = limit != null;
        this.limit = limit == null ? 200 : Math.max(0, limit);
        this.hasMaximumTotalTextCharacters = maximumTotalTextCharacters != null;
        this.maximumTotalTextCharacters = maximumTotalTextCharacters == null ? 65536 : maximumTotalTextCharacters;
    }

    public String getMapIdentifier() {
        return this.mapIdentifier;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public List<String> getSubtreeRootNodeIdentifiers() {
        return this.subtreeRootNodeIdentifiers;
    }

    public NodeContentRequest getNodeContentRequestForSearch() {
        return this.nodeContentRequestForSearch;
    }

    public SearchMatchingMode getMatchingMode() {
        return this.matchingMode;
    }

    public SearchCaseSensitivity getCaseSensitivity() {
        return this.caseSensitivity;
    }

    public List<SearchResultSection> getResultSections() {
        return this.resultSections;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getMaximumTotalTextCharacters() {
        return this.maximumTotalTextCharacters;
    }

    public boolean hasMatchingMode() {
        return this.hasMatchingMode;
    }

    public boolean hasCaseSensitivity() {
        return this.hasCaseSensitivity;
    }

    public boolean hasOffset() {
        return this.hasOffset;
    }

    public boolean hasLimit() {
        return this.hasLimit;
    }

    public boolean hasMaximumTotalTextCharacters() {
        return this.hasMaximumTotalTextCharacters;
    }

    private static List<SearchResultSection> normalizeResultSections(List<SearchResultSection> resultSections) {
        if (resultSections == null || resultSections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchResultSection> normalized = new ArrayList<SearchResultSection>();
        for (SearchResultSection section : resultSections) {
            if (section == null) continue;
            normalized.add(section);
        }
        if (normalized.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(normalized);
    }
}

