/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.edit;

import java.util.Objects;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.tools.content.ContentType;
import org.freeplane.plugin.ai.tools.content.ContentTypeConverter;
import org.freeplane.plugin.ai.tools.content.NodeContentWriteRequest;
import org.freeplane.plugin.ai.tools.edit.EditedElement;
import org.freeplane.plugin.ai.tools.edit.NoteContentWriteController;
import org.freeplane.plugin.ai.tools.edit.TextContentWriteController;

public class TextualContentEditor {
    private final TextContentWriteController textContentWriteController;
    private final NoteContentWriteController noteContentWriteController;
    private final ContentTypeConverter contentTypeConverter;

    public TextualContentEditor(TextContentWriteController textContentWriteController, NoteContentWriteController noteContentWriteController) {
        this.textContentWriteController = Objects.requireNonNull(textContentWriteController, "textContentWriteController");
        this.noteContentWriteController = Objects.requireNonNull(noteContentWriteController, "noteContentWriteController");
        this.contentTypeConverter = new ContentTypeConverter();
    }

    public void setInitialContent(NodeModel nodeModel, NodeContentWriteRequest content) {
        if (nodeModel == null || content == null) {
            return;
        }
        this.applyInitialText(nodeModel, content.getText(), content.getTextContentType());
        this.applyInitialDetails(nodeModel, content.getDetails(), content.getDetailsContentType());
        this.applyInitialNote(nodeModel, content.getNote(), content.getNoteContentType());
    }

    private void applyInitialText(NodeModel nodeModel, String text, ContentType contentType) {
        String nodeFormat;
        if (text == null) {
            return;
        }
        this.ensureNotFormula(contentType);
        String updatedText = this.prepareInitialTextValue(contentType, text);
        if (updatedText != null) {
            nodeModel.setText(updatedText);
        }
        if ((nodeFormat = this.toNodeFormat(contentType)) != null) {
            NodeStyleModel.setNodeFormat((NodeModel)nodeModel, (String)nodeFormat);
        }
    }

    private void applyInitialDetails(NodeModel nodeModel, String details, ContentType contentType) {
        if (details == null || details.isEmpty()) {
            return;
        }
        this.ensureNotFormula(contentType);
        DetailModel detailModel = DetailModel.createDetailText((NodeModel)nodeModel);
        String updatedDetails = this.prepareInitialRichTextValue(contentType, details);
        detailModel.setText(updatedDetails);
        String freeplaneContentType = this.toFreeplaneContentType(contentType);
        if (freeplaneContentType != null) {
            detailModel.setContentType(freeplaneContentType);
        }
    }

    private void applyInitialNote(NodeModel nodeModel, String note, ContentType contentType) {
        if (note == null || note.isEmpty()) {
            return;
        }
        this.ensureNotFormula(contentType);
        NoteModel noteModel = NoteModel.createNote((NodeModel)nodeModel);
        String updatedNote = this.prepareInitialRichTextValue(contentType, note);
        noteModel.setText(updatedNote);
        String freeplaneContentType = this.toFreeplaneContentType(contentType);
        if (freeplaneContentType != null) {
            noteModel.setContentType(freeplaneContentType);
        }
    }

    private void ensureNotFormula(ContentType contentType) {
        if (contentType == ContentType.FORMULA) {
            throw new IllegalArgumentException("Formula content is not allowed.");
        }
    }

    private String prepareInitialTextValue(ContentType contentType, String value) {
        if (contentType == null) {
            return value;
        }
        switch (contentType) {
            case HTML: {
                return this.htmlOf(value);
            }
            case MARKDOWN: {
                this.rejectHtml(value, "Markdown content does not allow html; use markdown syntax.");
                return value;
            }
            case LATEX: {
                this.rejectHtml(value, "Latex content does not allow html.");
                return this.contentTypeConverter.stripLatexPrefix(value);
            }
            case PLAIN_TEXT: {
                return HtmlUtils.isHtml((String)value) ? HtmlUtils.htmlToPlain((String)value) : value;
            }
        }
        return value;
    }

    private String prepareInitialRichTextValue(ContentType contentType, String value) {
        if (contentType == null) {
            return this.htmlOf(value);
        }
        switch (contentType) {
            case HTML: {
                return this.htmlOf(value);
            }
            case MARKDOWN: {
                this.rejectHtml(value, "Markdown content does not allow html; use markdown syntax.");
                return value;
            }
            case LATEX: {
                this.rejectHtml(value, "Latex content does not allow html.");
                return this.contentTypeConverter.stripLatexPrefix(value);
            }
            case PLAIN_TEXT: {
                return HtmlUtils.isHtml((String)value) ? HtmlUtils.htmlToPlain((String)value) : value;
            }
        }
        return value;
    }

    private String htmlOf(String text) {
        return HtmlUtils.isHtml((String)text) ? text : HtmlUtils.plainToHTML((String)text);
    }

    private String toNodeFormat(ContentType contentType) {
        if (contentType == ContentType.MARKDOWN) {
            return "markdown";
        }
        if (contentType == ContentType.LATEX) {
            return "latex";
        }
        return null;
    }

    private String toFreeplaneContentType(ContentType contentType) {
        if (contentType == ContentType.MARKDOWN) {
            return "markdown";
        }
        if (contentType == ContentType.LATEX) {
            return "latex";
        }
        if (contentType == ContentType.HTML) {
            return "html";
        }
        return null;
    }

    public void editExistingTextualContent(NodeModel nodeModel, EditedElement editedElement, ContentType originalContentType, String value, TextController textController) {
        if (nodeModel == null) {
            throw new IllegalArgumentException("Missing node model.");
        }
        if (editedElement == null) {
            throw new IllegalArgumentException("Missing edited element.");
        }
        if (textController == null) {
            throw new IllegalArgumentException("Missing text controller.");
        }
        switch (editedElement) {
            case TEXT: {
                Object currentTextValue = nodeModel.getUserObject();
                this.ensureFormulaIsNotUsed(currentTextValue, value, originalContentType, textController);
                NodeTextContentType nodeTextContentType = this.resolveNodeTextContentType(nodeModel, currentTextValue, textController);
                this.validateContentType(nodeTextContentType.contentType, originalContentType, true);
                String updatedTextValue = this.prepareTextValue(nodeTextContentType, value);
                this.textContentWriteController.setNodeText(nodeModel, updatedTextValue);
                break;
            }
            case DETAILS: {
                DetailModel detailModel = DetailModel.getDetail((NodeModel)nodeModel);
                String currentDetails = detailModel == null ? null : detailModel.getText();
                this.ensureFormulaIsNotUsed(currentDetails, value, originalContentType, textController);
                ContentType currentDetailsContentType = this.resolveContentType(currentDetails, DetailModel.getDetailContentType((NodeModel)nodeModel), textController);
                this.validateContentType(currentDetailsContentType, originalContentType, false);
                String updatedDetailsValue = this.prepareRichTextValue(currentDetailsContentType, value, editedElement);
                this.textContentWriteController.setDetails(nodeModel, updatedDetailsValue);
                break;
            }
            case NOTE: {
                NoteModel noteModel = NoteModel.getNote((NodeModel)nodeModel);
                String currentNote = noteModel == null ? null : noteModel.getText();
                this.ensureFormulaIsNotUsed(currentNote, value, originalContentType, textController);
                ContentType currentNoteContentType = this.resolveContentType(currentNote, NoteModel.getNoteContentType((NodeModel)nodeModel), textController);
                this.validateContentType(currentNoteContentType, originalContentType, false);
                String updatedNoteValue = this.prepareRichTextValue(currentNoteContentType, value, editedElement);
                this.noteContentWriteController.setNoteText(nodeModel, updatedNoteValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported edited element for textual content: " + String.valueOf((Object)editedElement));
            }
        }
    }

    private void ensureFormulaIsNotUsed(Object currentValue, String newValue, ContentType originalContentType, TextController textController) {
        if (originalContentType == ContentType.FORMULA) {
            throw new IllegalArgumentException("Formula content edits are not allowed.");
        }
        if (textController.isFormula(currentValue)) {
            throw new IllegalArgumentException("Cannot edit formula content.");
        }
        if (textController.isFormula((Object)newValue)) {
            throw new IllegalArgumentException("Formula content edits are not allowed.");
        }
    }

    private void validateContentType(ContentType currentContentType, ContentType originalContentType, boolean allowPlainTextHtmlSwitch) {
        if (originalContentType == null) {
            return;
        }
        if (currentContentType == originalContentType) {
            return;
        }
        if (allowPlainTextHtmlSwitch && this.isPlainTextOrHtml(currentContentType) && this.isPlainTextOrHtml(originalContentType)) {
            return;
        }
        if (currentContentType != originalContentType) {
            throw new IllegalArgumentException("Content type has changed; read editable content again.");
        }
    }

    private boolean isPlainTextOrHtml(ContentType contentType) {
        return contentType == ContentType.PLAIN_TEXT || contentType == ContentType.HTML;
    }

    private ContentType resolveContentType(Object currentValue, String freeplaneContentType, TextController textController) {
        boolean isFormula = textController.isFormula(currentValue);
        return this.contentTypeConverter.toContentType(freeplaneContentType, isFormula, currentValue == null ? null : String.valueOf(currentValue));
    }

    private NodeTextContentType resolveNodeTextContentType(NodeModel nodeModel, Object currentValue, TextController textController) {
        String rawValue = currentValue == null ? null : String.valueOf(currentValue);
        String latexPrefix = this.contentTypeConverter.findLatexPrefix(rawValue);
        ContentType contentType = latexPrefix == null ? this.contentTypeConverter.toTextContentTypeForNode(textController.getNodeFormat(nodeModel), rawValue) : ContentType.LATEX;
        return new NodeTextContentType(contentType, latexPrefix);
    }

    private String prepareTextValue(NodeTextContentType nodeTextContentType, String value) {
        if (nodeTextContentType.contentType == ContentType.LATEX) {
            boolean allowLatexPrefixWithoutReapply = false;
            return this.prepareLatexValue(value, nodeTextContentType.latexPrefix, allowLatexPrefixWithoutReapply);
        }
        if (nodeTextContentType.contentType == ContentType.MARKDOWN) {
            this.rejectHtml(value, "Markdown content does not allow html; use markdown syntax.");
        }
        return value;
    }

    private String prepareRichTextValue(ContentType currentContentType, String value, EditedElement editedElement) {
        if (currentContentType == ContentType.LATEX) {
            boolean allowLatexPrefixWithoutReapply = true;
            return this.prepareLatexValue(value, null, allowLatexPrefixWithoutReapply);
        }
        if (currentContentType == ContentType.MARKDOWN) {
            this.rejectHtml(value, "Markdown content does not allow html; use markdown syntax.");
        }
        return value;
    }

    private String prepareLatexValue(String value, String latexPrefix, boolean allowLatexPrefixWithoutReapply) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing latex content.");
        }
        this.rejectHtml(value, "Latex content does not allow html.");
        if (latexPrefix == null && this.contentTypeConverter.findLatexPrefix(value) != null && !allowLatexPrefixWithoutReapply) {
            throw new IllegalArgumentException("Latex prefix is not allowed for this content.");
        }
        String strippedValue = this.contentTypeConverter.stripLatexPrefix(value);
        if (latexPrefix == null) {
            return strippedValue;
        }
        return latexPrefix + " " + strippedValue;
    }

    private void rejectHtml(String value, String message) {
        if (value != null && HtmlUtils.isHtml((String)value)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static class NodeTextContentType {
        private final ContentType contentType;
        private final String latexPrefix;

        private NodeTextContentType(ContentType contentType, String latexPrefix) {
            this.contentType = contentType;
            this.latexPrefix = latexPrefix;
        }
    }
}

