/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.delete;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.plugin.ai.maps.AvailableMaps;
import org.freeplane.plugin.ai.tools.content.ModifiedNodeSummary;
import org.freeplane.plugin.ai.tools.content.ModifiedNodeSummaryBuilder;
import org.freeplane.plugin.ai.tools.delete.DeleteNodesRequest;
import org.freeplane.plugin.ai.tools.delete.DeleteNodesResponse;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryFormatter;

public class DeleteNodesTool {
    private final AvailableMaps availableMaps;
    private final AvailableMaps.MapAccessListener mapAccessListener;
    private final MMapController mapController;
    private final ModifiedNodeSummaryBuilder modifiedNodeSummaryBuilder;

    public DeleteNodesTool(AvailableMaps availableMaps, AvailableMaps.MapAccessListener mapAccessListener, MMapController mapController, ModifiedNodeSummaryBuilder modifiedNodeSummaryBuilder) {
        this.availableMaps = Objects.requireNonNull(availableMaps, "availableMaps");
        this.mapAccessListener = mapAccessListener;
        this.mapController = Objects.requireNonNull(mapController, "mapController");
        this.modifiedNodeSummaryBuilder = Objects.requireNonNull(modifiedNodeSummaryBuilder, "modifiedNodeSummaryBuilder");
    }

    public DeleteNodesResponse deleteNodes(DeleteNodesRequest request) {
        String mapIdentifierValue = this.requireValue(request.getMapIdentifier(), "mapIdentifier");
        String userSummary = this.requireValue(request.getUserSummary(), "userSummary");
        UUID mapIdentifier = this.parseMapIdentifier(mapIdentifierValue);
        MapModel mapModel = this.availableMaps.findMapModel(mapIdentifier, this.mapAccessListener);
        if (mapModel == null) {
            throw new IllegalArgumentException("Unknown map identifier: " + mapIdentifierValue);
        }
        List<String> nodeIdentifiers = this.requireIdentifiers(request.getNodeIdentifiers());
        List<NodeModel> requestedNodes = this.resolveNodes(mapModel, nodeIdentifiers);
        List<NodeModel> uniqueSubtreeRoots = this.filterUniqueSubtreeRoots(requestedNodes);
        uniqueSubtreeRoots = this.sortByMapOrder(uniqueSubtreeRoots);
        int deletedNodeCount = this.countDeletedNodes(uniqueSubtreeRoots);
        int deletedSubtreeRootCount = uniqueSubtreeRoots.size();
        List<ModifiedNodeSummary> deletedNodes = this.modifiedNodeSummaryBuilder.buildSummaries(uniqueSubtreeRoots, false);
        this.mapController.deleteNodes(uniqueSubtreeRoots);
        return new DeleteNodesResponse(mapIdentifierValue, userSummary, deletedNodes, deletedNodeCount, deletedSubtreeRootCount);
    }

    public ToolCallSummary buildToolCallSummary(DeleteNodesRequest request, DeleteNodesResponse response) {
        return new ToolCallSummary("deleteNodes", "deleteNodes: " + request.getUserSummary(), false);
    }

    public ToolCallSummary buildToolCallErrorSummary(DeleteNodesRequest request, RuntimeException error) {
        String message = error == null ? "Unknown error" : error.getMessage();
        String safeMessage = ToolCallSummaryFormatter.sanitizeValue(message == null ? error.getClass().getSimpleName() : message);
        return new ToolCallSummary("deleteNodes", "deleteNodes error: " + safeMessage, true);
    }

    private String requireValue(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing " + fieldName + " value.");
        }
        return value.trim();
    }

    private UUID parseMapIdentifier(String mapIdentifier) {
        try {
            return UUID.fromString(mapIdentifier);
        }
        catch (IllegalArgumentException error) {
            throw new IllegalArgumentException("Invalid map identifier: " + mapIdentifier, error);
        }
    }

    private List<String> requireIdentifiers(List<String> nodeIdentifiers) {
        if (nodeIdentifiers == null || nodeIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("Missing node identifiers.");
        }
        return nodeIdentifiers;
    }

    private List<NodeModel> resolveNodes(MapModel mapModel, List<String> nodeIdentifiers) {
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
        for (String nodeIdentifier : nodeIdentifiers) {
            if (nodeIdentifier == null || nodeIdentifier.trim().isEmpty()) {
                throw new IllegalArgumentException("Missing node identifier.");
            }
            NodeModel nodeModel = mapModel.getNodeForID(nodeIdentifier.trim());
            if (nodeModel == null) {
                throw new IllegalArgumentException("Unknown node identifier: " + nodeIdentifier);
            }
            if (nodeModel.getParentNode() == null) {
                throw new IllegalArgumentException("Root node deletion is not supported.");
            }
            nodes.add(nodeModel);
        }
        return nodes;
    }

    private List<NodeModel> filterUniqueSubtreeRoots(List<NodeModel> requestedNodes) {
        HashSet<NodeModel> requestedNodesSet = new HashSet<NodeModel>(requestedNodes);
        ArrayList<NodeModel> uniqueRoots = new ArrayList<NodeModel>();
        for (NodeModel node : requestedNodes) {
            if (this.hasAncestorInSet(node, requestedNodesSet)) continue;
            uniqueRoots.add(node);
        }
        return uniqueRoots;
    }

    private List<NodeModel> sortByMapOrder(List<NodeModel> nodes) {
        TreeSet<NodeModel> sortedNodes = new TreeSet<NodeModel>(NodeRelativePath.comparator());
        sortedNodes.addAll(nodes);
        return new ArrayList<NodeModel>(sortedNodes);
    }

    private boolean hasAncestorInSet(NodeModel node, Set<NodeModel> requestedNodes) {
        for (NodeModel parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!requestedNodes.contains(parent)) continue;
            return true;
        }
        return false;
    }

    private int countDeletedNodes(List<NodeModel> uniqueSubtreeRoots) {
        int count = 0;
        for (NodeModel node : uniqueSubtreeRoots) {
            count += this.countSubtreeNodes(node);
        }
        return count;
    }

    private int countSubtreeNodes(NodeModel node) {
        int count = 1;
        for (int index = 0; index < node.getChildCount(); ++index) {
            count += this.countSubtreeNodes(node.getChildAt(index));
        }
        return count;
    }
}

