/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.create;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.OperationErrorHandler;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementCalculator;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementMode;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementResult;

public class NodeInserter {
    private final MMapController mapController;
    private final AnchorPlacementCalculator anchorPlacementCalculator;

    public NodeInserter(MMapController mapController, AnchorPlacementCalculator anchorPlacementCalculator) {
        this.mapController = Objects.requireNonNull(mapController, "mapController");
        this.anchorPlacementCalculator = Objects.requireNonNull(anchorPlacementCalculator, "anchorPlacementCalculator");
    }

    public List<NodeModel> insertNodes(List<NodeModel> nodes, NodeModel anchorNode, AnchorPlacementMode placementMode) {
        return this.insertNodes(nodes, anchorNode, placementMode, null);
    }

    public List<NodeModel> insertNodes(List<NodeModel> nodes, NodeModel anchorNode, AnchorPlacementMode placementMode, OperationErrorHandler errorHandler) {
        if (nodes == null) {
            throw new IllegalArgumentException("Missing nodes.");
        }
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        if (anchorNode == null) {
            throw new IllegalArgumentException("Missing anchor node.");
        }
        if (placementMode == null) {
            throw new IllegalArgumentException("Missing placement mode.");
        }
        AnchorPlacementResult placement = this.anchorPlacementCalculator.calculatePlacement(anchorNode, placementMode);
        NodeModel parentNode = placement.getParentNode();
        if (!this.mapController.isWriteable(parentNode)) {
            throw new IllegalArgumentException("Target node is write protected.");
        }
        int insertionIndex = placement.getInsertionIndex();
        for (NodeModel node : nodes) {
            this.applySide(node, anchorNode, parentNode, placementMode);
            if (errorHandler == null) {
                this.mapController.insertNode(node, parentNode, insertionIndex);
            } else {
                this.mapController.insertNode(node, parentNode, insertionIndex, errorHandler);
            }
            ++insertionIndex;
        }
        return nodes;
    }

    private void applySide(NodeModel node, NodeModel anchorNode, NodeModel parentNode, AnchorPlacementMode placementMode) {
        if (placementMode == AnchorPlacementMode.SIBLING_BEFORE || placementMode == AnchorPlacementMode.SIBLING_AFTER) {
            node.setSide(anchorNode.getSide());
            return;
        }
        if (parentNode.isRoot()) {
            NodeModel.Side side = MapController.suggestNewChildSide((NodeModel)parentNode, (NodeModel.Side)NodeModel.Side.DEFAULT);
            node.setSide(side);
        }
    }
}

