/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools;

import dev.langchain4j.agent.tool.Tool;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.plugin.ai.maps.AvailableMaps;
import org.freeplane.plugin.ai.tools.MessageBuilder;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditRequest;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditResponse;
import org.freeplane.plugin.ai.tools.connectors.ConnectorEditTool;
import org.freeplane.plugin.ai.tools.content.ListAvailableIconsResponse;
import org.freeplane.plugin.ai.tools.content.ListAvailableIconsTool;
import org.freeplane.plugin.ai.tools.content.ModifiedNodeSummaryBuilder;
import org.freeplane.plugin.ai.tools.content.NodeContentApplier;
import org.freeplane.plugin.ai.tools.content.NodeContentFactories;
import org.freeplane.plugin.ai.tools.content.NodeContentItem;
import org.freeplane.plugin.ai.tools.create.AnchorPlacementCalculator;
import org.freeplane.plugin.ai.tools.create.CreateNodesPreferences;
import org.freeplane.plugin.ai.tools.create.CreateNodesRequest;
import org.freeplane.plugin.ai.tools.create.CreateNodesResponse;
import org.freeplane.plugin.ai.tools.create.CreateNodesTool;
import org.freeplane.plugin.ai.tools.create.NodeCreationHierarchyBuilder;
import org.freeplane.plugin.ai.tools.create.NodeInserter;
import org.freeplane.plugin.ai.tools.create.NodeModelCreator;
import org.freeplane.plugin.ai.tools.delete.DeleteNodesRequest;
import org.freeplane.plugin.ai.tools.delete.DeleteNodesResponse;
import org.freeplane.plugin.ai.tools.delete.DeleteNodesTool;
import org.freeplane.plugin.ai.tools.edit.AttributesContentEditor;
import org.freeplane.plugin.ai.tools.edit.EditRequest;
import org.freeplane.plugin.ai.tools.edit.HyperlinkContentEditor;
import org.freeplane.plugin.ai.tools.edit.IconsContentEditor;
import org.freeplane.plugin.ai.tools.edit.NodeContentEditItem;
import org.freeplane.plugin.ai.tools.edit.NodeContentEditor;
import org.freeplane.plugin.ai.tools.edit.NoteContentWriteControllerAdapter;
import org.freeplane.plugin.ai.tools.edit.TagsContentEditor;
import org.freeplane.plugin.ai.tools.edit.TextContentWriteControllerAdapter;
import org.freeplane.plugin.ai.tools.edit.TextualContentEditor;
import org.freeplane.plugin.ai.tools.move.CreateSummaryRequest;
import org.freeplane.plugin.ai.tools.move.CreateSummaryResponse;
import org.freeplane.plugin.ai.tools.move.CreateSummaryTool;
import org.freeplane.plugin.ai.tools.move.MoveNodesIntoSummaryRequest;
import org.freeplane.plugin.ai.tools.move.MoveNodesIntoSummaryResponse;
import org.freeplane.plugin.ai.tools.move.MoveNodesIntoSummaryTool;
import org.freeplane.plugin.ai.tools.move.MoveNodesRequest;
import org.freeplane.plugin.ai.tools.move.MoveNodesResponse;
import org.freeplane.plugin.ai.tools.move.MoveNodesTool;
import org.freeplane.plugin.ai.tools.move.SummaryNodeCreator;
import org.freeplane.plugin.ai.tools.read.FetchNodesForEditingRequest;
import org.freeplane.plugin.ai.tools.read.FetchNodesForEditingResponse;
import org.freeplane.plugin.ai.tools.read.ReadNodesWithDescendantsRequest;
import org.freeplane.plugin.ai.tools.read.ReadNodesWithDescendantsResponse;
import org.freeplane.plugin.ai.tools.read.ReadNodesWithDescendantsTool;
import org.freeplane.plugin.ai.tools.search.SearchNodesRequest;
import org.freeplane.plugin.ai.tools.search.SearchNodesResponse;
import org.freeplane.plugin.ai.tools.search.SearchNodesTool;
import org.freeplane.plugin.ai.tools.selection.SelectSingleNodeRequest;
import org.freeplane.plugin.ai.tools.selection.SelectSingleNodeTool;
import org.freeplane.plugin.ai.tools.selection.SelectedMapAndNodeIdentifiersTool;
import org.freeplane.plugin.ai.tools.selection.SelectionIdentifiersRequest;
import org.freeplane.plugin.ai.tools.selection.SelectionIdentifiersResponse;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryFormatter;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummaryHandler;
import org.freeplane.plugin.ai.tools.utilities.ToolCaller;

public class AIToolSet {
    private final MessageBuilder messageBuilder;
    private final ReadNodesWithDescendantsTool readNodesWithDescendantsTool;
    private final SelectedMapAndNodeIdentifiersTool selectedMapAndNodeIdentifiersTool;
    private final SelectSingleNodeTool selectSingleNodeTool;
    private final SearchNodesTool searchNodesTool;
    private final CreateNodesTool createNodesTool;
    private final MoveNodesTool moveNodesTool;
    private final DeleteNodesTool deleteNodesTool;
    private final CreateSummaryTool createSummaryTool;
    private final MoveNodesIntoSummaryTool moveNodesIntoSummaryTool;
    private final ListAvailableIconsTool listAvailableIconsTool;
    private final ConnectorEditTool connectorEditTool;
    private final NodeContentEditor nodeContentEditor;
    private final AvailableMaps availableMaps;
    private final AvailableMaps.MapAccessListener mapAccessListener;
    private final ToolCallSummaryHandler toolCallSummaryHandler;
    private final ToolCaller toolCaller;

    AIToolSet(ToolCallSummaryHandler toolCallSummaryHandler, AvailableMaps availableMaps, AvailableMaps.MapAccessListener mapAccessListener, TextController textController, NodeContentFactories nodeContentFactories, MMapController mapController, ToolCaller toolCaller) {
        Objects.requireNonNull(mapController, "mapController");
        this.availableMaps = Objects.requireNonNull(availableMaps, "availableMaps");
        this.mapAccessListener = mapAccessListener;
        NodeModelCreator nodeModelCreator = new NodeModelCreator();
        AnchorPlacementCalculator anchorPlacementCalculator = new AnchorPlacementCalculator();
        NodeInserter nodeInserter = new NodeInserter(mapController, anchorPlacementCalculator);
        SummaryNodeCreator summaryNodeCreator = new SummaryNodeCreator(mapController);
        ModifiedNodeSummaryBuilder modifiedNodeSummaryBuilder = new ModifiedNodeSummaryBuilder(textController);
        TextContentWriteControllerAdapter textContentWriteController = new TextContentWriteControllerAdapter(MTextController.getController());
        NoteContentWriteControllerAdapter noteContentWriteController = new NoteContentWriteControllerAdapter(MNoteController.getController());
        MAttributeController attributeController = MAttributeController.getController();
        MIconController iconController = (MIconController)IconController.getController();
        MLinkController linkController = this.requireLinkController();
        TextualContentEditor textualContentEditor = new TextualContentEditor(textContentWriteController, noteContentWriteController);
        AttributesContentEditor attributesContentEditor = new AttributesContentEditor(attributeController);
        TagsContentEditor tagsContentEditor = new TagsContentEditor(iconController);
        ArrayList<NamedIcon> iconCandidates = new ArrayList<NamedIcon>(IconStoreFactory.ICON_STORE.getMindIcons());
        iconCandidates.addAll(IconStoreFactory.ICON_STORE.getUserIcons());
        IconsContentEditor iconsContentEditor = new IconsContentEditor(nodeContentFactories.iconDescriptionResolver, iconCandidates, iconController);
        HyperlinkContentEditor hyperlinkContentEditor = new HyperlinkContentEditor(linkController);
        NodeContentApplier nodeContentApplier = new NodeContentApplier(textualContentEditor, attributesContentEditor, tagsContentEditor, iconsContentEditor, hyperlinkContentEditor);
        NodeCreationHierarchyBuilder nodeCreationHierarchyBuilder = new NodeCreationHierarchyBuilder(nodeModelCreator, nodeContentApplier);
        NodeContentEditor nodeContentEditor = new NodeContentEditor(textController, nodeContentFactories.nodeContentItemReader, textualContentEditor, attributesContentEditor, tagsContentEditor, iconsContentEditor, hyperlinkContentEditor);
        MessageBuilder messageBuilder = new MessageBuilder();
        ReadNodesWithDescendantsTool readNodesWithDescendantsTool = new ReadNodesWithDescendantsTool(availableMaps, mapAccessListener, nodeContentFactories.nodeContentItemReader, textController);
        SelectedMapAndNodeIdentifiersTool selectedMapAndNodeIdentifiersTool = new SelectedMapAndNodeIdentifiersTool(availableMaps, mapAccessListener, textController);
        SelectSingleNodeTool selectSingleNodeTool = new SelectSingleNodeTool(availableMaps, mapAccessListener, mapController, selectedMapAndNodeIdentifiersTool);
        SearchNodesTool searchNodesTool = new SearchNodesTool(availableMaps, mapAccessListener, nodeContentFactories.nodeContentItemReader, textController);
        CreateNodesPreferences createNodesPreferences = new CreateNodesPreferences();
        CreateNodesTool createNodesTool = new CreateNodesTool(availableMaps, mapAccessListener, nodeCreationHierarchyBuilder, nodeInserter, modifiedNodeSummaryBuilder, (MapController)mapController, createNodesPreferences);
        MoveNodesTool moveNodesTool = new MoveNodesTool(availableMaps, mapAccessListener, mapController, anchorPlacementCalculator);
        DeleteNodesTool deleteNodesTool = new DeleteNodesTool(availableMaps, mapAccessListener, mapController, modifiedNodeSummaryBuilder);
        CreateSummaryTool createSummaryTool = new CreateSummaryTool(availableMaps, mapAccessListener, nodeCreationHierarchyBuilder, nodeInserter, summaryNodeCreator, modifiedNodeSummaryBuilder);
        MoveNodesIntoSummaryTool moveNodesIntoSummaryTool = new MoveNodesIntoSummaryTool(availableMaps, mapAccessListener, mapController, summaryNodeCreator);
        ListAvailableIconsTool listAvailableIconsTool = new ListAvailableIconsTool(nodeContentFactories.iconDescriptionResolver);
        ConnectorEditTool connectorEditTool = new ConnectorEditTool(availableMaps, mapAccessListener, linkController);
        this.messageBuilder = Objects.requireNonNull(messageBuilder, "messageBuilder");
        this.readNodesWithDescendantsTool = Objects.requireNonNull(readNodesWithDescendantsTool, "readNodesWithDescendantsTool");
        this.selectedMapAndNodeIdentifiersTool = Objects.requireNonNull(selectedMapAndNodeIdentifiersTool, "selectedMapAndNodeIdentifiersTool");
        this.selectSingleNodeTool = Objects.requireNonNull(selectSingleNodeTool, "selectSingleNodeTool");
        this.searchNodesTool = Objects.requireNonNull(searchNodesTool, "searchNodesTool");
        this.createNodesTool = Objects.requireNonNull(createNodesTool, "createNodesTool");
        this.moveNodesTool = Objects.requireNonNull(moveNodesTool, "moveNodesTool");
        this.deleteNodesTool = Objects.requireNonNull(deleteNodesTool, "deleteNodesTool");
        this.createSummaryTool = Objects.requireNonNull(createSummaryTool, "createSummaryTool");
        this.moveNodesIntoSummaryTool = Objects.requireNonNull(moveNodesIntoSummaryTool, "moveNodesIntoSummaryTool");
        this.listAvailableIconsTool = Objects.requireNonNull(listAvailableIconsTool, "listAvailableIconsTool");
        this.connectorEditTool = Objects.requireNonNull(connectorEditTool, "connectorEditTool");
        this.nodeContentEditor = Objects.requireNonNull(nodeContentEditor, "nodeContentEditor");
        this.toolCallSummaryHandler = toolCallSummaryHandler;
        this.toolCaller = toolCaller == null ? ToolCaller.CHAT : toolCaller;
    }

    public String systemMessageForChat(Object input) {
        return this.messageBuilder.buildForChat();
    }

    @Tool(value={"Read nodes with descendants."})
    public ReadNodesWithDescendantsResponse readNodesWithDescendants(ReadNodesWithDescendantsRequest request) {
        try {
            ReadNodesWithDescendantsResponse response = this.readNodesWithDescendantsTool.readNodesWithDescendants(request);
            this.publishToolCallSummary(this.readNodesWithDescendantsTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.readNodesWithDescendantsTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Fetch nodes for editing. Returns editable content only."})
    public FetchNodesForEditingResponse fetchNodesForEditing(FetchNodesForEditingRequest request) {
        try {
            FetchNodesForEditingResponse response = this.readNodesWithDescendantsTool.fetchNodesForEditing(request);
            this.publishToolCallSummary(this.readNodesWithDescendantsTool.buildFetchToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.readNodesWithDescendantsTool.buildFetchToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Get identifiers for the currently selected map and node, with configurable selection collection mode."})
    public SelectionIdentifiersResponse getSelectedMapAndNodeIdentifiers(SelectionIdentifiersRequest request) {
        try {
            SelectionIdentifiersResponse response = this.selectedMapAndNodeIdentifiersTool.getSelectedMapAndNodeIdentifiers(request);
            this.publishToolCallSummary(this.selectedMapAndNodeIdentifiersTool.buildToolCallSummary(response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.selectedMapAndNodeIdentifiersTool.buildToolCallErrorSummary(error));
            throw error;
        }
    }

    @Tool(value={"Select a single node by identifier and make it visible in the current view. This updates the node shown to the user in the UI and should be used only for user communication; unexpected use can disrupt user workflow and reduce AI acceptance."})
    public SelectionIdentifiersResponse selectSingleNode(SelectSingleNodeRequest request) {
        try {
            SelectionIdentifiersResponse response = this.selectSingleNodeTool.selectSingleNode(request);
            this.publishToolCallSummary(this.selectSingleNodeTool.buildToolCallSummary(response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.selectSingleNodeTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Search nodes by content."})
    public SearchNodesResponse searchNodes(SearchNodesRequest request) {
        try {
            SearchNodesResponse response = this.searchNodesTool.searchNodes(request);
            this.publishToolCallSummary(this.searchNodesTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.searchNodesTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Delete nodes by identifier."})
    public DeleteNodesResponse deleteNodes(DeleteNodesRequest request) {
        try {
            DeleteNodesResponse response = this.deleteNodesTool.deleteNodes(request);
            this.publishToolCallSummary(this.deleteNodesTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.deleteNodesTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"List available built-in and user-defined icons. Emoji icons are referenced by the emoji character itself and are not listed here."})
    public ListAvailableIconsResponse listAvailableIcons() {
        try {
            ListAvailableIconsResponse response = this.listAvailableIconsTool.listAvailableIcons();
            this.publishToolCallSummary(this.listAvailableIconsTool.buildToolCallSummary(response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.listAvailableIconsTool.buildToolCallErrorSummary(error));
            throw error;
        }
    }

    @Tool(value={"Edit connectors by source and target node identifier."})
    public ConnectorEditResponse editConnectors(ConnectorEditRequest request) {
        try {
            ConnectorEditResponse response = this.connectorEditTool.editConnectors(request);
            this.publishToolCallSummary(this.connectorEditTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.connectorEditTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Edit node content safely through undo-aware controllers.\nIMPORTANT RULE: Before editing, you must call fetchNodesForEditing tool to get the real edited node content and content type.\n Formatting: use HTML unless originalContentType is MARKDOWN or LATEX"})
    public List<NodeContentItem> edit(EditRequest request) {
        try {
            List<NodeContentItem> response = this.editNodes(request);
            this.publishToolCallSummary(this.buildEditToolSummary(request, response, false, null));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.buildEditToolSummary(request, null, true, error.getMessage()));
            throw error;
        }
    }

    private void publishToolCallSummary(ToolCallSummary summary) {
        if (summary == null) {
            return;
        }
        LogUtils.info((String)summary.getSummaryText());
        if (this.toolCallSummaryHandler != null) {
            this.toolCallSummaryHandler.handleToolCallSummary(summary.withToolCaller(this.toolCaller));
        }
    }

    private List<NodeContentItem> editNodes(EditRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Missing request");
        }
        String mapIdentifierValue = this.requireValue(request.getMapIdentifier(), "mapIdentifier");
        UUID mapIdentifier = this.parseMapIdentifier(mapIdentifierValue);
        MapModel mapModel = this.availableMaps.findMapModel(mapIdentifier, this.mapAccessListener);
        if (mapModel == null) {
            throw new IllegalArgumentException("Unknown map identifier: " + mapIdentifierValue);
        }
        List<NodeContentEditItem> items = request.getItems();
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("Missing edit items");
        }
        LinkedHashMap<String, List> itemsByNode = new LinkedHashMap<String, List>();
        for (NodeContentEditItem item : items) {
            if (item == null) continue;
            String nodeIdentifier = this.requireValue(item.getNodeIdentifier(), "nodeIdentifier");
            itemsByNode.computeIfAbsent(nodeIdentifier, key -> new ArrayList()).add(item);
        }
        ArrayList<NodeContentItem> results = new ArrayList<NodeContentItem>(itemsByNode.size());
        ArrayList<String> unknownNodeIdentifiers = new ArrayList<String>();
        for (Map.Entry entry : itemsByNode.entrySet()) {
            String nodeIdentifier = (String)entry.getKey();
            NodeModel nodeModel = mapModel.getNodeForID(nodeIdentifier);
            if (nodeModel == null) {
                unknownNodeIdentifiers.add(nodeIdentifier);
                continue;
            }
            results.add(this.nodeContentEditor.edit(nodeModel, (List)entry.getValue()));
        }
        if (!unknownNodeIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("Invalid node identifiers: " + String.join((CharSequence)", ", unknownNodeIdentifiers));
        }
        return results;
    }

    private String requireValue(String value, String fieldName) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing " + fieldName + ".");
        }
        return value;
    }

    private UUID parseMapIdentifier(String mapIdentifier) {
        try {
            return UUID.fromString(mapIdentifier);
        }
        catch (IllegalArgumentException error) {
            throw new IllegalArgumentException("Invalid map identifier: " + mapIdentifier);
        }
    }

    private ToolCallSummary buildEditToolSummary(EditRequest request, List<NodeContentItem> response, boolean hasError, String errorMessage) {
        if (request == null) {
            return null;
        }
        int itemCount = request.getItems() == null ? 0 : request.getItems().size();
        int nodeCount = response == null ? 0 : response.size();
        String summaryText = "edit: nodes=" + nodeCount + ", items=" + itemCount;
        if (request.getUserSummary() != null && !request.getUserSummary().isEmpty()) {
            summaryText = summaryText + ", userSummary=\"" + request.getUserSummary() + "\"";
        }
        if (hasError) {
            String safeMessage = ToolCallSummaryFormatter.sanitizeValue(errorMessage);
            summaryText = !safeMessage.isEmpty() ? summaryText + ", error=\"" + safeMessage + "\"" : summaryText + ", error=true";
        }
        return new ToolCallSummary("edit", summaryText, hasError);
    }

    private MLinkController requireLinkController() {
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController == null) {
            throw new IllegalStateException("Current mode controller is not available.");
        }
        LinkController linkController = LinkController.getController((ModeController)modeController);
        if (!(linkController instanceof MLinkController)) {
            throw new IllegalStateException("Link controller is not available.");
        }
        return (MLinkController)linkController;
    }

    @Tool(value={"Create nodes and subtrees relative to an anchor node. Omit optional textual fields such as details and note when they are empty instead of sending empty strings so the tool leaves those values untouched."})
    public CreateNodesResponse createNodes(CreateNodesRequest request) {
        try {
            CreateNodesResponse response = this.createNodesTool.createNodes(request);
            this.publishToolCallSummary(this.createNodesTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.createNodesTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Move nodes relative to an anchor node."})
    public MoveNodesResponse moveNodes(MoveNodesRequest request) {
        try {
            MoveNodesResponse response = this.moveNodesTool.moveNodes(request);
            this.publishToolCallSummary(this.moveNodesTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.moveNodesTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Create summary content and a summary bracket for a summarized range. Summary anchor nodes must share the same parent node. Omit optional textual fields such as details and note when they are empty instead of sending empty strings so the tool leaves those values untouched. Tip: to create a summary of summaries, choose summary anchor nodes that already exist at the same summary level under the same parent node, regardless of how those summary nodes were created."})
    public CreateSummaryResponse createSummary(CreateSummaryRequest request) {
        try {
            CreateSummaryResponse response = this.createSummaryTool.createSummary(request);
            this.publishToolCallSummary(this.createSummaryTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.createSummaryTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }

    @Tool(value={"Move existing nodes to become summary content for a summarized range."})
    public MoveNodesIntoSummaryResponse moveNodesIntoSummary(MoveNodesIntoSummaryRequest request) {
        try {
            MoveNodesIntoSummaryResponse response = this.moveNodesIntoSummaryTool.moveNodesIntoSummary(request);
            this.publishToolCallSummary(this.moveNodesIntoSummaryTool.buildToolCallSummary(request, response));
            return response;
        }
        catch (RuntimeException error) {
            this.publishToolCallSummary(this.moveNodesIntoSummaryTool.buildToolCallErrorSummary(request, error));
            throw error;
        }
    }
}

