/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.maps;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.maps.MapModelProvider;

public class AvailableMaps {
    private final MapModelProvider mapModelProvider;
    private final Map<MapModel, UUID> mapIdentifiersByMapModel = new WeakHashMap<MapModel, UUID>();
    private final Map<UUID, WeakReference<MapModel>> mapReferencesByIdentifier = new HashMap<UUID, WeakReference<MapModel>>();

    public AvailableMaps(MapModelProvider mapModelProvider) {
        this.mapModelProvider = Objects.requireNonNull(mapModelProvider, "mapModelProvider");
    }

    public UUID getCurrentMapIdentifier() {
        MapModel mapModel = this.mapModelProvider.getCurrentMapModel();
        if (mapModel == null) {
            return null;
        }
        return this.getOrCreateMapIdentifier(mapModel);
    }

    public MapModel getCurrentMapModel() {
        return this.mapModelProvider.getCurrentMapModel();
    }

    public NodeModel getCurrentSelectedNodeModel() {
        return this.mapModelProvider.getCurrentSelectedNodeModel();
    }

    public List<UUID> getAvailableMapIdentifiers() {
        List<MapModel> mapModels = this.mapModelProvider.getOpenMapModels();
        ArrayList<UUID> mapIdentifiers = new ArrayList<UUID>();
        if (mapModels == null || mapModels.isEmpty()) {
            this.removeClearedReferences();
            return mapIdentifiers;
        }
        for (MapModel mapModel : mapModels) {
            if (mapModel == null) continue;
            mapIdentifiers.add(this.getOrCreateMapIdentifier(mapModel));
        }
        this.removeClearedReferences();
        return mapIdentifiers;
    }

    public MapModel findMapModel(UUID mapIdentifier) {
        return this.findMapModel(mapIdentifier, null);
    }

    public MapModel findMapModel(UUID mapIdentifier, MapAccessListener mapAccessListener) {
        if (mapIdentifier == null) {
            return null;
        }
        WeakReference<MapModel> mapReference = this.mapReferencesByIdentifier.get(mapIdentifier);
        if (mapReference == null) {
            return null;
        }
        MapModel mapModel = (MapModel)mapReference.get();
        if (mapModel == null) {
            this.mapReferencesByIdentifier.remove(mapIdentifier);
        }
        if (mapModel != null && mapAccessListener != null) {
            mapAccessListener.onMapAccessed(mapIdentifier, mapModel);
        }
        return mapModel;
    }

    public UUID getOrCreateMapIdentifier(MapModel mapModel) {
        WeakReference<MapModel> mapReference;
        MapModel referencedMapModel;
        Objects.requireNonNull(mapModel, "mapModel");
        UUID mapIdentifier = this.mapIdentifiersByMapModel.get(mapModel);
        if (mapIdentifier == null) {
            mapIdentifier = UUID.randomUUID();
            this.mapIdentifiersByMapModel.put(mapModel, mapIdentifier);
        }
        MapModel mapModel2 = referencedMapModel = (mapReference = this.mapReferencesByIdentifier.get(mapIdentifier)) == null ? null : (MapModel)mapReference.get();
        if (referencedMapModel != mapModel) {
            this.mapReferencesByIdentifier.put(mapIdentifier, new WeakReference<MapModel>(mapModel));
        }
        return mapIdentifier;
    }

    private void removeClearedReferences() {
        Iterator<Map.Entry<UUID, WeakReference<MapModel>>> iterator = this.mapReferencesByIdentifier.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, WeakReference<MapModel>> entry = iterator.next();
            WeakReference<MapModel> mapReference = entry.getValue();
            if (mapReference.get() != null) continue;
            iterator.remove();
        }
    }

    public static interface MapAccessListener {
        public void onMapAccessed(UUID var1, MapModel var2);
    }
}

