/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.edits;

import java.util.Objects;
import java.util.function.Supplier;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.edits.AIEdits;
import org.freeplane.plugin.ai.edits.AiEditsSettings;
import org.freeplane.plugin.ai.edits.AiEditsStateIconDecision;

public class AiEditsStateIconProvider
implements IStateIconProvider {
    private final AiEditsSettings aiEditsSettings;
    private final AiEditsStateIconDecision stateIconDecision;
    private final Supplier<UIIcon> iconSupplier;

    public AiEditsStateIconProvider(AiEditsSettings aiEditsSettings) {
        this(aiEditsSettings, new AiEditsStateIconDecision(), () -> IconStoreFactory.ICON_STORE.getUIIcon("ai.svg"));
    }

    AiEditsStateIconProvider(AiEditsSettings aiEditsSettings, AiEditsStateIconDecision stateIconDecision, Supplier<UIIcon> iconSupplier) {
        this.aiEditsSettings = Objects.requireNonNull(aiEditsSettings, "aiEditsSettings");
        this.stateIconDecision = Objects.requireNonNull(stateIconDecision, "stateIconDecision");
        this.iconSupplier = Objects.requireNonNull(iconSupplier, "iconSupplier");
    }

    public UIIcon getStateIcon(NodeModel node) {
        boolean hasAiEditsMarker;
        boolean isStateIconVisible = this.aiEditsSettings.isStateIconVisible();
        boolean bl = hasAiEditsMarker = node.getExtension(AIEdits.class) != null;
        if (!this.stateIconDecision.shouldShowIcon(isStateIconVisible, hasAiEditsMarker)) {
            return null;
        }
        return this.iconSupplier.get();
    }

    public boolean mustIncludeInIconRegistry() {
        return true;
    }
}

