/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.memory.ChatMemory;
import java.util.List;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.SingleTurnChatMemory;

class SingleTurnChatMemoryFactory {
    private SingleTurnChatMemoryFactory() {
    }

    static SingleTurnChatMemory forMemory(ChatMemory memory) {
        if (memory instanceof AssistantProfileChatMemory) {
            return new AssistantProfileMemoryAdapter((AssistantProfileChatMemory)memory);
        }
        return new GenericChatMemoryAdapter(memory);
    }

    private static class AssistantProfileMemoryAdapter
    implements SingleTurnChatMemory {
        private final AssistantProfileChatMemory memory;

        private AssistantProfileMemoryAdapter(AssistantProfileChatMemory memory) {
            this.memory = memory;
        }

        @Override
        public int snapshotSize() {
            return this.memory.conversationMessageCount();
        }

        @Override
        public void truncateTo(int size) {
            this.memory.truncateConversationMessagesTo(size);
        }

        @Override
        public boolean evictOldestTurn() {
            return this.memory.evictOldestTurn();
        }
    }

    private static class GenericChatMemoryAdapter
    implements SingleTurnChatMemory {
        private final ChatMemory memory;

        private GenericChatMemoryAdapter(ChatMemory memory) {
            this.memory = memory;
        }

        @Override
        public int snapshotSize() {
            if (this.memory == null) {
                return 0;
            }
            return this.memory.messages().size();
        }

        @Override
        public void truncateTo(int size) {
            if (this.memory == null) {
                return;
            }
            List current = this.memory.messages();
            int targetSize = Math.max(0, Math.min(size, current.size()));
            if (targetSize == current.size()) {
                return;
            }
            this.memory.clear();
            for (int index = 0; index < targetSize; ++index) {
                ChatMessage message = (ChatMessage)current.get(index);
                if (message == null) continue;
                this.memory.add(message);
            }
        }

        @Override
        public boolean evictOldestTurn() {
            if (this.memory == null) {
                return false;
            }
            List current = this.memory.messages();
            if (current.isEmpty()) {
                return false;
            }
            this.memory.clear();
            for (int index = 1; index < current.size(); ++index) {
                ChatMessage message = (ChatMessage)current.get(index);
                if (message == null) continue;
                this.memory.add(message);
            }
            return true;
        }
    }
}

