/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import java.util.List;
import org.freeplane.core.util.TextUtils;
import org.freeplane.plugin.ai.chat.AssistantProfileSwitchMessage;
import org.freeplane.plugin.ai.chat.ChatMemoryRenderEntry;
import org.freeplane.plugin.ai.chat.ChatMessageHistory;
import org.freeplane.plugin.ai.chat.ChatMessageRenderer;
import org.freeplane.plugin.ai.chat.GeneralSystemMessage;
import org.freeplane.plugin.ai.chat.InstructionAckMessage;
import org.freeplane.plugin.ai.chat.RemovedForSpaceSystemMessage;
import org.freeplane.plugin.ai.chat.TranscriptHiddenSystemMessage;
import org.freeplane.plugin.ai.tools.MessageBuilder;
import org.freeplane.plugin.ai.tools.utilities.ToolCaller;

class ChatMemoryHistoryRenderer {
    private final ChatMessageHistory messageHistory;
    private final ChatMessageRenderer messageRenderer;
    private final ProfileMessageFormatter profileMessageFormatter;

    ChatMemoryHistoryRenderer(ChatMessageHistory messageHistory, ChatMessageRenderer messageRenderer) {
        this(messageHistory, messageRenderer, profileName -> {
            if (profileName != null && !profileName.trim().isEmpty()) {
                return TextUtils.format((String)"ai_chat_profile_message", (Object[])new Object[]{profileName.trim()});
            }
            return TextUtils.getText((String)"ai_chat_profile_label");
        });
    }

    ChatMemoryHistoryRenderer(ChatMessageHistory messageHistory, ChatMessageRenderer messageRenderer, ProfileMessageFormatter profileMessageFormatter) {
        this.messageHistory = messageHistory;
        this.messageRenderer = messageRenderer;
        this.profileMessageFormatter = profileMessageFormatter;
    }

    void rebuildFromMessages(List<ChatMemoryRenderEntry> entries) {
        this.messageHistory.clear();
        if (entries == null || entries.isEmpty()) {
            return;
        }
        boolean hasToolSummaries = this.containsToolSummaryMessages(entries);
        for (int index = 0; index < entries.size(); ++index) {
            ChatMemoryRenderEntry entry = entries.get(index);
            if (entry == null || this.isHiddenAcknowledgementMessage(entries, index)) continue;
            this.appendMessage(entry, hasToolSummaries);
        }
    }

    void appendEntry(ChatMemoryRenderEntry entry) {
        if (entry == null) {
            return;
        }
        this.appendMessage(entry, entry.isToolSummary());
    }

    private void appendMessage(ChatMemoryRenderEntry entry, boolean hasToolSummaries) {
        MessageHistoryEntry historyEntry = this.toMessageHistoryEntry(entry, hasToolSummaries);
        if (historyEntry == null || historyEntry.sourceText == null) {
            return;
        }
        String renderedText = this.messageRenderer.renderMessage(historyEntry.sourceText, historyEntry.category == RenderCategory.ASSISTANT);
        this.messageHistory.appendMessage(historyEntry.sourceText, renderedText, historyEntry.category.getStyleClassName());
    }

    private MessageHistoryEntry toMessageHistoryEntry(ChatMemoryRenderEntry entry, boolean hasToolSummaries) {
        if (entry.isToolSummary()) {
            RenderCategory category = entry.toolCaller() == ToolCaller.MCP ? RenderCategory.MCP_CALL : RenderCategory.TOOL_CALL;
            return new MessageHistoryEntry(entry.toolSummaryText(), category);
        }
        ChatMessage message = entry.chatMessage();
        if (message == null) {
            return null;
        }
        if (message instanceof AssistantProfileSwitchMessage) {
            AssistantProfileSwitchMessage profileMessage = (AssistantProfileSwitchMessage)message;
            return new MessageHistoryEntry(this.buildProfilePaneMessage(profileMessage.getProfileName()), RenderCategory.PROFILE);
        }
        if (message instanceof GeneralSystemMessage) {
            return null;
        }
        if (message instanceof TranscriptHiddenSystemMessage) {
            return null;
        }
        if (message instanceof RemovedForSpaceSystemMessage) {
            return new MessageHistoryEntry(((RemovedForSpaceSystemMessage)message).text(), RenderCategory.CONTEXT_BOUNDARY);
        }
        if (message instanceof ToolExecutionResultMessage) {
            if (hasToolSummaries) {
                return null;
            }
            ToolExecutionResultMessage toolResult = (ToolExecutionResultMessage)message;
            String text = "Tool result [" + toolResult.toolName() + "]: " + toolResult.text();
            return new MessageHistoryEntry(text, RenderCategory.TOOL_CALL);
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (aiMessage.hasToolExecutionRequests()) {
                if (hasToolSummaries) {
                    return null;
                }
                return new MessageHistoryEntry(this.formatToolRequestSummary(aiMessage), RenderCategory.TOOL_CALL);
            }
            return new MessageHistoryEntry(aiMessage.text(), RenderCategory.ASSISTANT);
        }
        if (message instanceof UserMessage) {
            String text = ((UserMessage)message).singleText();
            if (text != null && text.startsWith("control instruction, please confirm with \"ok\": ")) {
                return new MessageHistoryEntry(MessageBuilder.buildSystemInstructionText(text), RenderCategory.SYSTEM);
            }
            return new MessageHistoryEntry(text, RenderCategory.USER);
        }
        if (message instanceof SystemMessage) {
            return new MessageHistoryEntry(MessageBuilder.buildSystemInstructionText(((SystemMessage)message).text()), RenderCategory.SYSTEM);
        }
        return new MessageHistoryEntry(String.valueOf(message), RenderCategory.SYSTEM);
    }

    private String formatToolRequestSummary(AiMessage aiMessage) {
        List requests = aiMessage.toolExecutionRequests();
        if (requests == null || requests.isEmpty()) {
            return "Tool call";
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < requests.size(); ++index) {
            ToolExecutionRequest request = (ToolExecutionRequest)requests.get(index);
            if (index > 0) {
                builder.append("\n");
            }
            builder.append("Tool call [").append(request.name()).append("]");
            String arguments = request.arguments();
            if (arguments == null || arguments.trim().isEmpty()) continue;
            builder.append(": ").append(arguments);
        }
        return builder.toString();
    }

    private boolean isHiddenAcknowledgementMessage(List<ChatMemoryRenderEntry> entries, int index) {
        if (entries == null || index <= 0 || index >= entries.size()) {
            return false;
        }
        ChatMemoryRenderEntry currentEntry = entries.get(index);
        ChatMemoryRenderEntry previousEntry = entries.get(index - 1);
        if (currentEntry == null || previousEntry == null || currentEntry.isToolSummary() || previousEntry.isToolSummary()) {
            return false;
        }
        ChatMessage current = currentEntry.chatMessage();
        ChatMessage previous = previousEntry.chatMessage();
        if (current == null || previous == null) {
            return false;
        }
        if (!(current instanceof InstructionAckMessage)) {
            return false;
        }
        return previous instanceof AssistantProfileSwitchMessage || previous instanceof TranscriptHiddenSystemMessage;
    }

    private String buildProfilePaneMessage(String profileName) {
        return this.profileMessageFormatter.formatProfileMessage(profileName);
    }

    private boolean containsToolSummaryMessages(List<ChatMemoryRenderEntry> entries) {
        for (int index = 0; index < entries.size(); ++index) {
            ChatMemoryRenderEntry entry = entries.get(index);
            if (entry == null || !entry.isToolSummary()) continue;
            return true;
        }
        return false;
    }

    static interface ProfileMessageFormatter {
        public String formatProfileMessage(String var1);
    }

    private static class MessageHistoryEntry {
        private final String sourceText;
        private final RenderCategory category;

        private MessageHistoryEntry(String sourceText, RenderCategory category) {
            this.sourceText = sourceText;
            this.category = category;
        }
    }

    private static enum RenderCategory {
        USER("message-user"),
        ASSISTANT("message-assistant"),
        TOOL_CALL("message-tool"),
        MCP_CALL("message-mcp-call"),
        PROFILE("message-profile"),
        CONTEXT_BOUNDARY("message-context-boundary"),
        SYSTEM("message-system");

        private final String styleClassName;

        private RenderCategory(String styleClassName) {
            this.styleClassName = styleClassName;
        }

        String getStyleClassName() {
            return this.styleClassName;
        }
    }
}

