/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.net.URL;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconDescription;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.ZoomedIcon;
import org.freeplane.features.icon.factory.IconFactory;

public class UIIcon
implements IconDescription,
NamedIcon {
    private static final String DEFAULT_IMAGE_PATH = "/images";
    private final String name;
    private final String file;
    private final String descriptionTranslationKey;
    private final String shortcutKey;
    private URL resourceURL;
    private final int order;

    public UIIcon(String name, String file, int order) {
        this(name, file, "", "?", order);
    }

    public UIIcon(String name, String file, String descriptionTranslationKey, int order) {
        this(name, file, descriptionTranslationKey, "?", order);
    }

    public UIIcon(String name, String file, String descriptionTranslationKey, String shortcutKey, int order) {
        this.name = name;
        this.file = file;
        this.descriptionTranslationKey = descriptionTranslationKey;
        this.shortcutKey = shortcutKey;
        this.order = order;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public String getShortcutKey() {
        return this.shortcutKey;
    }

    @Override
    public String getDescriptionTranslationKey() {
        return this.descriptionTranslationKey;
    }

    @Override
    public String getTranslatedDescription() {
        String translatedDescription = TextUtils.getText(this.descriptionTranslationKey, "");
        return translatedDescription.isEmpty() ? TextUtils.capitalize(this.name.replaceFirst(".*/", "")) : translatedDescription;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return IconFactory.getInstance().getIcon(this);
    }

    @Override
    public Icon getIcon(Quantity<LengthUnit> iconHeight) {
        return IconFactory.getInstance().getIcon(this, iconHeight);
    }

    public String getImagePath() {
        return DEFAULT_IMAGE_PATH;
    }

    public URL getUrl() {
        this.initializeUrl();
        return this.resourceURL;
    }

    public void initializeUrl() {
        if (this.resourceURL == null) {
            String path = this.getPath();
            this.resourceURL = ResourceController.getResourceController().getIconResource(path);
        }
    }

    protected void setUrl(URL url) {
        this.resourceURL = url;
    }

    public String getPath() {
        return this.getImagePath() + '/' + this.file;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public NamedIcon zoom(float zoom) {
        return new ZoomedIcon(this, zoom);
    }

    @Override
    public boolean hasStandardSize() {
        return true;
    }
}

