/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.hierarchicalicons;

import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.icon.IStateIconProvider;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.UIIconSet;
import org.freeplane.features.icon.hierarchicalicons.AccumulatedIcons;
import org.freeplane.features.icon.hierarchicalicons.IconIntersectionHierarchy;
import org.freeplane.features.icon.hierarchicalicons.IconUnionHierarchy;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.NodeStream;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class HierarchicalIcons
extends PersistentNodeHook
implements INodeChangeListener,
IMapChangeListener,
IExtension {
    public static final String ICONS = "hierarchical_icons";
    private final Mode mode;

    public static void install(ModeController modeController) {
        IconController.getController(modeController).addStateIconProvider(new IStateIconProvider(){

            @Override
            public UIIcon getStateIcon(NodeModel node) {
                Collection<NamedIcon> accumulatedIcons;
                HierarchicalIcons hierarchicalIconsForSubtree;
                AccumulatedIcons iconSet = node.getExtension(AccumulatedIcons.class);
                if (iconSet == null && (hierarchicalIconsForSubtree = HierarchicalIcons.hierarchicalIconsForSubtree(node)) != null) {
                    NodeStream.bottomUpOf(node).forEach(n -> AccumulatedIcons.setStyleCheckForChange(n, hierarchicalIconsForSubtree.mode));
                    iconSet = node.getExtension(AccumulatedIcons.class);
                }
                if (iconSet != null && !(accumulatedIcons = iconSet.getAccumulatedIcons()).isEmpty()) {
                    return new UIIconSet(accumulatedIcons, 0.75f);
                }
                return null;
            }

            @Override
            public boolean mustIncludeInIconRegistry() {
                return false;
            }
        });
        new IconIntersectionHierarchy().installHook(modeController);
        new IconUnionHierarchy().installHook(modeController);
    }

    protected HierarchicalIcons(Mode mode) {
        this.mode = mode;
    }

    protected void installHook(ModeController modeController) {
        modeController.getMapController().addUINodeChangeListener(this);
        modeController.getMapController().addUIMapChangeListener(this);
    }

    @Override
    public void undoableToggleHook(NodeModel node, IExtension extension) {
        this.removeAnotherMode(node);
        super.undoableToggleHook(node, extension);
    }

    protected abstract void removeAnotherMode(NodeModel var1);

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        return this;
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        MapModel map = event.getMap();
        if (map == null) {
            return;
        }
        Object property = event.getProperty();
        if (!property.equals("MAP_STYLES")) {
            return;
        }
        NodeModel rootNode = map.getRootNode();
        NodeStream.of(rootNode).forEach(node -> node.removeExtension(AccumulatedIcons.class));
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        NodeModel node = event.getNode();
        HierarchicalIcons.setStyleUpToRoot(node);
    }

    @Override
    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        HierarchicalIcons.setStyleUpToRoot(nodeDeletionEvent.parent);
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        HierarchicalIcons.setStyleUpToRoot(child);
    }

    @Override
    public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
        HierarchicalIcons.setStyleUpToRoot(nodeMoveEvent.oldParent);
        HierarchicalIcons.setStyleUpToRoot(nodeMoveEvent.child);
    }

    @Override
    public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
    }

    @Override
    protected void remove(NodeModel node, IExtension extension) {
        this.removeIcons(node);
        super.remove(node, extension);
    }

    private void removeIcons(NodeModel node) {
        AccumulatedIcons icons = node.removeExtension(AccumulatedIcons.class);
        if (icons != null && !icons.getAccumulatedIcons().isEmpty()) {
            Controller.getCurrentModeController().getMapController().delayedNodeRefresh(node, ICONS, null, null);
            for (NodeModel child : node.getChildren()) {
                if (null != HierarchicalIcons.hierarchicalIconsExtensionOf(child)) continue;
                this.removeIcons(child);
            }
        }
    }

    private static HierarchicalIcons hierarchicalIconsExtensionOf(NodeModel node) {
        if (node.containsExtension(IconUnionHierarchy.class)) {
            return node.getExtension(IconUnionHierarchy.class);
        }
        if (node.containsExtension(IconIntersectionHierarchy.class)) {
            return node.getExtension(IconIntersectionHierarchy.class);
        }
        return null;
    }

    private static HierarchicalIcons hierarchicalIconsForSubtree(NodeModel node) {
        for (NodeModel parent = node; parent != null; parent = parent.getParentNode()) {
            HierarchicalIcons extension = HierarchicalIcons.hierarchicalIconsExtensionOf(parent);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }

    private static void setStyleUpToRoot(NodeModel node, Mode mode) {
        NodeModel parent;
        if (AccumulatedIcons.setStyleCheckForChange(node, mode) && (parent = node.getParentNode()) != null && parent.containsExtension(AccumulatedIcons.class)) {
            HierarchicalIcons extension = HierarchicalIcons.hierarchicalIconsExtensionOf(node);
            if (extension != null) {
                HierarchicalIcons.setStyleUpToRoot(parent);
            } else {
                HierarchicalIcons.setStyleUpToRoot(parent, mode);
            }
        }
    }

    private static void setStyleUpToRoot(NodeModel node) {
        HierarchicalIcons extension;
        if (node.containsExtension(AccumulatedIcons.class) && (extension = HierarchicalIcons.hierarchicalIconsForSubtree(node)) != null) {
            HierarchicalIcons.setStyleUpToRoot(node, extension.mode);
        }
    }

    @Override
    public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
    }

    public static enum Mode {
        INTERSECTION,
        UNION;

    }
}

