﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/dataexchange/DataExchange_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataExchange {
namespace Model {

/**
 * <p>A structure that allows an LF-admin to grant permissions on certain
 * conditions.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/LFTag">AWS
 * API Reference</a></p>
 */
class LFTag {
 public:
  AWS_DATAEXCHANGE_API LFTag() = default;
  AWS_DATAEXCHANGE_API LFTag(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAEXCHANGE_API LFTag& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAEXCHANGE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The key name for the LF-tag.</p>
   */
  inline const Aws::String& GetTagKey() const { return m_tagKey; }
  inline bool TagKeyHasBeenSet() const { return m_tagKeyHasBeenSet; }
  template <typename TagKeyT = Aws::String>
  void SetTagKey(TagKeyT&& value) {
    m_tagKeyHasBeenSet = true;
    m_tagKey = std::forward<TagKeyT>(value);
  }
  template <typename TagKeyT = Aws::String>
  LFTag& WithTagKey(TagKeyT&& value) {
    SetTagKey(std::forward<TagKeyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of LF-tag values.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTagValues() const { return m_tagValues; }
  inline bool TagValuesHasBeenSet() const { return m_tagValuesHasBeenSet; }
  template <typename TagValuesT = Aws::Vector<Aws::String>>
  void SetTagValues(TagValuesT&& value) {
    m_tagValuesHasBeenSet = true;
    m_tagValues = std::forward<TagValuesT>(value);
  }
  template <typename TagValuesT = Aws::Vector<Aws::String>>
  LFTag& WithTagValues(TagValuesT&& value) {
    SetTagValues(std::forward<TagValuesT>(value));
    return *this;
  }
  template <typename TagValuesT = Aws::String>
  LFTag& AddTagValues(TagValuesT&& value) {
    m_tagValuesHasBeenSet = true;
    m_tagValues.emplace_back(std::forward<TagValuesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_tagKey;

  Aws::Vector<Aws::String> m_tagValues;
  bool m_tagKeyHasBeenSet = false;
  bool m_tagValuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataExchange
}  // namespace Aws
