/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapHtmlLabel;

public class OptionsParamView
extends AbstractParam {
    private static final Logger LOGGER = LogManager.getLogger(OptionsParamView.class);
    private static final String DEFAULT_TIME_STAMP_FORMAT = Constant.messages.getString("timestamp.format.datetime");
    public static final String BASE_VIEW_KEY = "view";
    private static final String SHOW_TEXT_ICONS = "view.showTabNames";
    private static final String PROCESS_IMAGES = "view.processImages";
    public static final String LOCALE = "view.locale";
    public static final String DISPLAY_OPTION = "view.displayOption";
    private static final String RESPONSE_PANEL_POS_KEY = "view.messagePanelsPosition.lastSelectedPosition";
    public static final String BRK_PANEL_VIEW_OPTION = "view.brkPanelView";
    public static final String SHOW_MAIN_TOOLBAR_OPTION = "view.showMainToolbar";
    public static final String DEFAULT_LOCALE = "en_GB";
    public static final String ADVANCEDUI_OPTION = "view.advancedview";
    public static final String WMUIHANDLING_OPTION = "view.uiWmHandling";
    public static final String ASKONEXIT_OPTION = "view.askOnExit";
    public static final String WARN_ON_TAB_DOUBLE_CLICK_OPTION = "view.warnOnTabDoubleClick";
    public static final String MODE_OPTION = "view.mode";
    public static final String TAB_PIN_OPTION = "view.tab.pin";
    public static final String OUTPUT_TAB_TIMESTAMPING_OPTION = "view.outputTabsTimeStampsOption";
    public static final String OUTPUT_TAB_TIMESTAMP_FORMAT = "view.outputTabsTimeStampsFormat";
    private static final String SHOW_LOCAL_CONNECT_REQUESTS = "view.showLocalConnectRequests";
    private static final String USE_SYSTEMS_LOCALE_FOR_FORMAT_KEY = "view.usesystemslocaleformat";
    public static final String SPLASHSCREEN_OPTION = "view.splashScreen";
    @Deprecated
    public static final String LARGE_REQUEST_SIZE = "view.largeRequest";
    @Deprecated
    public static final String LARGE_RESPONSE_SIZE = "view.largeResponse";
    public static final String FONT_NAME = "view.fontName";
    public static final String FONT_SIZE = "view.fontSize";
    public static final String ICON_SIZE = "view.iconSize";
    public static final String SCALE_IMAGES = "view.scaleImages";
    public static final String SHOW_DEV_WARNING = "view.showDevWarning";
    public static final String LOOK_AND_FEEL = "view.lookAndFeel";
    public static final String LOOK_AND_FEEL_CLASS = "view.lookAndFeelClass";
    public static final String ALLOW_APP_INTEGRATION_IN_CONTAINERS = "view.allowAppsInContainers";
    public static final String DEFAULT_LOOK_AND_FEEL_NAME = "Flat Light";
    public static final String DEFAULT_LOOK_AND_FEEL_CLASS = "com.formdev.flatlaf.FlatLightLaf";
    public static final UIManager.LookAndFeelInfo DEFAULT_LOOK_AND_FEEL = new UIManager.LookAndFeelInfo("Flat Light", "com.formdev.flatlaf.FlatLightLaf");
    private static final String CONFIRM_REMOVE_PROXY_EXCLUDE_REGEX_KEY = "view.confirmRemoveProxyExcludeRegex";
    private static final String CONFIRM_REMOVE_SCANNER_EXCLUDE_REGEX_KEY = "view.confirmRemoveScannerExcludeRegex";
    private static final String CONFIRM_REMOVE_SPIDER_EXCLUDE_REGEX_KEY = "view.confirmRemoveSpiderExcludeRegex";
    private static final String FONT_NAME_POSTFIX = "Name";
    private static final String FONT_SIZE_POSTFIX = "Size";
    private static final String RECENT_SESSIONS_KEY = "view.recentsessions.path";
    private int advancedViewEnabled = 0;
    private int processImages = 0;
    private int showMainToolbar = 1;
    private String configLocale = "";
    private String locale = "";
    private int displayOption = 1;
    private String responsePanelPosition;
    private int brkPanelViewOption = 0;
    private int askOnExitEnabled = 1;
    private int wmUiHandlingEnabled = 0;
    private boolean warnOnTabDoubleClick = false;
    private boolean showTabNames = true;
    private String mode = Control.Mode.standard.name();
    private boolean outputTabTimeStampingEnabled = false;
    private String outputTabTimeStampFormat = DEFAULT_TIME_STAMP_FORMAT;
    private Map<FontUtils.FontType, String> fontTypePrefixes = new EnumMap<FontUtils.FontType, String>(FontUtils.FontType.class);
    private Map<FontUtils.FontType, Integer> fontSizes = new EnumMap<FontUtils.FontType, Integer>(FontUtils.FontType.class);
    private Map<FontUtils.FontType, String> fontNames = new EnumMap<FontUtils.FontType, String>(FontUtils.FontType.class);
    private int iconSize = 16;
    private List<String> recentSessions;
    private boolean showLocalConnectRequests;
    private boolean showSplashScreen = true;
    private boolean scaleImages = true;
    private boolean showDevWarning = true;
    private UIManager.LookAndFeelInfo lookAndFeelInfo = DEFAULT_LOOK_AND_FEEL;
    private boolean allowAppIntegrationInContainers;
    private boolean confirmRemoveProxyExcludeRegex;
    private boolean confirmRemoveScannerExcludeRegex;
    private boolean confirmRemoveSpiderExcludeRegex;
    private boolean useSystemsLocaleForFormat;

    public OptionsParamView() {
        this.fontTypePrefixes.put(FontUtils.FontType.general, "font");
        this.fontTypePrefixes.put(FontUtils.FontType.workPanels, "workPanelsFont");
        for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
            this.fontNames.put(fontType, "");
            this.fontSizes.put(fontType, -1);
        }
    }

    @Override
    protected void parse() {
        this.showTabNames = this.getBoolean(SHOW_TEXT_ICONS, true);
        this.processImages = this.getInt(PROCESS_IMAGES, 0);
        this.configLocale = this.getString(LOCALE, null);
        this.locale = this.getString(LOCALE, DEFAULT_LOCALE);
        this.useSystemsLocaleForFormat = this.getBoolean(USE_SYSTEMS_LOCALE_FOR_FORMAT_KEY, true);
        this.displayOption = this.getInt(DISPLAY_OPTION, 1);
        this.responsePanelPosition = this.getString(RESPONSE_PANEL_POS_KEY, WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE.name());
        this.brkPanelViewOption = this.getInt(BRK_PANEL_VIEW_OPTION, 0);
        this.showMainToolbar = this.getInt(SHOW_MAIN_TOOLBAR_OPTION, 1);
        this.advancedViewEnabled = this.getInt(ADVANCEDUI_OPTION, 0);
        this.wmUiHandlingEnabled = this.getInt(WMUIHANDLING_OPTION, 0);
        this.askOnExitEnabled = this.getInt(ASKONEXIT_OPTION, 1);
        this.warnOnTabDoubleClick = this.getBoolean(WARN_ON_TAB_DOUBLE_CLICK_OPTION, true);
        this.mode = this.getString(MODE_OPTION, Control.Mode.standard.name());
        this.outputTabTimeStampingEnabled = this.getBoolean(OUTPUT_TAB_TIMESTAMPING_OPTION, false);
        this.outputTabTimeStampFormat = this.getString(OUTPUT_TAB_TIMESTAMP_FORMAT, DEFAULT_TIME_STAMP_FORMAT);
        this.showLocalConnectRequests = this.getBoolean(SHOW_LOCAL_CONNECT_REQUESTS, false);
        this.showSplashScreen = this.getBoolean(SPLASHSCREEN_OPTION, true);
        for (FontUtils.FontType fontType : FontUtils.FontType.values()) {
            this.fontNames.put(fontType, this.getString(this.getFontNameConfKey(fontType), ""));
            this.fontSizes.put(fontType, this.getInt(this.getFontSizeConfKey(fontType), -1));
        }
        this.iconSize = this.getInt(ICON_SIZE, 16);
        this.scaleImages = this.getBoolean(SCALE_IMAGES, true);
        this.showDevWarning = this.getBoolean(SHOW_DEV_WARNING, true);
        this.lookAndFeelInfo = new UIManager.LookAndFeelInfo(this.getString(LOOK_AND_FEEL, DEFAULT_LOOK_AND_FEEL.getName()), this.getString(LOOK_AND_FEEL_CLASS, DEFAULT_LOOK_AND_FEEL.getClassName()));
        this.allowAppIntegrationInContainers = this.getBoolean(ALLOW_APP_INTEGRATION_IN_CONTAINERS, false);
        this.confirmRemoveProxyExcludeRegex = this.getBoolean(CONFIRM_REMOVE_PROXY_EXCLUDE_REGEX_KEY, false);
        this.confirmRemoveScannerExcludeRegex = this.getBoolean(CONFIRM_REMOVE_SCANNER_EXCLUDE_REGEX_KEY, false);
        this.confirmRemoveSpiderExcludeRegex = this.getBoolean(CONFIRM_REMOVE_SPIDER_EXCLUDE_REGEX_KEY, false);
        this.recentSessions = new ArrayList<String>();
        Stream.of(this.getConfig().getStringArray(RECENT_SESSIONS_KEY)).forEach(this.recentSessions::add);
    }

    public int getProcessImages() {
        return this.processImages;
    }

    public void setProcessImages(int processImages) {
        this.processImages = processImages;
        this.getConfig().setProperty(PROCESS_IMAGES, (Object)Integer.toString(processImages));
    }

    public boolean isProcessImages() {
        return this.processImages != 0;
    }

    public boolean isShowMainToolbar() {
        return this.showMainToolbar != 0;
    }

    public void setShowMainToolbar(boolean show) {
        this.showMainToolbar = show ? 1 : 0;
        this.getConfig().setProperty(SHOW_MAIN_TOOLBAR_OPTION, (Object)this.showMainToolbar);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        if (locale != null) {
            this.locale = locale;
            this.getConfig().setProperty(LOCALE, (Object)locale);
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(locale.getLanguage());
            if (locale.getCountry().length() > 0) {
                sb.append("_").append(locale.getCountry());
            }
            if (locale.getVariant().length() > 0) {
                sb.append("_").append(locale.getVariant());
            }
            this.setLocale(sb.toString());
        }
    }

    public String getConfigLocale() {
        return this.configLocale;
    }

    public boolean getShowTabNames() {
        return this.showTabNames;
    }

    public void setShowTabNames(boolean showTabNames) {
        this.showTabNames = showTabNames;
        this.getConfig().setProperty(SHOW_TEXT_ICONS, (Object)showTabNames);
    }

    public int getBrkPanelViewOption() {
        return this.brkPanelViewOption;
    }

    public void setBrkPanelViewOption(int brkPanelViewIdx) {
        this.brkPanelViewOption = brkPanelViewIdx;
        this.getConfig().setProperty(BRK_PANEL_VIEW_OPTION, (Object)Integer.toString(this.brkPanelViewOption));
    }

    public int getDisplayOption() {
        return this.displayOption;
    }

    public void setDisplayOption(int displayOption) {
        this.displayOption = displayOption;
        this.getConfig().setProperty(DISPLAY_OPTION, (Object)Integer.toString(displayOption));
    }

    public String getResponsePanelPosition() {
        return this.responsePanelPosition;
    }

    public void setResponsePanelPosition(String position) {
        this.responsePanelPosition = position;
        this.getConfig().setProperty(RESPONSE_PANEL_POS_KEY, (Object)position);
    }

    public int getAdvancedViewOption() {
        return this.advancedViewEnabled;
    }

    public void setAdvancedViewOption(int isEnabled) {
        this.advancedViewEnabled = isEnabled;
        this.getConfig().setProperty(ADVANCEDUI_OPTION, (Object)Integer.toString(isEnabled));
    }

    public void setAskOnExitOption(int isEnabled) {
        this.askOnExitEnabled = isEnabled;
        this.getConfig().setProperty(ASKONEXIT_OPTION, (Object)Integer.toString(isEnabled));
    }

    public int getAskOnExitOption() {
        return this.askOnExitEnabled;
    }

    public void setWmUiHandlingOption(int isEnabled) {
        this.wmUiHandlingEnabled = isEnabled;
        this.getConfig().setProperty(WMUIHANDLING_OPTION, (Object)Integer.toString(isEnabled));
    }

    public int getWmUiHandlingOption() {
        return this.wmUiHandlingEnabled;
    }

    public boolean getWarnOnTabDoubleClick() {
        return this.warnOnTabDoubleClick;
    }

    public void setWarnOnTabDoubleClick(boolean warnOnTabDoubleClick) {
        this.warnOnTabDoubleClick = warnOnTabDoubleClick;
        this.getConfig().setProperty(WARN_ON_TAB_DOUBLE_CLICK_OPTION, (Object)warnOnTabDoubleClick);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
        this.getConfig().setProperty(MODE_OPTION, (Object)mode);
    }

    public void setOutputTabTimeStampingEnabled(boolean enabled) {
        this.outputTabTimeStampingEnabled = enabled;
        this.getConfig().setProperty(OUTPUT_TAB_TIMESTAMPING_OPTION, (Object)enabled);
    }

    public boolean isOutputTabTimeStampingEnabled() {
        return this.outputTabTimeStampingEnabled;
    }

    public void setOutputTabTimeStampsFormat(String format) {
        this.outputTabTimeStampFormat = format;
        this.getConfig().setProperty(OUTPUT_TAB_TIMESTAMP_FORMAT, (Object)format);
    }

    public String getOutputTabTimeStampsFormat() {
        return this.outputTabTimeStampFormat;
    }

    public void setShowLocalConnectRequests(boolean showConnectRequests) {
        if (this.showLocalConnectRequests != showConnectRequests) {
            this.showLocalConnectRequests = showConnectRequests;
            this.getConfig().setProperty(SHOW_LOCAL_CONNECT_REQUESTS, (Object)showConnectRequests);
        }
    }

    public boolean isShowLocalConnectRequests() {
        return this.showLocalConnectRequests;
    }

    public boolean isShowSplashScreen() {
        return this.showSplashScreen;
    }

    public void setShowSplashScreen(boolean showSplashScreen) {
        this.showSplashScreen = showSplashScreen;
        this.getConfig().setProperty(SPLASHSCREEN_OPTION, (Object)showSplashScreen);
    }

    @Deprecated
    public int getLargeRequestSize() {
        return 100000;
    }

    @Deprecated
    public void setLargeRequestSize(int largeRequestSize) {
    }

    @Deprecated
    public int getLargeResponseSize() {
        return 100000;
    }

    @Deprecated
    public void setLargeResponseSize(int largeResponseSize) {
    }

    public boolean isAllowAppIntegrationInContainers() {
        return this.allowAppIntegrationInContainers;
    }

    public void setAllowAppIntegrationInContainers(boolean allowAppIntegrationInContainers) {
        this.allowAppIntegrationInContainers = allowAppIntegrationInContainers;
        this.getConfig().setProperty(ALLOW_APP_INTEGRATION_IN_CONTAINERS, (Object)allowAppIntegrationInContainers);
    }

    @Deprecated
    public int getFontSize() {
        return this.getFontSize(FontUtils.FontType.general);
    }

    public int getFontSize(FontUtils.FontType fontType) {
        return this.fontSizes.get((Object)fontType);
    }

    @Deprecated
    public void setFontSize(int fontSize) {
        this.setFontSize(FontUtils.FontType.general, fontSize);
    }

    public void setFontSize(FontUtils.FontType fontType, int fontSize) {
        this.fontSizes.put(fontType, fontSize);
        this.getConfig().setProperty(this.getFontSizeConfKey(fontType), (Object)fontSize);
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
        this.getConfig().setProperty(ICON_SIZE, (Object)iconSize);
    }

    @Deprecated
    public String getFontName() {
        return this.getFontName(FontUtils.FontType.general);
    }

    public String getFontName(FontUtils.FontType fontType) {
        return this.fontNames.get((Object)fontType);
    }

    @Deprecated
    public void setFontName(String fontName) {
        this.setFontName(FontUtils.FontType.general, fontName);
    }

    public void setFontName(FontUtils.FontType fontType, String fontName) {
        this.fontNames.put(fontType, fontName);
        this.getConfig().setProperty(this.getFontNameConfKey(fontType), (Object)fontName);
    }

    public String getLookAndFeel() {
        return this.lookAndFeelInfo.getName();
    }

    @Deprecated
    public void setLookAndFeel(String lookAndFeel) {
        this.setLookAndFeelInfo(new UIManager.LookAndFeelInfo(lookAndFeel, ""));
    }

    public UIManager.LookAndFeelInfo getLookAndFeelInfo() {
        return this.lookAndFeelInfo;
    }

    public void setLookAndFeelInfo(UIManager.LookAndFeelInfo lookAndFeelInfo) {
        UIManager.LookAndFeelInfo oldLookAndFeel = this.lookAndFeelInfo;
        this.lookAndFeelInfo = Objects.requireNonNull(lookAndFeelInfo);
        if (!oldLookAndFeel.getClassName().equals(this.getLookAndFeelInfo().getClassName())) {
            this.getConfig().setProperty(LOOK_AND_FEEL, (Object)lookAndFeelInfo.getName());
            this.getConfig().setProperty(LOOK_AND_FEEL_CLASS, (Object)lookAndFeelInfo.getClassName());
            if (View.isInitialised()) {
                SwitchingLookAndFeelDialog dialog = new SwitchingLookAndFeelDialog();
                ((Dialog)dialog).setVisible(true);
                Timer timer = new Timer(500, e -> {
                    try {
                        UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                        Arrays.asList(Window.getWindows()).stream().forEach(SwingUtilities::updateComponentTreeUI);
                        View.getSingleton().getPopupList().forEach(SwingUtilities::updateComponentTreeUI);
                    }
                    catch (Exception e2) {
                        LOGGER.warn("Failed to set the look and feel: {}", (Object)e2.getMessage(), (Object)e2);
                    }
                    finally {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        }
    }

    public boolean isScaleImages() {
        return this.scaleImages;
    }

    public void setScaleImages(boolean scaleImages) {
        this.scaleImages = scaleImages;
        this.getConfig().setProperty(SCALE_IMAGES, (Object)scaleImages);
    }

    public boolean isShowDevWarning() {
        return this.showDevWarning;
    }

    public void setShowDevWarning(boolean showDevWarning) {
        this.showDevWarning = showDevWarning;
        this.getConfig().setProperty(SHOW_DEV_WARNING, (Object)showDevWarning);
    }

    public boolean isConfirmRemoveProxyExcludeRegex() {
        return this.confirmRemoveProxyExcludeRegex;
    }

    public void setConfirmRemoveProxyExcludeRegex(boolean confirmRemove) {
        this.confirmRemoveProxyExcludeRegex = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_PROXY_EXCLUDE_REGEX_KEY, (Object)confirmRemove);
    }

    public boolean isConfirmRemoveScannerExcludeRegex() {
        return this.confirmRemoveScannerExcludeRegex;
    }

    public void setConfirmRemoveScannerExcludeRegex(boolean confirmRemove) {
        this.confirmRemoveScannerExcludeRegex = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_SCANNER_EXCLUDE_REGEX_KEY, (Object)confirmRemove);
    }

    public boolean isConfirmRemoveSpiderExcludeRegex() {
        return this.confirmRemoveSpiderExcludeRegex;
    }

    public void setConfirmRemoveSpiderExcludeRegex(boolean confirmRemove) {
        this.confirmRemoveSpiderExcludeRegex = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_SPIDER_EXCLUDE_REGEX_KEY, (Object)confirmRemove);
    }

    public void setUseSystemsLocaleForFormat(boolean useSystemsLocale) {
        if (this.useSystemsLocaleForFormat != useSystemsLocale) {
            this.useSystemsLocaleForFormat = useSystemsLocale;
            this.getConfig().setProperty(USE_SYSTEMS_LOCALE_FOR_FORMAT_KEY, (Object)this.useSystemsLocaleForFormat);
        }
    }

    public boolean isUseSystemsLocaleForFormat() {
        return this.useSystemsLocaleForFormat;
    }

    private String getFontConfKey(FontUtils.FontType fontType, String postfix) {
        StringBuilder result = new StringBuilder();
        result.append("view.");
        result.append(this.fontTypePrefixes.get((Object)fontType));
        result.append(postfix);
        return result.toString();
    }

    private String getFontNameConfKey(FontUtils.FontType fontType) {
        return this.getFontConfKey(fontType, FONT_NAME_POSTFIX);
    }

    private String getFontSizeConfKey(FontUtils.FontType fontType) {
        return this.getFontConfKey(fontType, FONT_SIZE_POSTFIX);
    }

    public List<String> getRecentSessions() {
        return this.recentSessions;
    }

    public void addLatestSession(String path) {
        int index = this.recentSessions.indexOf(path);
        if (index == 0) {
            return;
        }
        if (index > 0) {
            this.recentSessions.remove(index);
        }
        this.recentSessions.add(0, path);
        if (this.recentSessions.size() > 10) {
            this.recentSessions.subList(10, this.recentSessions.size()).clear();
        }
        this.getConfig().clearProperty(RECENT_SESSIONS_KEY);
        for (int i = 0; i < this.recentSessions.size(); ++i) {
            this.getConfig().setProperty("view.recentsessions.path(" + i + ")", (Object)this.recentSessions.get(i));
        }
    }

    private static class SwitchingLookAndFeelDialog
    extends AbstractDialog {
        private static final long serialVersionUID = 1L;
        private JPanel mainPanel;

        public SwitchingLookAndFeelDialog() {
            super((Frame)View.getSingleton().getMainFrame(), false);
            this.setContentPane(this.getMainPanel());
            this.pack();
        }

        private JPanel getMainPanel() {
            if (this.mainPanel == null) {
                this.mainPanel = new JPanel();
                this.mainPanel.add(new ZapHtmlLabel(Constant.messages.getString("view.options.warn.applylaf")));
            }
            return this.mainPanel;
        }
    }
}

