/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.subquery;

import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.sql.SQLFeatureNotSupportedException;
import org.opensearch.sql.legacy.rewriter.RewriteRule;
import org.opensearch.sql.legacy.rewriter.subquery.SubQueryRewriter;
import org.opensearch.sql.legacy.rewriter.subquery.rewriter.SubqueryAliasRewriter;
import org.opensearch.sql.legacy.rewriter.subquery.utils.FindSubQuery;

public class SubQueryRewriteRule
implements RewriteRule<SQLQueryExpr> {
    private final FindSubQuery findAllSubQuery = new FindSubQuery();

    @Override
    public boolean match(SQLQueryExpr expr) throws SQLFeatureNotSupportedException {
        expr.accept((SQLASTVisitor)this.findAllSubQuery);
        if (this.isContainSubQuery(this.findAllSubQuery)) {
            if (this.isSupportedSubQuery(this.findAllSubQuery)) {
                return true;
            }
            throw new SQLFeatureNotSupportedException("Unsupported subquery. Only one EXISTS or IN is supported");
        }
        return false;
    }

    @Override
    public void rewrite(SQLQueryExpr expr) {
        expr.accept((SQLASTVisitor)new SubqueryAliasRewriter());
        new SubQueryRewriter().convert(expr.getSubQuery());
    }

    private boolean isContainSubQuery(FindSubQuery allSubQuery) {
        return !allSubQuery.getSqlExistsExprs().isEmpty() || !allSubQuery.getSqlInSubQueryExprs().isEmpty();
    }

    private boolean isSupportedSubQuery(FindSubQuery allSubQuery) {
        return allSubQuery.getSqlInSubQueryExprs().size() == 1 && allSubQuery.getSqlExistsExprs().size() == 0 || allSubQuery.getSqlInSubQueryExprs().size() == 0 && allSubQuery.getSqlExistsExprs().size() == 1;
    }
}

