﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/opensearch/OpenSearchService_EXPORTS.h>
#include <aws/opensearch/model/VPCDerivedInfo.h>
#include <aws/opensearch/model/VpcEndpointStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace OpenSearchService {
namespace Model {

/**
 * <p>The connection endpoint for connecting to an Amazon OpenSearch Service domain
 * through a proxy.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/opensearch-2021-01-01/VpcEndpoint">AWS
 * API Reference</a></p>
 */
class VpcEndpoint {
 public:
  AWS_OPENSEARCHSERVICE_API VpcEndpoint() = default;
  AWS_OPENSEARCHSERVICE_API VpcEndpoint(Aws::Utils::Json::JsonView jsonValue);
  AWS_OPENSEARCHSERVICE_API VpcEndpoint& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OPENSEARCHSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier of the endpoint.</p>
   */
  inline const Aws::String& GetVpcEndpointId() const { return m_vpcEndpointId; }
  inline bool VpcEndpointIdHasBeenSet() const { return m_vpcEndpointIdHasBeenSet; }
  template <typename VpcEndpointIdT = Aws::String>
  void SetVpcEndpointId(VpcEndpointIdT&& value) {
    m_vpcEndpointIdHasBeenSet = true;
    m_vpcEndpointId = std::forward<VpcEndpointIdT>(value);
  }
  template <typename VpcEndpointIdT = Aws::String>
  VpcEndpoint& WithVpcEndpointId(VpcEndpointIdT&& value) {
    SetVpcEndpointId(std::forward<VpcEndpointIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creator of the endpoint.</p>
   */
  inline const Aws::String& GetVpcEndpointOwner() const { return m_vpcEndpointOwner; }
  inline bool VpcEndpointOwnerHasBeenSet() const { return m_vpcEndpointOwnerHasBeenSet; }
  template <typename VpcEndpointOwnerT = Aws::String>
  void SetVpcEndpointOwner(VpcEndpointOwnerT&& value) {
    m_vpcEndpointOwnerHasBeenSet = true;
    m_vpcEndpointOwner = std::forward<VpcEndpointOwnerT>(value);
  }
  template <typename VpcEndpointOwnerT = Aws::String>
  VpcEndpoint& WithVpcEndpointOwner(VpcEndpointOwnerT&& value) {
    SetVpcEndpointOwner(std::forward<VpcEndpointOwnerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the domain associated with the
   * endpoint.</p>
   */
  inline const Aws::String& GetDomainArn() const { return m_domainArn; }
  inline bool DomainArnHasBeenSet() const { return m_domainArnHasBeenSet; }
  template <typename DomainArnT = Aws::String>
  void SetDomainArn(DomainArnT&& value) {
    m_domainArnHasBeenSet = true;
    m_domainArn = std::forward<DomainArnT>(value);
  }
  template <typename DomainArnT = Aws::String>
  VpcEndpoint& WithDomainArn(DomainArnT&& value) {
    SetDomainArn(std::forward<DomainArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Options to specify the subnets and security groups for an Amazon OpenSearch
   * Service VPC endpoint.</p>
   */
  inline const VPCDerivedInfo& GetVpcOptions() const { return m_vpcOptions; }
  inline bool VpcOptionsHasBeenSet() const { return m_vpcOptionsHasBeenSet; }
  template <typename VpcOptionsT = VPCDerivedInfo>
  void SetVpcOptions(VpcOptionsT&& value) {
    m_vpcOptionsHasBeenSet = true;
    m_vpcOptions = std::forward<VpcOptionsT>(value);
  }
  template <typename VpcOptionsT = VPCDerivedInfo>
  VpcEndpoint& WithVpcOptions(VpcOptionsT&& value) {
    SetVpcOptions(std::forward<VpcOptionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the endpoint.</p>
   */
  inline VpcEndpointStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(VpcEndpointStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline VpcEndpoint& WithStatus(VpcEndpointStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The connection endpoint ID for connecting to the domain.</p>
   */
  inline const Aws::String& GetEndpoint() const { return m_endpoint; }
  inline bool EndpointHasBeenSet() const { return m_endpointHasBeenSet; }
  template <typename EndpointT = Aws::String>
  void SetEndpoint(EndpointT&& value) {
    m_endpointHasBeenSet = true;
    m_endpoint = std::forward<EndpointT>(value);
  }
  template <typename EndpointT = Aws::String>
  VpcEndpoint& WithEndpoint(EndpointT&& value) {
    SetEndpoint(std::forward<EndpointT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_vpcEndpointId;

  Aws::String m_vpcEndpointOwner;

  Aws::String m_domainArn;

  VPCDerivedInfo m_vpcOptions;

  VpcEndpointStatus m_status{VpcEndpointStatus::NOT_SET};

  Aws::String m_endpoint;
  bool m_vpcEndpointIdHasBeenSet = false;
  bool m_vpcEndpointOwnerHasBeenSet = false;
  bool m_domainArnHasBeenSet = false;
  bool m_vpcOptionsHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_endpointHasBeenSet = false;
};

}  // namespace Model
}  // namespace OpenSearchService
}  // namespace Aws
