/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class ForStatement
extends Statement {
    public static final TokenRole FOR_KEYWORD_ROLE = new TokenRole("for", 1);
    public static final Role<Statement> INITIALIZER_ROLE = new Role<Statement>("Initializer", Statement.class, Statement.NULL);
    public static final Role<Statement> ITERATOR_ROLE = new Role<Statement>("Iterator", Statement.class, Statement.NULL);

    public ForStatement(int offset) {
        super(offset);
    }

    public final JavaTokenNode getForToken() {
        return this.getChildByRole(FOR_KEYWORD_ROLE);
    }

    public final Statement getEmbeddedStatement() {
        return this.getChildByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final void setEmbeddedStatement(Statement value) {
        this.setChildByRole(Roles.EMBEDDED_STATEMENT, value);
    }

    public final Expression getCondition() {
        return this.getChildByRole(Roles.CONDITION);
    }

    public final void setCondition(Expression value) {
        this.setChildByRole(Roles.CONDITION, value);
    }

    public final JavaTokenNode getLeftParenthesisToken() {
        return this.getChildByRole(Roles.LEFT_PARENTHESIS);
    }

    public final JavaTokenNode getRightParenthesisToken() {
        return this.getChildByRole(Roles.RIGHT_PARENTHESIS);
    }

    public final AstNodeCollection<Statement> getInitializers() {
        return this.getChildrenByRole(INITIALIZER_ROLE);
    }

    public final AstNodeCollection<Statement> getIterators() {
        return this.getChildrenByRole(ITERATOR_ROLE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitForStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ForStatement) {
            ForStatement otherStatement = (ForStatement)other;
            return !other.isNull() && this.getInitializers().matches(otherStatement.getInitializers(), match) && this.getCondition().matches(otherStatement.getCondition(), match) && this.getIterators().matches(otherStatement.getIterators(), match) && this.getEmbeddedStatement().matches(otherStatement.getEmbeddedStatement(), match);
        }
        return false;
    }
}

