/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import jakarta.annotation.Priority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import org.apache.webbeans.util.PriorityClass;

public class PriorityClasses {
    private final List<PriorityClass> raw = new ArrayList<PriorityClass>();
    private List<Class<?>> sorted;

    public OptionalInt getPriority(Class<?> type) {
        return this.raw.stream().filter(it -> it.getClazz() == type).mapToInt(PriorityClass::getPriority).findFirst();
    }

    public void add(Class<?> clazz, Priority priority) {
        this.raw.add(new PriorityClass(clazz, priority.value()));
        this.sorted = null;
    }

    public void add(Class<?> clazz, int priority) {
        this.raw.add(new PriorityClass(clazz, priority));
        this.sorted = null;
    }

    public List<Class<?>> getSorted() {
        if (this.sorted == null) {
            Collections.sort(this.raw);
            this.sorted = new ArrayList(this.raw.size());
            for (PriorityClass priorityAlternative : this.raw) {
                this.sorted.add(priorityAlternative.getClazz());
            }
        }
        return this.sorted;
    }

    public boolean contains(Class<?> beanType) {
        return this.getSorted().contains(beanType);
    }

    public void clear() {
        this.raw.clear();
        this.sorted = null;
    }
}

