/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonToken;
import wiremock.com.fasterxml.jackson.databind.BeanProperty;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;
import wiremock.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import wiremock.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import wiremock.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import wiremock.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public abstract class ReferenceTypeDeserializer<T>
extends StdDeserializer<T>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final JsonDeserializer<?> _valueDeserializer;

    public ReferenceTypeDeserializer(JavaType fullType, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(fullType);
        this._fullType = fullType;
        this._valueDeserializer = deser;
        this._valueTypeDeserializer = typeDeser;
    }

    public ReferenceTypeDeserializer(JavaType fullType, ValueInstantiator inst, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        this(fullType, typeDeser, deser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        deser = deser == null ? ctxt.findContextualValueDeserializer(this._fullType.getReferencedType(), property) : ctxt.handleSecondaryContextualization(deser, property, this._fullType.getReferencedType());
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        if (deser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return this.withResolved(typeDeser, deser);
    }

    protected abstract ReferenceTypeDeserializer<T> withResolved(TypeDeserializer var1, JsonDeserializer<?> var2);

    @Override
    public abstract T getNullValue(DeserializationContext var1);

    public abstract T referenceValue(Object var1);

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object contents = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        return this.referenceValue(contents);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue(ctxt);
        }
        if (this._valueTypeDeserializer == null) {
            return this.deserialize(p, ctxt);
        }
        return this.referenceValue(this._valueTypeDeserializer.deserializeTypedFromAny(p, ctxt));
    }
}

