/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.LogicalHandler;
import jakarta.xml.ws.handler.PortInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.xml.namespace.QName;
import org.apache.openejb.client.ClientInjectionProcessor;
import org.apache.openejb.client.HandlerChainMetaData;
import org.apache.openejb.client.HandlerMetaData;
import org.apache.openejb.client.Injection;

public class ClientHandlerResolverImpl
implements HandlerResolver {
    private final List<HandlerChainMetaData> handlerChains;
    private final List<Injection> injections;
    private final Context context;
    private final List<ClientInjectionProcessor<Handler>> handlerInstances = new ArrayList<ClientInjectionProcessor<Handler>>();
    private static final Map<String, String> BINDING_MAP = new HashMap<String, String>();

    public ClientHandlerResolverImpl(List<HandlerChainMetaData> handlerChains, List<Injection> injections, Context context) {
        this.handlerChains = handlerChains;
        this.injections = injections;
        this.context = context;
    }

    public void destroyHandlers() {
        ArrayList<ClientInjectionProcessor<Handler>> handlerInstances = new ArrayList<ClientInjectionProcessor<Handler>>(this.handlerInstances);
        this.handlerInstances.clear();
        for (ClientInjectionProcessor clientInjectionProcessor : handlerInstances) {
            clientInjectionProcessor.preDestroy();
        }
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        List<Handler> chain = new ArrayList<Handler>();
        for (HandlerChainMetaData handlerChain : this.handlerChains) {
            List<Handler> handlers = this.buildHandlers(portInfo, handlerChain);
            handlers = this.sortHandlers(handlers);
            chain.addAll(handlers);
        }
        chain = this.sortHandlers(chain);
        return chain;
    }

    private List<Handler> buildHandlers(PortInfo portInfo, HandlerChainMetaData handlerChain) {
        if (!(this.matchServiceName(portInfo, handlerChain.getServiceNamePattern()) && this.matchPortName(portInfo, handlerChain.getPortNamePattern()) && this.matchBinding(portInfo, handlerChain.getProtocolBindings()))) {
            return Collections.emptyList();
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(handlerChain.getHandlers().size());
        for (HandlerMetaData handler : handlerChain.getHandlers()) {
            try {
                Class<Handler> handlerClass = this.loadClass(handler.getHandlerClass()).asSubclass(Handler.class);
                ClientInjectionProcessor<Handler> processor = new ClientInjectionProcessor<Handler>(handlerClass, this.injections, handler.getPostConstruct(), handler.getPreDestroy(), this.context);
                processor.createInstance();
                processor.postConstruct();
                Handler handlerInstance = processor.getInstance();
                handlers.add(handlerInstance);
                this.handlerInstances.add(processor);
            }
            catch (Exception e) {
                throw new WebServiceException("Failed to instantiate handler", (Throwable)e);
            }
        }
        return handlers;
    }

    private boolean matchServiceName(PortInfo info, QName namePattern) {
        return this.match(info == null ? null : info.getServiceName(), namePattern);
    }

    private boolean matchPortName(PortInfo info, QName namePattern) {
        return this.match(info == null ? null : info.getPortName(), namePattern);
    }

    private boolean matchBinding(PortInfo info, List bindings) {
        return this.match(info == null ? null : info.getBindingID(), bindings);
    }

    private boolean match(String binding, List bindings) {
        if (binding == null) {
            return bindings == null || bindings.isEmpty();
        }
        if (bindings == null || bindings.isEmpty()) {
            return true;
        }
        String actualBindingURI = ClientHandlerResolverImpl.getBindingURI(binding);
        for (Object o : bindings) {
            String bindingToken = (String)o;
            String bindingURI = ClientHandlerResolverImpl.getBindingURI(bindingToken);
            if (!actualBindingURI.equals(bindingURI)) continue;
            return true;
        }
        return false;
    }

    private boolean match(QName name, QName namePattern) {
        if (name == null) {
            return namePattern == null || namePattern.getLocalPart().equals("*");
        }
        if (namePattern == null) {
            return true;
        }
        if (namePattern.getNamespaceURI() != null && !name.getNamespaceURI().equals(namePattern.getNamespaceURI())) {
            return false;
        }
        String localNamePattern = namePattern.getLocalPart();
        if (localNamePattern.equals("*")) {
            return true;
        }
        if (localNamePattern.endsWith("*")) {
            localNamePattern = localNamePattern.substring(0, localNamePattern.length() - 1);
            return name.getLocalPart().startsWith(localNamePattern);
        }
        return name.getLocalPart().equals(localNamePattern);
    }

    private List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        for (Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }

    private static String getBindingURI(String token) {
        if (token != null) {
            if (token.startsWith("##")) {
                String uri = BINDING_MAP.get(token);
                if (uri == null) {
                    throw new IllegalArgumentException("Unsupported binding token: " + token);
                }
                return uri;
            }
            return token;
        }
        return BINDING_MAP.get("##SOAP11_HTTP");
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        return Class.forName(name);
    }

    static {
        BINDING_MAP.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        BINDING_MAP.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        BINDING_MAP.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        BINDING_MAP.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        BINDING_MAP.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
    }
}

