/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.step.GType;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GValue<V>
implements Serializable {
    private final String name;
    private final GType type;
    private final V value;

    private GValue(GType type, V value) {
        this(null, type, value);
    }

    private GValue(String name, GType type, V value) {
        if (name != null && name.startsWith("_")) {
            throw new IllegalArgumentException(String.format("Invalid GValue name [%s]. Should not start with _.", name));
        }
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public boolean isVariable() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public GType getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public V get() {
        return this.value;
    }

    public String toString() {
        return this.isVariable() ? String.format("%s=%s", this.name, this.value) : Objects.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GValue gValue = (GValue)o;
        return Objects.equals(this.name, gValue.name) && this.type == gValue.type && Objects.equals(this.value, gValue.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.value});
    }

    static <V> GValue<V> of(V value) {
        if (value instanceof GValue) {
            return (GValue)value;
        }
        return new GValue<V>(GType.getType(value), value);
    }

    public static <V> GValue<V> of(String name, V value) {
        if (value instanceof GValue) {
            throw new IllegalArgumentException("value cannot be a GValue");
        }
        return new GValue<V>(name, GType.getType(value), value);
    }

    static GValue<String> ofString(String value) {
        return new GValue<String>(GType.STRING, value);
    }

    public static GValue<String> ofString(String name, String value) {
        return new GValue<String>(name, GType.STRING, value);
    }

    static GValue<Integer> ofInteger(Integer value) {
        return new GValue<Integer>(GType.INTEGER, value);
    }

    public static GValue<Integer> ofInteger(String name, Integer value) {
        return new GValue<Integer>(name, GType.INTEGER, value);
    }

    static GValue<Boolean> ofBoolean(Boolean value) {
        return new GValue<Boolean>(GType.BOOLEAN, value);
    }

    public static GValue<Boolean> ofBoolean(String name, Boolean value) {
        return new GValue<Boolean>(name, GType.BOOLEAN, value);
    }

    static GValue<Double> ofDouble(Double value) {
        return new GValue<Double>(GType.DOUBLE, value);
    }

    public static GValue<Double> ofDouble(String name, Double value) {
        return new GValue<Double>(name, GType.DOUBLE, value);
    }

    static GValue<BigInteger> ofBigInteger(BigInteger value) {
        return new GValue<BigInteger>(GType.BIG_INTEGER, value);
    }

    public static GValue<BigInteger> ofBigInteger(String name, BigInteger value) {
        return new GValue<BigInteger>(name, GType.BIG_INTEGER, value);
    }

    static GValue<BigDecimal> ofBigDecimal(BigDecimal value) {
        return new GValue<BigDecimal>(GType.BIG_DECIMAL, value);
    }

    public static GValue<BigDecimal> ofBigDecimal(String name, BigDecimal value) {
        return new GValue<BigDecimal>(name, GType.BIG_DECIMAL, value);
    }

    static GValue<Long> ofLong(Long value) {
        return new GValue<Long>(GType.LONG, value);
    }

    public static GValue<Long> ofLong(String name, Long value) {
        return new GValue<Long>(name, GType.LONG, value);
    }

    static GValue<Map> ofMap(Map value) {
        return new GValue<Map>(GType.MAP, value);
    }

    public static GValue<Map> ofMap(String name, Map value) {
        return new GValue<Map>(name, GType.MAP, value);
    }

    static <T> GValue<List<T>> ofList(List<T> value) {
        return new GValue<List<T>>(GType.LIST, value);
    }

    public static <T> GValue<List<T>> ofList(String name, List<T> value) {
        return new GValue<List<T>>(name, GType.LIST, value);
    }

    static GValue<Set> ofSet(Set value) {
        return new GValue<Set>(GType.SET, value);
    }

    public static GValue<Set> ofSet(String name, Set value) {
        return new GValue<Set>(name, GType.SET, value);
    }

    static GValue<Vertex> ofVertex(Vertex value) {
        return new GValue<Vertex>(GType.VERTEX, value);
    }

    public static GValue<Vertex> ofVertex(String name, Vertex value) {
        return new GValue<Vertex>(name, GType.VERTEX, value);
    }

    public static <T> T getFrom(Object o) {
        return (T)(o instanceof GValue ? ((GValue)o).get() : o);
    }

    public static boolean valueInstanceOf(Object o, GType type) {
        return o instanceof GValue && ((GValue)o).getType() == type;
    }

    public static boolean valueInstanceOfCollection(Object o) {
        return o instanceof GValue && ((GValue)o).getType().isCollection();
    }

    public static boolean valueInstanceOfNumeric(Object o) {
        return o instanceof GValue && ((GValue)o).getType().isNumeric();
    }

    public static boolean instanceOf(Object o, GType type) {
        if (null == o) {
            return false;
        }
        if (o instanceof GValue) {
            return ((GValue)o).getType() == type;
        }
        return type.getJavaType().isAssignableFrom(o.getClass());
    }

    public static boolean instanceOfCollection(Object o) {
        return o instanceof Collection || GValue.valueInstanceOfCollection(o);
    }

    public static boolean instanceOfNumber(Object o) {
        return o instanceof Number || GValue.valueInstanceOfNumeric(o);
    }

    public static <T> GValue<T>[] ensureGValues(Object[] args) {
        return (GValue[])Stream.of(args).map(GValue::of).toArray(GValue[]::new);
    }

    public static Object[] resolveToValues(GValue<?>[] gvalues) {
        Object[] values = new Object[gvalues.length];
        for (int i = 0; i < gvalues.length; ++i) {
            values[i] = gvalues[i].get();
        }
        return values;
    }

    public static Object valueOf(Object either) {
        if (either instanceof GValue) {
            return ((GValue)either).get();
        }
        return either;
    }

    public static Number numberOf(Object either) {
        Object o = GValue.valueOf(either);
        if (o instanceof Number) {
            return (Number)o;
        }
        throw new IllegalStateException("Argument is not a number");
    }
}

