/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.impl;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.Attribute;
import org.apache.tiles.api.AttributeContext;
import org.apache.tiles.api.BasicAttributeContext;
import org.apache.tiles.api.Definition;
import org.apache.tiles.api.TilesContainer;
import org.apache.tiles.api.preparer.ViewPreparer;
import org.apache.tiles.core.definition.DefinitionsFactory;
import org.apache.tiles.core.definition.NoSuchDefinitionException;
import org.apache.tiles.core.evaluator.AttributeEvaluator;
import org.apache.tiles.core.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.core.evaluator.AttributeEvaluatorFactoryAware;
import org.apache.tiles.core.prepare.factory.NoSuchPreparerException;
import org.apache.tiles.core.prepare.factory.PreparerFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.render.RendererFactory;

public class BasicTilesContainer
implements TilesContainer,
AttributeEvaluatorFactoryAware {
    private static final String ATTRIBUTE_CONTEXT_STACK = "org.apache.tiles.AttributeContext.STACK";
    private static final Logger LOG = LogManager.getLogger(BasicTilesContainer.class);
    private ApplicationContext context;
    private DefinitionsFactory definitionsFactory;
    private PreparerFactory preparerFactory;
    private RendererFactory rendererFactory;
    private AttributeEvaluatorFactory attributeEvaluatorFactory;

    @Override
    public AttributeContext startContext(Request request) {
        BasicAttributeContext context = new BasicAttributeContext();
        Deque<AttributeContext> stack = this.getContextStack(request);
        if (!stack.isEmpty()) {
            AttributeContext parent = stack.peek();
            context.inheritCascadedAttributes(parent);
        }
        stack.push(context);
        return context;
    }

    @Override
    public void endContext(Request request) {
        this.popContext(request);
    }

    @Override
    public void renderContext(Request request) {
        AttributeContext attributeContext = this.getAttributeContext(request);
        this.render(request, attributeContext);
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public AttributeContext getAttributeContext(Request request) {
        AttributeContext context = this.getContext(request);
        if (context == null) {
            context = new BasicAttributeContext();
            this.pushContext(context, request);
        }
        return context;
    }

    public void setDefinitionsFactory(DefinitionsFactory definitionsFactory) {
        this.definitionsFactory = definitionsFactory;
    }

    public void setPreparerFactory(PreparerFactory preparerFactory) {
        this.preparerFactory = preparerFactory;
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
    }

    @Override
    public void setAttributeEvaluatorFactory(AttributeEvaluatorFactory attributeEvaluatorFactory) {
        this.attributeEvaluatorFactory = attributeEvaluatorFactory;
    }

    @Override
    public void prepare(String preparer, Request request) {
        this.prepare(request, preparer, false);
    }

    @Override
    public void render(String definitionName, Request request) {
        LOG.debug("Render request received for definition '{}'", (Object)definitionName);
        Definition definition = this.getDefinition(definitionName, request);
        if (definition == null) {
            throw new NoSuchDefinitionException("Unable to find the definition '" + definitionName + "'");
        }
        this.render(definition, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Definition definition, Request request) {
        AttributeContext originalContext = this.getAttributeContext(request);
        BasicAttributeContext subContext = new BasicAttributeContext(originalContext);
        subContext.inherit(definition);
        this.pushContext(subContext, request);
        try {
            this.render(request, subContext);
        }
        finally {
            this.popContext(request);
        }
    }

    @Override
    public void render(Attribute attr, Request request) throws IOException {
        if (attr == null) {
            throw new CannotRenderException("Cannot render a null attribute");
        }
        if (attr.isPermitted(request)) {
            Renderer renderer = this.rendererFactory.getRenderer(attr.getRenderer());
            Object value = this.evaluate(attr, request);
            if (!(value instanceof String)) {
                throw new CannotRenderException("Cannot render an attribute that is not a string, toString returns: " + value);
            }
            renderer.render((String)value, request);
        }
    }

    @Override
    public Object evaluate(Attribute attribute, Request request) {
        AttributeEvaluator evaluator = this.attributeEvaluatorFactory.getAttributeEvaluator(attribute);
        return evaluator.evaluate(attribute, request);
    }

    @Override
    public boolean isValidDefinition(String definitionName, Request request) {
        try {
            Definition definition = this.getDefinition(definitionName, request);
            return definition != null;
        }
        catch (NoSuchDefinitionException nsde) {
            LOG.debug("Cannot find definition '{}'", (Object)definitionName);
            LOG.debug("Exception related to the not found definition", (Throwable)nsde);
            return false;
        }
    }

    @Override
    public Definition getDefinition(String definitionName, Request request) {
        return this.definitionsFactory.getDefinition(definitionName, request);
    }

    protected Deque<AttributeContext> getContextStack(Request tilesContext) {
        Map<String, Object> requestScope = tilesContext.getContext("request");
        LinkedList contextStack = (LinkedList)requestScope.get(ATTRIBUTE_CONTEXT_STACK);
        if (contextStack == null) {
            contextStack = new LinkedList();
            requestScope.put(ATTRIBUTE_CONTEXT_STACK, contextStack);
        }
        return contextStack;
    }

    protected void pushContext(AttributeContext context, Request tilesContext) {
        Deque<AttributeContext> contextStack = this.getContextStack(tilesContext);
        contextStack.push(context);
    }

    protected AttributeContext popContext(Request tilesContext) {
        Deque<AttributeContext> contextStack = this.getContextStack(tilesContext);
        return contextStack.pop();
    }

    protected AttributeContext getContext(Request tilesContext) {
        Deque<AttributeContext> contextStack = this.getContextStack(tilesContext);
        if (!contextStack.isEmpty()) {
            return contextStack.peek();
        }
        return null;
    }

    private void prepare(Request context, String preparerName, boolean ignoreMissing) {
        LOG.debug("Prepare request received for '{}'", (Object)preparerName);
        ViewPreparer preparer = this.preparerFactory.getPreparer(preparerName, context);
        if (preparer == null && ignoreMissing) {
            return;
        }
        if (preparer == null) {
            throw new NoSuchPreparerException("Preparer '" + preparerName + " not found");
        }
        AttributeContext attributeContext = this.getContext(context);
        preparer.execute(context, attributeContext);
    }

    protected void render(Request request, AttributeContext attributeContext) {
        try {
            if (attributeContext.getPreparer() != null) {
                this.prepare(request, attributeContext.getPreparer(), true);
            }
            this.render(attributeContext.getTemplateAttribute(), request);
        }
        catch (IOException e) {
            throw new CannotRenderException(e.getMessage(), e);
        }
    }
}

