/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.schema.Schema;
import java.util.ArrayList;
import java.util.List;

public class Concatenation
extends Expression {
    private final ImmutableList<Expression> values;

    private Concatenation(Node fromNode, Schema schema, List<Expression> values) {
        super(fromNode, schema);
        this.values = ImmutableList.copyOf(values);
        if (values.size() < 2) {
            throw new IllegalArgumentException("Concatenation cannot have only " + values.size() + " values.");
        }
    }

    public static Expression create(SourcePosition sourcePosition, Schema schema, List<Expression> values) {
        int len = (values = Concatenation.simplify(schema, values)).size();
        if (len == 0) {
            return new StringConstant(sourcePosition, schema, "");
        }
        if (len == 1) {
            return values.get(0);
        }
        return new Concatenation(values.get(0), schema, values);
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public Expression withValues(List<Expression> newValues) {
        return Iterables.elementsEqual(newValues, this.values) ? this : Concatenation.create(this.getSourcePosition(), this.getSchema(), newValues);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitConcatenation(this);
    }

    private static final List<Expression> simplify(Schema schema, List<Expression> values) {
        ArrayList<Expression> result = Lists.newArrayList();
        Node fromNode = null;
        StringBuilder sb = new StringBuilder();
        if ((fromNode = Concatenation.simplifyHelper(schema, values, result, fromNode, sb)) != null && sb.length() > 0) {
            result.add(new StringConstant(fromNode, schema, sb.toString()));
        }
        return result;
    }

    private static final Node simplifyHelper(Schema schema, List<Expression> values, List<Expression> result, Node fromNode, StringBuilder sb) {
        for (Expression value : values) {
            if ((value = Preconditions.checkNotNull(value)) instanceof StringConstant) {
                if (fromNode == null) {
                    fromNode = value;
                }
                StringConstant str = (StringConstant)value;
                sb.append(str.evaluate());
                continue;
            }
            if (value instanceof Concatenation) {
                Concatenation subConcatenation = (Concatenation)value;
                fromNode = Concatenation.simplifyHelper(schema, subConcatenation.values, result, fromNode, sb);
                continue;
            }
            if (fromNode != null) {
                if (sb.length() > 0) {
                    result.add(new StringConstant(fromNode, schema, sb.toString()));
                    sb.setLength(0);
                }
                fromNode = null;
            }
            result.add(value);
        }
        return fromNode;
    }

    @Override
    public boolean hasStaticString() {
        for (Expression e : this.getValues()) {
            if (e.hasStaticString()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Concatenation && this.equals((Concatenation)that);
    }

    public boolean equals(Concatenation that) {
        return this.equalsExpression(that) && Iterables.elementsEqual(this.values, that.values);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.values);
    }

    @Override
    public List<Expression> separate() {
        return this.getValues();
    }
}

