/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.streampipes.dataexplorer.influx;

import java.util.Arrays;
import java.util.List;

public class InfluxDbReservedKeywords {

  public static final List<String> KEYWORD_LIST = Arrays.asList(
      "ALL",
      "ALTER",
      "ANALYZE",
      "ANY",
      "AS",
      "ASC",
      "BEGIN",
      "BY",
      "CREATE",
      "CONTINUOUS",
      "DATABASE",
      "DATABASES",
      "DEFAULT",
      "DELETE",
      "DESC",
      "DESTINATIONS",
      "DIAGNOSTICS",
      "DISTINCT",
      "DROP",
      "DURATION",
      "END",
      "EVERY",
      "EXPLAIN",
      "FIELD",
      "FOR",
      "FROM",
      "GRANT",
      "GRANTS",
      "GROUP",
      "GROUPS",
      "IN",
      "INF",
      "INSERT",
      "INTO",
      "KEY",
      "KEYS",
      "KILL",
      "LIMIT",
      "SHOW",
      "MEASUREMENT",
      "MEASUREMENTS",
      "NAME",
      "OFFSET",
      "ON",
      "ORDER",
      "PASSWORD",
      "POLICY",
      "POLICIES",
      "PRIVILEGES",
      "QUERIES",
      "QUERY",
      "READ",
      "REPLICATION",
      "RESAMPLE",
      "RETENTION",
      "REVOKE",
      "SELECT",
      "SERIES",
      "SET",
      "SHARD",
      "SHARDS",
      "SLIMIT",
      "SOFFSET",
      "STATS",
      "SUBSCRIPTION",
      "SUBSCRIPTIONS",
      "TAG",
      "TO",
      "USER",
      "USERS",
      "VALUES",
      "WHERE",
      "WITH",
      "WRITE"
  );
}
