/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.testutil;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class ModelAdapterFactoryUtil {
    private ModelAdapterFactoryUtil() {
    }

    public static void addModelsForPackage(BundleContext bundleContext, Class ... classes) {
        ModelsPackageBundle bundle = new ModelsPackageBundle(classes, 32, bundleContext);
        BundleEvent event = new BundleEvent(2, (Bundle)bundle);
        MockOsgi.sendBundleEvent((BundleContext)bundleContext, (BundleEvent)event);
    }

    private static class ModelsPackageBundle
    implements Bundle {
        private final Class[] classes;
        private final int state;
        private final BundleContext bundleContext;

        public ModelsPackageBundle(Class[] classes, int state, BundleContext bundleContext) {
            this.classes = classes;
            this.state = state;
            this.bundleContext = bundleContext;
        }

        public int getState() {
            return this.state;
        }

        public Dictionary<String, String> getHeaders() {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put("Sling-Model-Packages", "dummy.package");
            return headers;
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            Vector<URL> urls = new Vector<URL>();
            for (int i = 0; i < this.classes.length; ++i) {
                try {
                    urls.add(new URL("file:/" + this.classes[i].getName().replace('.', '/') + ".class"));
                    continue;
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Malformed URL.", ex);
                }
            }
            return urls.elements();
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.getClass().getClassLoader().loadClass(name);
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return null;
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            return null;
        }

        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public File getDataFile(String filename) {
            throw new UnsupportedOperationException();
        }

        public <A> A adapt(Class<A> type) {
            throw new UnsupportedOperationException();
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            throw new UnsupportedOperationException();
        }

        public Version getVersion() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Bundle o) {
            throw new UnsupportedOperationException();
        }
    }
}

