/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing.delegate.viaoriginalresource;

import java.util.HashMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.it.testbundle.delegate.viaoriginalresource.A;
import org.apache.sling.models.it.testbundle.delegate.viaoriginalresource.models.A1Impl;
import org.apache.sling.models.it.testbundle.delegate.viaoriginalresource.models.AImpl;
import org.apache.sling.models.it.testbundle.delegate.viaoriginalresource.models.B1Impl;
import org.apache.sling.models.it.testbundle.delegate.viaoriginalresource.models.BImpl;
import org.apache.sling.models.it.testing.rtbound.FakeRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ViaOriginalResourceDelegationIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ResourceResolverFactory rrFactory;
    private ModelFactory modelFactory;
    private final String genericComponent = "/apps/delegate/nestedrtbound/generic";
    private final String specificComponent = "/apps/delegate/nestedrtbound/specific";
    private final String genericContent = "/content/delegate/nestedrtbound/generic";
    private final String specificContent = "/content/delegate/nestedrtbound/specific";

    @Before
    public void setup() throws LoginException, PersistenceException {
        this.rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.modelFactory = (ModelFactory)this.teleporter.getService(ModelFactory.class);
        try (ResourceResolver adminResolver = this.rrFactory.getServiceResourceResolver(null);){
            HashMap<String, String> properties = new HashMap<String, String>();
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/apps/delegate/nestedrtbound/generic", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceSuperType", "delegate/nestedrtbound/generic");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/apps/delegate/nestedrtbound/specific", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceType", "delegate/nestedrtbound/generic");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/delegate/nestedrtbound/generic", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceType", "delegate/nestedrtbound/specific");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/delegate/nestedrtbound/specific", properties, null, (boolean)false);
            properties.clear();
            adminResolver.commit();
        }
    }

    @Test
    public void testGenericModelFromRequest() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource content = resolver.getResource("/content/delegate/nestedrtbound/generic");
            FakeRequest baseRequest = new FakeRequest(content);
            A model = (A)this.modelFactory.createModel((Object)baseRequest, A.class);
            Assert.assertTrue((boolean)(model instanceof AImpl));
            Assert.assertTrue((boolean)(((AImpl)model).other instanceof BImpl));
        }
    }

    @Test
    public void testSpecificModelFromRequest() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource content = resolver.getResource("/content/delegate/nestedrtbound/specific");
            FakeRequest baseRequest = new FakeRequest(content);
            A model = (A)this.modelFactory.createModel((Object)baseRequest, A.class);
            Assert.assertTrue((boolean)(model instanceof A1Impl));
            Assert.assertTrue((boolean)(((A1Impl)model).other instanceof B1Impl));
            Assert.assertTrue((boolean)(((A1Impl)model).delegate instanceof AImpl));
            Assert.assertTrue((boolean)(((AImpl)((A1Impl)model).delegate).other instanceof B1Impl));
            Assert.assertSame((Object)((A1Impl)model).other, (Object)((AImpl)((A1Impl)model).delegate).other);
        }
    }

    @Test
    public void testGenericModelFromResource() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource content = resolver.getResource("/content/delegate/nestedrtbound/generic");
            A model = (A)this.modelFactory.createModel((Object)content, A.class);
            Assert.assertTrue((boolean)(model instanceof AImpl));
            Assert.assertTrue((boolean)(((AImpl)model).other instanceof BImpl));
        }
    }

    @Test
    public void testSpecificModelFromResource() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource content = resolver.getResource("/content/delegate/nestedrtbound/specific");
            A model = (A)this.modelFactory.createModel((Object)content, A.class);
            Assert.assertTrue((boolean)(model instanceof A1Impl));
            Assert.assertTrue((boolean)(((A1Impl)model).other instanceof B1Impl));
            Assert.assertTrue((boolean)(((A1Impl)model).delegate instanceof AImpl));
            Assert.assertTrue((boolean)(((AImpl)((A1Impl)model).delegate).other instanceof B1Impl));
            Assert.assertSame((Object)((A1Impl)model).other, (Object)((AImpl)((A1Impl)model).delegate).other);
        }
    }
}

