/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.ops4j.pax.tinybundles.TinyBundle;
import org.ops4j.pax.tinybundles.TinyBundles;

public class GenerateTestBundle {
    private static final String DUMMY_TEXT = "Dummy file for Integration Test bundle.";

    public static void main(String[] args) throws Exception {
        Path outputFile = Paths.get(args[0], new String[0]);
        try (InputStream bundleStream = GenerateTestBundle.createBundle().build(TinyBundles.bndBuilder());){
            Files.copy(bundleStream, outputFile, new CopyOption[0]);
        }
        System.out.println("Test bundle created at " + String.valueOf(outputFile.toAbsolutePath()));
    }

    static TinyBundle createBundle() {
        TinyBundle bundle = TinyBundles.bundle().setHeader("Bundle-Name", "Apache Sling Models Implementation - IT Test Bundle").setHeader("Bundle-Version", "1.0.0-SNAPSHOT").setHeader("Export-Package", "org.apache.sling.models.it.testbundle.*").setHeader("Import-Package", "org.apache.commons.beanutils;resolution:=optional,*").addResource("META-INF/LICENSE", (InputStream)new ByteArrayInputStream(DUMMY_TEXT.getBytes(StandardCharsets.UTF_8))).addResource("META-INF/NOTICE", (InputStream)new ByteArrayInputStream(DUMMY_TEXT.getBytes(StandardCharsets.UTF_8)));
        bundle.addClass(SlingServletPaths.class);
        TreeSet modelClassNames = new TreeSet();
        GenerateTestBundle.getAllClasses().forEach(clazz -> {
            bundle.addClass(clazz);
            if (clazz.isAnnotationPresent(Model.class)) {
                modelClassNames.add(clazz.getName());
            }
        });
        bundle.setHeader("Sling-Model-Classes", modelClassNames.stream().collect(Collectors.joining(",")));
        return bundle;
    }

    static List<Class<?>> getAllClasses() {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(new String[]{"org.apache.sling.models.it.testbundle"}).scan();){
            List<Class<?>> list = scanResult.getAllClasses().stream().map(ClassInfo::loadClass).collect(Collectors.toList());
            return list;
        }
    }
}

