/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collections;
import java.util.HashMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.interfaces.SubClassModel;
import org.apache.sling.models.testmodels.interfaces.SuperClassModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InterfaceInheritanceTest {
    private ModelAdapterFactory factory;

    InterfaceInheritanceTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        ValueMapInjector valueMapInjector = new ValueMapInjector();
        this.factory.injectors = Collections.singletonList(valueMapInjector);
        this.factory.injectAnnotationProcessorFactories = Collections.singletonList(valueMapInjector);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{SuperClassModel.class, SubClassModel.class});
    }

    @Test
    void testSimplePropertyModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("superClassString", "first-value");
        map.put("subClassString", "second-value");
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        SubClassModel model = (SubClassModel)this.factory.getAdapter((Object)res, SubClassModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"first-value", (Object)model.getSuperClassString());
        Assertions.assertEquals((Object)"second-value", (Object)model.getSubClassString());
    }
}

