/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.shared.common.error.StandardException;

public abstract class ContainerBasicOperation
implements Loggable {
    private long containerVersion;
    protected ContainerKey containerId;
    protected transient RawContainerHandle containerHdl = null;
    private transient boolean foundHere = false;

    protected ContainerBasicOperation(RawContainerHandle rawContainerHandle) throws StandardException {
        this.containerHdl = rawContainerHandle;
        this.containerId = rawContainerHandle.getId();
        this.containerVersion = rawContainerHandle.getContainerVersion();
    }

    public ContainerBasicOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.containerId.writeExternal(objectOutput);
        CompressedNumber.writeLong(objectOutput, this.containerVersion);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.containerId = ContainerKey.read(objectInput);
        this.containerVersion = CompressedNumber.readLong(objectInput);
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void releaseResource(Transaction transaction) {
        if (!this.foundHere) {
            return;
        }
        if (this.containerHdl != null) {
            this.containerHdl.close();
            this.containerHdl = null;
        }
        this.foundHere = false;
    }

    @Override
    public int group() {
        return 256;
    }

    protected RawContainerHandle findContainer(Transaction transaction) throws StandardException {
        this.releaseResource(transaction);
        RawTransaction rawTransaction = (RawTransaction)transaction;
        this.containerHdl = rawTransaction.openDroppedContainer(this.containerId, null);
        if (rawTransaction.inRollForwardRecovery() && this.containerHdl == null) {
            this.containerHdl = this.findContainerForRedoRecovery(rawTransaction);
        }
        if (this.containerHdl == null) {
            throw StandardException.newException((String)"40XD2", (Object[])new Object[]{this.containerId});
        }
        this.foundHere = true;
        return this.containerHdl;
    }

    protected RawContainerHandle findContainerForRedoRecovery(RawTransaction rawTransaction) throws StandardException {
        return null;
    }

    @Override
    public boolean needsRedo(Transaction transaction) throws StandardException {
        this.findContainer(transaction);
        long l = this.containerHdl.getContainerVersion();
        if (l == this.containerVersion) {
            return true;
        }
        this.releaseResource(transaction);
        if (l > this.containerVersion) {
            return false;
        }
        return false;
    }

    public String toString() {
        return null;
    }
}

