/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.collection.TreeTables;
import org.apache.sis.util.resources.Vocabulary;

final class InfoCommand
extends FormattedOutputCommand {
    private int gridBitMask = 117;

    static EnumSet<Option> options() {
        return EnumSet.of(Option.METADATA, new Option[]{Option.LOCALE, Option.TIMEZONE, Option.COLORS, Option.VERBOSE, Option.HELP, Option.DEBUG});
    }

    InfoCommand(int commandIndex, Object[] arguments) throws InvalidOptionException {
        super(commandIndex, arguments, InfoCommand.options(), OutputFormat.TEXT);
        if (this.options.containsKey((Object)Option.VERBOSE)) {
            this.gridBitMask |= 0xA;
        }
    }

    @Override
    public int run() throws Exception {
        InputStream input;
        if (this.useStandardInput()) {
            input = System.in;
        } else {
            this.hasUnexpectedFileCount = this.hasUnexpectedFileCount(1, 1);
            if (this.hasUnexpectedFileCount) {
                return 3;
            }
            input = this.files.get(0);
        }
        DefaultTreeTable tree = new DefaultTreeTable(new TableColumn[]{TableColumn.VALUE_AS_TEXT});
        try (DataStore store = DataStores.open((Object)input);){
            this.define(tree.getRoot(), (Resource)store);
        }
        catch (BackingStoreException e) {
            throw (DataStoreException)e.unwrapOrRethrow(DataStoreException.class);
        }
        TreeTableFormat tf = new TreeTableFormat(this.locale, this.getTimeZone());
        tf.format((TreeTable)tree, (Appendable)this.out);
        return 0;
    }

    private void define(TreeTable.Node target, Resource source) throws DataStoreException {
        String name = source.getIdentifier().map(id -> id.toInternationalString().toString(this.locale)).orElseGet(() -> Vocabulary.forLocale((Locale)this.locale).getString((short)208));
        target.setValue(TableColumn.VALUE_AS_TEXT, (Object)name);
        if (source instanceof GridCoverageResource) {
            GridCoverageResource grid = (GridCoverageResource)source;
            TreeTable.Node root = grid.getGridGeometry().toTree(this.locale, this.gridBitMask).getRoot();
            TreeTables.moveChildren((TreeTable.Node)root, (TreeTable.Node)target);
            this.toTree(grid.getSampleDimensions(), target.newChild(), (TableColumn<? super String>)TableColumn.VALUE_AS_TEXT);
        } else if (source instanceof Aggregate) {
            for (Resource component : ((Aggregate)source).components()) {
                this.define(target.newChild(), component);
            }
        }
    }

    private void toTree(Iterable<SampleDimension> bands, TreeTable.Node target, TableColumn<? super String> column) {
        target.setValue(column, (Object)Vocabulary.forLocale((Locale)this.locale).getString((short)178));
        RangeFormat rf = new RangeFormat(this.locale, this.getTimeZone());
        StringBuffer sb = new StringBuffer();
        for (SampleDimension band : bands) {
            band = band.forConvertedValues(true);
            TreeTable.Node bn = target.newChild();
            bn.setValue(column, (Object)band.getName().toInternationalString().toString(this.locale));
            for (Category category : band.getCategories()) {
                TreeTable.Node cn = bn.newChild();
                sb.append(category.getName().toString(this.locale)).append(" (");
                rf.format((Object)category.getSampleRange(), sb, null).append(')');
                cn.setValue(column, (Object)sb.toString());
                sb.setLength(0);
            }
        }
    }
}

