/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.feature.Property;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.internal.shared.Visitor;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

final class ExpressionOperation<V>
extends AbstractOperation {
    private static final long serialVersionUID = 5411697964136428848L;
    private static final ParameterDescriptorGroup PARAMETERS = ExpressionOperation.parameters("Expression", new ParameterDescriptor[0]);
    final Function<? super AbstractFeature, ? extends V> expression;
    private final DefaultAttributeType<V> resultType;
    private final Set<String> dependencies;

    static <V> AbstractOperation create(Map<String, ?> identification, Function<? super AbstractFeature, ? extends V> expression, DefaultAttributeType<? super V> resultType) {
        String xpath;
        if (expression instanceof ValueReference && (xpath = ((ValueReference)expression).getXPath()).equals(resultType.getName().toString())) {
            return new LinkOperation(identification, resultType);
        }
        return new ExpressionOperation<V>(identification, expression, resultType);
    }

    private ExpressionOperation(Map<String, ?> identification, Function<? super AbstractFeature, ? extends V> expression, DefaultAttributeType<V> resultType) {
        super(identification);
        this.expression = expression;
        this.resultType = resultType;
        if (expression instanceof Expression) {
            Expression c = (Expression)expression;
            this.dependencies = DependencyFinder.search(c);
        } else {
            this.dependencies = Set.of();
        }
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return PARAMETERS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.expression.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.expression.equals(((ExpressionOperation)obj).expression);
    }

    private static final class DependencyFinder
    extends Visitor<AbstractFeature, Collection<String>> {
        private static final DependencyFinder VISITOR = new DependencyFinder();

        static Set<String> search(Expression<AbstractFeature, ?> expression) {
            HashSet dependencies = new HashSet();
            VISITOR.visit(expression, dependencies);
            return Set.copyOf(dependencies);
        }

        private DependencyFinder() {
            this.setLogicalHandlers((f, dependencies) -> {
                LogicalOperator filter = (LogicalOperator)f;
                for (Filter child : filter.getOperands()) {
                    this.visit(child, dependencies);
                }
            });
            this.setExpressionHandler("ValueReference", (e, dependencies) -> {
                ValueReference expression = (ValueReference)e;
                String propName = expression.getXPath();
                if (!propName.trim().isEmpty()) {
                    dependencies.add(propName);
                }
            });
        }

        @Override
        protected void typeNotFound(Enum<?> type, Filter<AbstractFeature> filter, Collection<String> dependencies) {
            for (Expression<AbstractFeature, ?> f : filter.getExpressions()) {
                this.visit(f, dependencies);
            }
        }

        @Override
        protected void typeNotFound(String type, Expression<AbstractFeature, ?> expression, Collection<String> dependencies) {
            for (Expression<AbstractFeature, ?> p : expression.getParameters()) {
                this.visit(p, dependencies);
            }
        }
    }

    private final class Result
    extends OperationResult<V> {
        private static final long serialVersionUID = -19004252522001532L;

        Result(AbstractFeature feature) {
            super(ExpressionOperation.this.resultType, feature);
        }

        @Override
        public V getValue() {
            return ExpressionOperation.this.expression.apply(this.feature);
        }
    }
}

