/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.util.function.Function;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SliceGeometry
implements Function<RenderedImage, GridGeometry> {
    private final GridGeometry geometry;
    private final GridExtent sliceExtent;
    private final int[] gridDimensions;
    private int[] crsDimensions;
    private final MathTransformFactory factory;

    SliceGeometry(GridGeometry geometry, GridExtent sliceExtent, int[] gridDimensions, MathTransformFactory factory) {
        this.geometry = geometry;
        this.sliceExtent = sliceExtent;
        this.gridDimensions = gridDimensions;
        this.factory = ReferencingUtilities.nonNull((MathTransformFactory)factory);
    }

    @Override
    public GridGeometry apply(RenderedImage image) {
        try {
            GridExtent extent = new GridExtent(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
            return this.reduce(extent, 2);
        }
        catch (FactoryException e) {
            throw SliceGeometry.canNotCompute(e);
        }
    }

    final GridGeometry reduce(GridExtent relativeExtent, int dimCRS) throws FactoryException {
        boolean useSubExtent;
        GridExtent extent = this.geometry.extent;
        MathTransform gridToCRS = this.geometry.gridToCRS;
        MathTransform cornerToCRS = this.geometry.cornerToCRS;
        double[] resolution = this.geometry.resolution;
        this.crsDimensions = this.gridDimensions;
        if (gridToCRS != null) {
            TransformSeparator sep = new TransformSeparator(gridToCRS, this.factory);
            sep.addSourceDimensions(this.gridDimensions);
            this.crsDimensions = SliceGeometry.findTargetDimensions(gridToCRS, extent, resolution, this.gridDimensions, dimCRS);
            if (this.crsDimensions != null) {
                sep.addTargetDimensions(this.crsDimensions);
            }
            gridToCRS = sep.separate();
            this.crsDimensions = sep.getTargetDimensions();
            sep = new TransformSeparator(cornerToCRS, this.factory);
            sep.addSourceDimensions(this.gridDimensions);
            sep.addTargetDimensions(this.crsDimensions);
            cornerToCRS = sep.separate();
        }
        boolean bl = useSubExtent = this.sliceExtent != null && !this.sliceExtent.equals(extent, ComparisonMode.IGNORE_METADATA);
        if (useSubExtent) {
            extent = this.sliceExtent;
        }
        if (extent != null) {
            extent = extent.selectDimensions(this.gridDimensions);
        }
        GeneralEnvelope subArea = null;
        if (useSubExtent && cornerToCRS != null) {
            try {
                subArea = extent.toEnvelope(cornerToCRS, false, gridToCRS, null);
            }
            catch (TransformException e) {
                GridGeometry.recoverableException("reduce", e);
            }
        }
        int n = this.crsDimensions.length;
        ImmutableEnvelope envelope = this.geometry.envelope;
        if (envelope != null) {
            if (subArea != null || envelope.getDimension() != n) {
                int i;
                CoordinateReferenceSystem crs = CRS.selectDimensions((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem(), (int[])this.crsDimensions);
                double[] min = new double[n];
                double[] max = new double[n];
                for (i = 0; i < n; ++i) {
                    int j = this.crsDimensions[i];
                    min[i] = envelope.getLower(j);
                    max[i] = envelope.getUpper(j);
                }
                if (subArea != null) {
                    for (i = 0; i < n; ++i) {
                        double d;
                        double d2;
                        double v = subArea.getLower(i);
                        if (d2 > min[i]) {
                            min[i] = v;
                        }
                        v = subArea.getUpper(i);
                        if (!(d < max[i])) continue;
                        max[i] = v;
                    }
                }
                envelope = new ImmutableEnvelope(min, max, crs);
            }
        } else if (subArea != null) {
            envelope = new ImmutableEnvelope((Envelope)subArea);
        }
        if (useSubExtent || resolution == null) {
            resolution = GridGeometry.resolution(gridToCRS, extent, PixelInCell.CELL_CENTER);
        } else if (resolution.length != n) {
            resolution = new double[n];
            for (int i = 0; i < n; ++i) {
                resolution[i] = this.geometry.resolution[this.crsDimensions[i]];
            }
        }
        if (relativeExtent != null) {
            if (extent != null && !extent.startsAtZero()) {
                double[] offset = new double[this.gridDimensions.length];
                for (int i = 0; i < this.gridDimensions.length; ++i) {
                    offset[i] = extent.getLow(this.gridDimensions[i]);
                }
                LinearTransform translation = MathTransforms.translation((double[])offset);
                if (gridToCRS != null) {
                    gridToCRS = this.factory.createConcatenatedTransform((MathTransform)translation, gridToCRS);
                    cornerToCRS = this.factory.createConcatenatedTransform((MathTransform)translation, cornerToCRS);
                }
            }
            extent = relativeExtent;
        }
        long nonLinears = 0L;
        for (int i = 0; i < n; ++i) {
            nonLinears |= (this.geometry.nonLinears >>> this.crsDimensions[i] & 1L) << i;
        }
        return new GridGeometry(extent, gridToCRS, cornerToCRS, envelope, resolution, nonLinears);
    }

    private static int[] findTargetDimensions(MathTransform gridToCRS, GridExtent extent, double[] resolution, int[] gridDimensions, int dimCRS) {
        int numRow = -1;
        Matrix derivative = MathTransforms.getMatrix((MathTransform)gridToCRS);
        if (derivative == null) {
            if (extent != null) {
                try {
                    derivative = gridToCRS.derivative((DirectPosition)new DirectPositionView.Double(extent.getPointOfInterest(PixelInCell.CELL_CENTER)));
                }
                catch (TransformException e) {
                    GridGeometry.recoverableException("reduce", e);
                    return null;
                }
            } else {
                return null;
            }
            numRow = 0;
        }
        numRow += derivative.getNumRow();
        if (dimCRS < 0) {
            dimCRS = Math.min(gridDimensions.length, gridToCRS.getTargetDimensions());
        }
        long selected = 0L;
        while (Long.bitCount(selected) < dimCRS) {
            double max = -1.0;
            int kmax = -1;
            int jmax = -1;
            for (int j = 0; j < numRow; ++j) {
                double t;
                if ((selected & Numerics.bitmask((int)j)) != 0L) continue;
                double r = 1.0;
                if (resolution != null && (t = resolution[j]) > 0.0) {
                    r = t;
                }
                for (int k = 0; k < gridDimensions.length; ++k) {
                    double e = Math.abs(derivative.getElement(j, gridDimensions[k])) / r;
                    if (!(e > max)) continue;
                    max = e;
                    kmax = k;
                    jmax = j;
                }
            }
            if ((kmax | jmax) < 0) {
                return null;
            }
            if (max > 0.0) {
                if (jmax >= 64) {
                    throw GridGeometry.excessiveDimension(gridToCRS);
                }
                selected |= 1L << jmax;
            }
            gridDimensions = ArraysExt.remove((int[])gridDimensions, (int)kmax, (int)1);
        }
        int[] crsDimensions = new int[dimCRS];
        for (int i = 0; i < dimCRS; ++i) {
            int j;
            crsDimensions[i] = j = Long.numberOfTrailingZeros(selected);
            selected &= 1L << j ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return crsDimensions;
    }

    final int[] getTargetDimensions() {
        return this.crsDimensions;
    }

    static ImagingOpException canNotCompute(FactoryException e) {
        throw (ImagingOpException)new ImagingOpException(Errors.format((short)9, (Object)"ImageGeometry")).initCause(e);
    }
}

