/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.StringBuilders;

public final class CharSequences
extends Static {
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final String[] SPACES = new String[10];

    private CharSequences() {
    }

    private static int codePointAfter(CharSequence text, int index) {
        return Character.codePointAt(text, index + Character.charCount(Character.codePointAt(text, index)));
    }

    public static CharSequence spaces(final int length) {
        if (length <= 0) {
            return "";
        }
        if (length < SPACES.length) {
            String s = SPACES[length - 1];
            if (s == null) {
                char[] spaces = new char[length];
                Arrays.fill(spaces, ' ');
                CharSequences.SPACES[length - 1] = s = new String(spaces).intern();
            }
            return s;
        }
        return new CharSequence(){

            @Override
            public int length() {
                return length;
            }

            @Override
            public char charAt(int index) {
                Objects.checkIndex(index, length);
                return ' ';
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                Objects.checkFromToIndex(start, end, length);
                int n = end - start;
                return n == length ? this : CharSequences.spaces(n);
            }

            @Override
            public String toString() {
                char[] array = new char[length];
                Arrays.fill(array, ' ');
                return new String(array);
            }
        };
    }

    public static int length(CharSequence text) {
        return text != null ? text.length() : 0;
    }

    public static int codePointCount(CharSequence text) {
        return text != null ? CharSequences.codePointCount(text, 0, text.length()) : 0;
    }

    public static int codePointCount(CharSequence text, int fromIndex, int toIndex) {
        CharBuffer buffer;
        if (text == null) {
            return 0;
        }
        if (text instanceof String) {
            return ((String)text).codePointCount(fromIndex, toIndex);
        }
        if (text instanceof StringBuilder) {
            return ((StringBuilder)text).codePointCount(fromIndex, toIndex);
        }
        if (text instanceof StringBuffer) {
            return ((StringBuffer)text).codePointCount(fromIndex, toIndex);
        }
        if (text instanceof CharBuffer && (buffer = (CharBuffer)text).hasArray() && !buffer.isReadOnly()) {
            int position = buffer.position();
            return Character.codePointCount(buffer.array(), position + fromIndex, position + toIndex);
        }
        return Character.codePointCount(text, fromIndex, toIndex);
    }

    public static int count(CharSequence text, String toSearch) {
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        int length = toSearch.length();
        if (length == 1) {
            return CharSequences.count(text, toSearch.charAt(0));
        }
        int n = 0;
        if (text != null) {
            int i = 0;
            while ((i = CharSequences.indexOf(text, toSearch, i, text.length())) >= 0) {
                ++n;
                i += length;
            }
        }
        return n;
    }

    public static int count(CharSequence text, char toSearch) {
        int n;
        block4: {
            n = 0;
            if (text == null) break block4;
            if (text instanceof String) {
                String s = (String)text;
                int i = s.indexOf(toSearch);
                while (++i != 0) {
                    ++n;
                    i = s.indexOf(toSearch, i);
                }
            } else {
                int i = text.length();
                while (--i >= 0) {
                    if (text.charAt(i) != toSearch) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public static int indexOf(CharSequence text, CharSequence toSearch, int fromIndex, int toIndex) {
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        if (text != null) {
            int length = text.length();
            if (toIndex > length) {
                toIndex = length;
            }
            if (toSearch instanceof String && toIndex == length) {
                if (text instanceof String) {
                    return ((String)text).indexOf((String)toSearch, fromIndex);
                }
                if (text instanceof StringBuilder) {
                    return ((StringBuilder)text).indexOf((String)toSearch, fromIndex);
                }
                if (text instanceof StringBuffer) {
                    return ((StringBuffer)text).indexOf((String)toSearch, fromIndex);
                }
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            length = toSearch.length();
            toIndex -= length;
            while (fromIndex <= toIndex) {
                block10: {
                    for (int i = 0; i < length; ++i) {
                        if (text.charAt(fromIndex + i) == toSearch.charAt(i)) {
                            continue;
                        }
                        break block10;
                    }
                    return fromIndex;
                }
                ++fromIndex;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence text, int toSearch, int fromIndex, int toIndex) {
        if (text != null) {
            int length = text.length();
            if (toIndex >= length) {
                if (text instanceof String) {
                    return ((String)text).indexOf(toSearch, fromIndex);
                }
                toIndex = length;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            char head = (char)toSearch;
            char tail = '\u0000';
            if (head != toSearch) {
                head = Character.highSurrogate(toSearch);
                tail = Character.lowSurrogate(toSearch);
                --toIndex;
            }
            while (fromIndex < toIndex) {
                if (text.charAt(fromIndex) == head && (tail == '\u0000' || text.charAt(fromIndex + 1) == tail)) {
                    return fromIndex;
                }
                ++fromIndex;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence text, int toSearch, int fromIndex, int toIndex) {
        if (text != null) {
            int length;
            if (fromIndex <= 0) {
                if (text instanceof String) {
                    return ((String)text).lastIndexOf(toSearch, toIndex - 1);
                }
                fromIndex = 0;
            }
            if (toIndex > (length = text.length())) {
                toIndex = length;
            }
            char tail = (char)toSearch;
            char head = '\u0000';
            if (tail != toSearch) {
                tail = Character.lowSurrogate(toSearch);
                head = Character.highSurrogate(toSearch);
                ++fromIndex;
            }
            while (toIndex > fromIndex) {
                if (text.charAt(--toIndex) != tail || head != '\u0000' && text.charAt(--toIndex) != head) continue;
                return toIndex;
            }
        }
        return -1;
    }

    public static int indexOfLineStart(CharSequence text, int numLines, int fromIndex) {
        char c;
        int length = text.length();
        if (numLines <= 0) {
            while (true) {
                if (fromIndex == 0) {
                    return fromIndex;
                }
                if ((c = text.charAt(--fromIndex)) == '\n') {
                    if (fromIndex != 0 && text.charAt(fromIndex - 1) == '\r') {
                        --fromIndex;
                    }
                } else if (c != '\r') continue;
                if (++numLines == 1) break;
            }
        }
        block1: while (--numLines >= 0) {
            do {
                if (fromIndex == length) {
                    return fromIndex;
                }
                if ((c = text.charAt(fromIndex++)) != '\r') continue;
                if (fromIndex == length || text.charAt(fromIndex) != '\n') continue block1;
                ++fromIndex;
                continue block1;
            } while (c != '\n');
        }
        return fromIndex;
    }

    public static int skipLeadingWhitespaces(CharSequence text, int fromIndex, int toIndex) {
        int c;
        while (fromIndex < toIndex && Character.isWhitespace(c = Character.codePointAt(text, fromIndex))) {
            fromIndex += Character.charCount(c);
        }
        return fromIndex;
    }

    public static int skipTrailingWhitespaces(CharSequence text, int fromIndex, int toIndex) {
        int c;
        while (toIndex > fromIndex && Character.isWhitespace(c = Character.codePointBefore(text, toIndex))) {
            toIndex -= Character.charCount(c);
        }
        return toIndex;
    }

    private static CharSequence[] createSplitArray(CharSequence text) {
        return text instanceof String || text instanceof StringBuilder || text instanceof StringBuffer ? new String[8] : new CharSequence[8];
    }

    public static CharSequence[] split(CharSequence text, char separator) {
        CharSequence item;
        if (text == null) {
            return EMPTY_ARRAY;
        }
        if (separator == '\n' || separator == '\r') {
            CharSequence[] split = CharSequences.splitOnEOL(text);
            for (int i = 0; i < split.length; ++i) {
                split[i] = CharSequences.trimWhitespaces(split[i]);
            }
            return split;
        }
        boolean excludeEmpty = Character.isWhitespace(separator);
        CharSequence[] split = CharSequences.createSplitArray(text);
        int length = text.length();
        int count = 0;
        int last = 0;
        int i = 0;
        while ((i = CharSequences.indexOf(text, separator, i, length)) >= 0) {
            item = CharSequences.trimWhitespaces(text, last, i);
            if (!excludeEmpty || item.length() != 0) {
                if (count == split.length) {
                    split = Arrays.copyOf(split, count << 1);
                }
                split[count++] = item;
            }
            last = ++i;
        }
        item = CharSequences.trimWhitespaces(text, last, length);
        if (!excludeEmpty || item.length() != 0) {
            if (count == split.length) {
                split = Arrays.copyOf(split, count + 1);
            }
            split[count++] = item;
        }
        return ArraysExt.resize(split, count);
    }

    public static CharSequence[] splitOnEOL(CharSequence text) {
        boolean hasMore;
        if (text == null) {
            return EMPTY_ARRAY;
        }
        int length = text.length();
        int lf = CharSequences.indexOf(text, 10, 0, length);
        int cr = CharSequences.indexOf(text, 13, 0, length);
        if (lf < 0 && cr < 0) {
            return new CharSequence[]{text};
        }
        int count = 0;
        CharSequence[] split = CharSequences.createSplitArray(text);
        int last = 0;
        do {
            int splitAt;
            int skip = 1;
            if (cr < 0) {
                splitAt = lf;
                hasMore = (lf = CharSequences.indexOf(text, 10, lf + 1, length)) >= 0;
            } else if (lf < 0) {
                splitAt = cr;
                hasMore = (cr = CharSequences.indexOf(text, 13, cr + 1, length)) >= 0;
            } else if (lf < cr) {
                splitAt = lf;
                hasMore = true;
                lf = CharSequences.indexOf(text, 10, lf + 1, length);
            } else {
                splitAt = cr++;
                if (lf == cr) {
                    cr = CharSequences.indexOf(text, 13, cr + 1, length);
                    lf = CharSequences.indexOf(text, 10, lf + 1, length);
                    hasMore = cr >= 0 || lf >= 0;
                    skip = 2;
                } else {
                    cr = CharSequences.indexOf(text, 13, cr + 1, length);
                    hasMore = true;
                }
            }
            if (count >= split.length) {
                split = Arrays.copyOf(split, count * 2);
            }
            split[count++] = text.subSequence(last, splitAt);
            last = splitAt + skip;
        } while (hasMore);
        if (count >= split.length) {
            split = Arrays.copyOf(split, count + 1);
        }
        split[count++] = text.subSequence(last, text.length());
        return ArraysExt.resize(split, count);
    }

    private static boolean isEmpty(CharSequence[] tokens) {
        switch (tokens.length) {
            case 0: {
                return true;
            }
            case 1: {
                return tokens[0].length() == 0;
            }
        }
        return false;
    }

    public static double[] parseDoubles(CharSequence values, char separator) throws NumberFormatException {
        CharSequence[] tokens = CharSequences.split(values, separator);
        if (CharSequences.isEmpty(tokens)) {
            return ArraysExt.EMPTY_DOUBLE;
        }
        double[] parsed = new double[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = CharSequences.trimWhitespaces(tokens[i]).toString();
            parsed[i] = token.isEmpty() ? Double.NaN : Double.parseDouble(token);
        }
        return parsed;
    }

    public static float[] parseFloats(CharSequence values, char separator) throws NumberFormatException {
        CharSequence[] tokens = CharSequences.split(values, separator);
        if (CharSequences.isEmpty(tokens)) {
            return ArraysExt.EMPTY_FLOAT;
        }
        float[] parsed = new float[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = CharSequences.trimWhitespaces(tokens[i]).toString();
            parsed[i] = token.isEmpty() ? Float.NaN : Float.parseFloat(token);
        }
        return parsed;
    }

    public static long[] parseLongs(CharSequence values, char separator, int radix) throws NumberFormatException {
        CharSequence[] tokens = CharSequences.split(values, separator);
        if (CharSequences.isEmpty(tokens)) {
            return ArraysExt.EMPTY_LONG;
        }
        long[] parsed = new long[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parsed[i] = Long.parseLong(CharSequences.trimWhitespaces(tokens[i]).toString(), radix);
        }
        return parsed;
    }

    public static int[] parseInts(CharSequence values, char separator, int radix) throws NumberFormatException {
        CharSequence[] tokens = CharSequences.split(values, separator);
        if (CharSequences.isEmpty(tokens)) {
            return ArraysExt.EMPTY_INT;
        }
        int[] parsed = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parsed[i] = Integer.parseInt(CharSequences.trimWhitespaces(tokens[i]).toString(), radix);
        }
        return parsed;
    }

    public static short[] parseShorts(CharSequence values, char separator, int radix) throws NumberFormatException {
        CharSequence[] tokens = CharSequences.split(values, separator);
        if (CharSequences.isEmpty(tokens)) {
            return ArraysExt.EMPTY_SHORT;
        }
        short[] parsed = new short[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parsed[i] = Short.parseShort(CharSequences.trimWhitespaces(tokens[i]).toString(), radix);
        }
        return parsed;
    }

    public static byte[] parseBytes(CharSequence values, char separator, int radix) throws NumberFormatException {
        CharSequence[] tokens = CharSequences.split(values, separator);
        if (CharSequences.isEmpty(tokens)) {
            return ArraysExt.EMPTY_BYTE;
        }
        byte[] parsed = new byte[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parsed[i] = Byte.parseByte(CharSequences.trimWhitespaces(tokens[i]).toString(), radix);
        }
        return parsed;
    }

    public static CharSequence toASCII(CharSequence text) {
        return StringBuilders.toASCII(text, null);
    }

    public static CharSequence trimWhitespaces(CharSequence text) {
        if (text != null) {
            text = CharSequences.trimWhitespaces(text, 0, text.length());
        }
        return text;
    }

    public static CharSequence trimWhitespaces(CharSequence text, int lower, int upper) {
        int length = CharSequences.length(text);
        Objects.checkFromToIndex(lower, upper, length);
        if (text != null) {
            lower = CharSequences.skipLeadingWhitespaces(text, lower, upper);
            upper = CharSequences.skipTrailingWhitespaces(text, lower, upper);
            if (lower != 0 || upper != length) {
                text = text.subSequence(lower, upper);
            }
        }
        return text;
    }

    public static CharSequence trimIgnorables(CharSequence text) {
        if (text != null) {
            int n;
            int length = text.length();
            for (int i = 0; i < length; i += n) {
                int c = Character.codePointAt(text, i);
                n = Character.charCount(c);
                if (!Character.isIdentifierIgnorable(c)) continue;
                StringBuilder buffer = new StringBuilder(length - n).append(text, 0, i);
                while ((i += n) < length) {
                    c = Character.codePointAt(text, i);
                    n = Character.charCount(c);
                    if (Character.isIdentifierIgnorable(c)) continue;
                    buffer.appendCodePoint(c);
                }
                return buffer.toString();
            }
        }
        return text;
    }

    public static CharSequence trimFractionalPart(CharSequence value) {
        if (value != null) {
            int c;
            block4: for (int i = value.length(); i > 0; i -= Character.charCount(c)) {
                c = Character.codePointBefore(value, i);
                switch (c) {
                    case 48: {
                        continue block4;
                    }
                    case 46: {
                        return value.subSequence(0, i);
                    }
                }
                return value;
            }
        }
        return value;
    }

    public static CharSequence shortSentence(CharSequence text, int maxLength) {
        int length;
        int toRemove;
        ArgumentChecks.ensureStrictlyPositive("maxLength", maxLength);
        if (text != null && (toRemove = (length = text.length()) - maxLength) > 0) {
            toRemove += 5;
            int lower = length >>> 1;
            if (lower != 0 && Character.isLowSurrogate(text.charAt(lower))) {
                --lower;
            }
            int upper = lower;
            boolean forward = false;
            block5: do {
                int nc = 0;
                int type = 0;
                boolean bl = forward = !forward;
                while (true) {
                    int c;
                    if (forward) {
                        if ((upper += nc) == length) continue block5;
                        c = Character.codePointAt(text, upper);
                    } else {
                        if ((lower -= nc) == 0) continue block5;
                        c = Character.codePointBefore(text, lower);
                    }
                    nc = Character.charCount(c);
                    if (Character.isWhitespace(c)) {
                        if (type != 0) {
                            type = 12;
                        }
                    } else {
                        switch (type) {
                            case 12: {
                                continue block5;
                            }
                            case 0: {
                                type = Character.isUnicodeIdentifierPart(c) ? 1 : Character.getType(c);
                                break;
                            }
                            case 1: {
                                if (Character.isUnicodeIdentifierPart(c)) break;
                                continue block5;
                            }
                            default: {
                                if (Character.getType(c) != type) continue block5;
                            }
                        }
                    }
                    toRemove -= nc;
                }
            } while (toRemove > 0);
            text = new StringBuilder(lower + (length - upper) + 5).append(text, 0, lower).append(" (\u2026) ").append(text, upper, length);
        }
        return text;
    }

    public static CharSequence upperCaseToSentence(CharSequence identifier) {
        int c;
        if (identifier == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(identifier.length());
        int length = identifier.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = Character.codePointAt(identifier, i);
            if (i != 0) {
                c = c == 95 ? 32 : Character.toLowerCase(c);
            }
            buffer.appendCodePoint(c);
        }
        return buffer;
    }

    public static CharSequence camelCaseToSentence(CharSequence identifier) {
        StringBuilder buffer;
        if (identifier == null) {
            return null;
        }
        if (CharSequences.isCode(identifier)) {
            if (identifier instanceof String) {
                return ((String)identifier).replace('_', '-');
            }
            buffer = new StringBuilder(identifier);
            StringBuilders.replace(buffer, '_', '-');
        } else {
            buffer = (StringBuilder)CharSequences.camelCaseToWords(identifier, true);
            int length = buffer.length();
            if (length != 0) {
                StringBuilders.replace(buffer, '_', ' ');
                int c = buffer.codePointAt(0);
                int up = Character.toUpperCase(c);
                if (c != up) {
                    StringBuilders.replace(buffer, 0, Character.charCount(c), Character.toChars(up));
                }
            }
        }
        return buffer;
    }

    public static CharSequence camelCaseToWords(CharSequence identifier, boolean toLowerCase) {
        int cp;
        if (identifier == null) {
            return null;
        }
        int length = identifier.length();
        StringBuilder buffer = new StringBuilder(length + 8);
        int lastIndex = length != 0 ? length - Character.charCount(Character.codePointBefore(identifier, length)) : 0;
        int last = 0;
        for (int i = 1; i <= length; i += Character.charCount(cp)) {
            int low;
            int c;
            boolean doAppend;
            if (i == length) {
                cp = 0;
                doAppend = true;
            } else {
                cp = Character.codePointAt(identifier, i);
                boolean bl = doAppend = Character.isUpperCase(cp) && Character.isLowerCase(Character.codePointBefore(identifier, i));
            }
            if (!doAppend) continue;
            int pos = buffer.length();
            buffer.append(identifier, last, i).append(' ');
            if (toLowerCase && pos != 0 && last < lastIndex && Character.isLowerCase(CharSequences.codePointAfter(identifier, last)) && (c = buffer.codePointAt(pos)) != (low = Character.toLowerCase(c))) {
                StringBuilders.replace(buffer, pos, pos + Character.charCount(c), Character.toChars(low));
            }
            last = i;
        }
        int lg = buffer.length();
        if (lg != 0 && Character.isWhitespace(cp = buffer.codePointBefore(lg))) {
            buffer.setLength(lg - Character.charCount(cp));
        }
        return buffer;
    }

    public static CharSequence camelCaseToAcronym(CharSequence text) {
        if ((text = CharSequences.trimWhitespaces(text)) != null && !CharSequences.isAcronym(text)) {
            int c;
            int length = text.length();
            StringBuilder buffer = new StringBuilder(8);
            boolean wantChar = true;
            for (int i = 0; i < length; i += Character.charCount(c)) {
                c = Character.codePointAt(text, i);
                if (wantChar) {
                    if (!Character.isUnicodeIdentifierStart(c)) continue;
                    buffer.appendCodePoint(c);
                    wantChar = false;
                    continue;
                }
                if (!Character.isUnicodeIdentifierPart(c) || c == 95) {
                    wantChar = true;
                    continue;
                }
                if (!Character.isUpperCase(c) || Character.isUpperCase(Character.codePointBefore(text, i))) continue;
                buffer.appendCodePoint(c);
            }
            int acrlg = buffer.length();
            if (acrlg != 0) {
                int up;
                if (CharSequences.isUpperCase(buffer, 1, acrlg, true) && (c = buffer.codePointAt(0)) != (up = Character.toUpperCase(c))) {
                    StringBuilders.replace(buffer, 0, Character.charCount(c), Character.toChars(up));
                }
                if (!CharSequences.equals(text, buffer)) {
                    text = buffer;
                }
            }
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAcronymForWords(CharSequence acronym, CharSequence words) {
        boolean skipLetters;
        int cc;
        int ic;
        int lgc;
        int ca;
        block20: {
            int lga = CharSequences.length(acronym);
            int ia = 0;
            do {
                if (ia >= lga) {
                    return false;
                }
                ca = Character.codePointAt(acronym, ia);
                ia += Character.charCount(ca);
            } while (!Character.isLetterOrDigit(ca));
            lgc = CharSequences.length(words);
            ic = 0;
            do {
                if (ic >= lgc) {
                    return false;
                }
                cc = Character.codePointAt(words, ic);
                ic += Character.charCount(cc);
            } while (!Character.isLetterOrDigit(cc));
            if (Character.toUpperCase(ca) != Character.toUpperCase(cc)) {
                return false;
            }
            while (true) {
                block21: {
                    if (ia >= lga) break block20;
                    if (ic >= lgc) {
                        return false;
                    }
                    int last = ca;
                    ca = Character.codePointAt(acronym, ia);
                    ia += Character.charCount(ca);
                    cc = Character.codePointAt(words, ic);
                    ic += Character.charCount(cc);
                    if (Character.isLetterOrDigit(ca)) {
                        if (Character.toUpperCase(ca) == Character.toUpperCase(cc)) {
                            continue;
                        }
                    } else {
                        if (Character.isDigit(cc) && Character.isDigit(last)) {
                            return false;
                        }
                        while (ia < lga) {
                            ca = Character.codePointAt(acronym, ia);
                            ia += Character.charCount(ca);
                            if (!Character.isLetterOrDigit(ca)) continue;
                            break block21;
                        }
                        break block20;
                    }
                }
                skipLetters = true;
                while (true) {
                    if (Character.isLetterOrDigit(cc) == skipLetters) {
                        if (ic >= lgc) {
                            return false;
                        }
                        cc = Character.codePointAt(words, ic);
                        ic += Character.charCount(cc);
                        continue;
                    }
                    if (skipLetters = !skipLetters) break;
                }
                if (Character.toUpperCase(ca) != Character.toUpperCase(cc)) break;
            }
            return false;
        }
        boolean disallowDigit = Character.isDigit(ca);
        skipLetters = true;
        while (true) {
            if (ic >= lgc) {
                return true;
            }
            cc = Character.codePointAt(words, ic);
            ic += Character.charCount(cc);
            if (skipLetters) {
                if (disallowDigit) {
                    if (Character.isDigit(cc)) {
                        return false;
                    }
                    disallowDigit = false;
                }
                skipLetters = Character.isLetterOrDigit(cc);
                continue;
            }
            if (Character.isLetterOrDigit(cc)) break;
        }
        return false;
    }

    private static boolean isCode(CharSequence identifier) {
        int i = identifier.length();
        while (--i >= 0) {
            char c = identifier.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= '-' && c <= ':' || c == '_') continue;
            return false;
        }
        return true;
    }

    private static boolean isAcronym(CharSequence text) {
        return CharSequences.isUpperCase(text) && CharSequences.indexOf(text, 95, 0, text.length()) < 0 && CharSequences.isUnicodeIdentifier(text);
    }

    public static boolean isUnicodeIdentifier(CharSequence identifier) {
        int length = CharSequences.length(identifier);
        if (length == 0) {
            return false;
        }
        int c = Character.codePointAt(identifier, 0);
        if (!Character.isUnicodeIdentifierStart(c)) {
            return false;
        }
        int i = 0;
        while ((i += Character.charCount(c)) < length) {
            c = Character.codePointAt(identifier, i);
            if (Character.isUnicodeIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(CharSequence text) {
        return CharSequences.isUpperCase(text, 0, CharSequences.length(text), false);
    }

    private static boolean isUpperCase(CharSequence text, int lower, int upper, boolean hasUpperCase) {
        while (lower < upper) {
            int c = Character.codePointAt(text, lower);
            if (Character.isLowerCase(c)) {
                return false;
            }
            if (!hasUpperCase) {
                hasUpperCase = Character.isUpperCase(c);
            }
            lower += Character.charCount(c);
        }
        return hasUpperCase;
    }

    public static boolean equalsFiltered(CharSequence s1, CharSequence s2, Characters.Filter filter, boolean ignoreCase) {
        int n;
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (filter == null) {
            return ignoreCase ? CharSequences.equalsIgnoreCase(s1, s2) : CharSequences.equals(s1, s2);
        }
        int lg1 = s1.length();
        int lg2 = s2.length();
        int i2 = 0;
        for (int i1 = 0; i1 < lg1; i1 += n) {
            int c2;
            int c1 = Character.codePointAt(s1, i1);
            n = Character.charCount(c1);
            if (!filter.contains(c1)) continue;
            do {
                if (i2 >= lg2) {
                    return false;
                }
                c2 = Character.codePointAt(s2, i2);
                i2 += Character.charCount(c2);
            } while (!filter.contains(c2));
            if (c1 == c2 || ignoreCase && CharSequences.equalsIgnoreCase(c1, c2)) continue;
            return false;
        }
        while (i2 < lg2) {
            int s = Character.codePointAt(s2, i2);
            if (filter.contains(s)) {
                return false;
            }
            i2 += Character.charCount(s);
        }
        return true;
    }

    private static boolean equalsIgnoreCase(int c1, int c2) {
        if ((c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2))) {
            return true;
        }
        return Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    public static boolean equalsIgnoreCase(CharSequence s1, CharSequence s2) {
        int i2;
        int c2;
        int c1;
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        int lg1 = s1.length();
        int lg2 = s2.length();
        int i1 = 0;
        for (i2 = 0; i1 < lg1 && i2 < lg2; i1 += Character.charCount(c1), i2 += Character.charCount(c2)) {
            c1 = Character.codePointAt(s1, i1);
            if (c1 == (c2 = Character.codePointAt(s2, i2)) || CharSequences.equalsIgnoreCase(c1, c2)) continue;
            return false;
        }
        return i1 == i2;
    }

    public static boolean equals(CharSequence s1, CharSequence s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 != null && s2 != null) {
            if (s1 instanceof String) {
                return ((String)s1).contentEquals(s2);
            }
            if (s2 instanceof String) {
                return ((String)s2).contentEquals(s1);
            }
            int length = s1.length();
            if (s2.length() == length) {
                for (int i = 0; i < length; ++i) {
                    if (s1.charAt(i) == s2.charAt(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean regionMatches(CharSequence text, int fromIndex, CharSequence part) {
        int length;
        if (text instanceof String && part instanceof String) {
            return ((String)text).startsWith((String)part, fromIndex);
        }
        if (fromIndex < 0 || fromIndex + (length = part.length()) > text.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (text.charAt(fromIndex + i) == part.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence text, int fromIndex, CharSequence part, boolean ignoreCase) {
        int c1;
        if (!ignoreCase) {
            return CharSequences.regionMatches(text, fromIndex, part);
        }
        int limit = text.length();
        int length = part.length();
        if (fromIndex < 0) {
            return false;
        }
        for (int i = 0; i < length; i += Character.charCount(c1)) {
            int c2;
            if (fromIndex >= limit) {
                return false;
            }
            c1 = Character.codePointAt(part, i);
            if (c1 != (c2 = Character.codePointAt(text, fromIndex)) && !CharSequences.equalsIgnoreCase(c1, c2)) {
                return false;
            }
            fromIndex += Character.charCount(c2);
        }
        return true;
    }

    public static boolean startsWith(CharSequence text, CharSequence prefix, boolean ignoreCase) {
        return CharSequences.regionMatches(text, 0, prefix, ignoreCase);
    }

    public static boolean endsWith(CharSequence text, CharSequence suffix, boolean ignoreCase) {
        int cp;
        int is = text.length();
        for (int ip = suffix.length(); ip > 0; ip -= Character.charCount(cp)) {
            if (is <= 0) {
                return false;
            }
            int cs = Character.codePointBefore(text, is);
            if (!(cs == (cp = Character.codePointBefore(suffix, ip)) || ignoreCase && CharSequences.equalsIgnoreCase(cs, cp))) {
                return false;
            }
            is -= Character.charCount(cs);
        }
        return true;
    }

    public static CharSequence commonPrefix(CharSequence s1, CharSequence s2) {
        int i;
        int length;
        CharSequence shortest;
        int lg2;
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int lg1 = s1.length();
        if (lg1 <= (lg2 = s2.length())) {
            shortest = s1;
            length = lg1;
        } else {
            shortest = s2;
            length = lg2;
        }
        for (i = 0; i < length && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return shortest.subSequence(0, i);
    }

    public static CharSequence commonSuffix(CharSequence s1, CharSequence s2) {
        int length;
        CharSequence shortest;
        int lg2;
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int lg1 = s1.length();
        if (lg1 <= (lg2 = s2.length())) {
            shortest = s1;
            length = lg1;
        } else {
            shortest = s2;
            length = lg2;
        }
        int i = 0;
        while (++i <= length && s1.charAt(lg1 - i) == s2.charAt(lg2 - i)) {
        }
        return shortest.subSequence(length - --i, shortest.length());
    }

    public static CharSequence commonWords(CharSequence s1, CharSequence s2) {
        int suffixStart;
        int c;
        int lg1 = CharSequences.length(s1);
        int lg2 = CharSequences.length(s2);
        int shortestLength = Math.min(lg1, lg2);
        CharSequence prefix = CharSequences.commonPrefix(s1, s2);
        int prefixLength = CharSequences.length(prefix);
        if (prefixLength >= shortestLength) {
            return prefix;
        }
        CharSequence suffix = CharSequences.commonSuffix(s1, s2);
        int suffixLength = CharSequences.length(suffix);
        if (suffixLength >= shortestLength) {
            return suffix;
        }
        int length = prefixLength + suffixLength;
        if (length >= lg1) {
            return s1;
        }
        if (length >= lg2) {
            return s2;
        }
        if (!CharSequences.isWordBoundary(s1, prefixLength, Character.codePointAt(s1, prefixLength)) && !CharSequences.isWordBoundary(s2, prefixLength, Character.codePointAt(s2, prefixLength))) {
            while (prefixLength > 0) {
                int c2;
                int n;
                if (!CharSequences.isWordBoundary(prefix, prefixLength -= (n = Character.charCount(c2 = Character.codePointBefore(prefix, prefixLength))), c2)) continue;
                if (Character.isLetterOrDigit(c2)) break;
                prefixLength += n;
                break;
            }
        }
        if (Character.isLetterOrDigit(Character.codePointBefore(s1, lg1 - suffixLength)) && Character.isLetterOrDigit(Character.codePointBefore(s2, lg2 - suffixLength))) {
            for (suffixStart = 0; suffixStart < suffixLength && !CharSequences.isWordBoundary(suffix, suffixStart, c = Character.codePointAt(suffix, suffixStart)); suffixStart += Character.charCount(c)) {
            }
        }
        if (prefixLength == 0) {
            while (suffixStart < suffixLength) {
                c = Character.codePointAt(suffix, suffixStart);
                if (Character.isLetterOrDigit(c)) {
                    return suffix.subSequence(suffixStart, suffixLength);
                }
                suffixStart += Character.charCount(c);
            }
            return "";
        }
        if (suffixStart >= suffixLength) {
            while (prefixLength > 0) {
                c = Character.codePointBefore(prefix, prefixLength);
                if (Character.isLetterOrDigit(c)) {
                    return prefix.subSequence(0, prefixLength);
                }
                prefixLength -= Character.charCount(c);
            }
            return "";
        }
        StringBuilder buffer = new StringBuilder(prefixLength + suffixLength).append(prefix);
        int c1 = Character.codePointBefore(prefix, prefixLength);
        int c2 = Character.codePointAt(suffix, suffixStart);
        if (Character.isLetterOrDigit(c1) && Character.isLetterOrDigit(c2)) {
            if (!Character.isUpperCase(c2) || !Character.isLowerCase(c1)) {
                buffer.append(' ');
            }
        } else if (c1 == c2) {
            suffixStart += Character.charCount(c2);
        }
        return buffer.append(suffix, suffixStart, suffixLength).toString();
    }

    private static boolean isWordBoundary(CharSequence s, int i, int c) {
        if (!Character.isLetterOrDigit(c)) {
            return true;
        }
        if (!Character.isUpperCase(c)) {
            return false;
        }
        return i <= 0 || Character.isLowerCase(Character.codePointBefore(s, i));
    }

    public static CharSequence token(CharSequence text, int fromIndex) {
        int upper;
        block6: {
            int c;
            int length;
            block5: {
                length = text.length();
                upper = fromIndex;
                do {
                    if (upper >= length) {
                        return "";
                    }
                    c = Character.codePointAt(text, upper);
                    fromIndex = upper;
                    upper += Character.charCount(c);
                } while (Character.isWhitespace(c));
                if (!Character.isUnicodeIdentifierStart(c)) break block5;
                while (upper < length && Character.isUnicodeIdentifierPart(c = Character.codePointAt(text, upper))) {
                    upper += Character.charCount(c);
                }
                break block6;
            }
            int type = Character.getType(Character.codePointAt(text, fromIndex));
            while (upper < length && Character.getType(c = Character.codePointAt(text, upper)) == type) {
                upper += Character.charCount(c);
            }
            if (type != 20 && type != 23) break block6;
            while (upper < length && Character.isUnicodeIdentifierPart(c = Character.codePointAt(text, upper))) {
                upper += Character.charCount(c);
            }
        }
        return text.subSequence(fromIndex, upper);
    }

    public static CharSequence replace(CharSequence text, CharSequence toSearch, CharSequence replaceBy) {
        ArgumentChecks.ensureNonEmpty("toSearch", toSearch);
        ArgumentChecks.ensureNonNull("replaceBy", replaceBy);
        if (text != null && !toSearch.equals(replaceBy)) {
            if (text instanceof String) {
                return ((String)text).replace(toSearch, replaceBy);
            }
            int length = text.length();
            int i = CharSequences.indexOf(text, toSearch, 0, length);
            if (i >= 0) {
                int p = 0;
                int sl = toSearch.length();
                StringBuilder buffer = new StringBuilder(length + (replaceBy.length() - sl));
                do {
                    buffer.append(text, p, i).append(replaceBy);
                } while ((i = CharSequences.indexOf(text, toSearch, p = i + sl, length)) >= 0);
                return buffer.append(text, p, length);
            }
        }
        return text;
    }

    public static void copyChars(CharSequence src, int srcOffset, char[] dst, int dstOffset, int length) {
        ArgumentChecks.ensurePositive("length", length);
        if (src instanceof String) {
            ((String)src).getChars(srcOffset, srcOffset + length, dst, dstOffset);
        } else if (src instanceof StringBuilder) {
            ((StringBuilder)src).getChars(srcOffset, srcOffset + length, dst, dstOffset);
        } else if (src instanceof StringBuffer) {
            ((StringBuffer)src).getChars(srcOffset, srcOffset + length, dst, dstOffset);
        } else if (src instanceof CharBuffer) {
            ((CharBuffer)src).subSequence(srcOffset, srcOffset + length).get(dst, dstOffset, length);
        } else {
            while (length != 0) {
                dst[dstOffset++] = src.charAt(srcOffset++);
                --length;
            }
        }
    }
}

