/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="FontType")
@XmlRootElement(name="Font")
public class Font<R>
extends StyleElement<R> {
    private List<Expression<R, String>> family;
    protected Expression<R, String> style;
    protected Expression<R, String> weight;
    protected Expression<R, ? extends Number> size;

    private Font() {
    }

    public Font(StyleFactory<R> factory) {
        super(factory);
        this.family = new ArrayList<Expression<R, String>>();
    }

    public Font(Font<R> source) {
        super(source);
        this.family = new ArrayList<Expression<R, String>>(source.family);
        this.style = source.style;
        this.weight = source.weight;
        this.size = source.size;
    }

    public List<Expression<R, String>> family() {
        return this.family;
    }

    public Expression<R, String> getStyle() {
        Expression<R, String> value = this.style;
        return value != null ? value : this.factory.normal;
    }

    public void setStyle(Expression<R, String> value) {
        this.style = value;
    }

    public Expression<R, String> getWeight() {
        Expression<R, String> value = this.weight;
        return value != null ? value : this.factory.normal;
    }

    public void setWeight(Expression<R, String> value) {
        this.weight = value;
    }

    public Expression<R, ? extends Number> getSize() {
        Expression<R, ? extends Number> value = this.size;
        return value != null ? value : this.factory.ten;
    }

    public void setSize(Expression<R, ? extends Number> value) {
        this.size = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.family, this.style, this.weight, this.size};
    }

    @Override
    public Font<R> clone() {
        Font clone = (Font)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        this.family = new ArrayList<Expression<R, String>>(this.family);
    }
}

