/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.awt.Shape;
import java.awt.geom.Path2D;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.io.TableAppender;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.GeodesicsOnEllipsoid;
import org.apache.sis.referencing.GeodeticException;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.internal.Bezier;
import org.apache.sis.referencing.internal.PositionTransformer;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.ReferencingUtilities;
import org.apache.sis.referencing.internal.shared.ShapeUtilities;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.provider.ModifiedAzimuthalEquidistant;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeodeticCalculator {
    static final double LATITUDE_THRESHOLD = 1.5706706731410454E-10;
    private final PositionTransformer userToGeodetic;
    final Ellipsoid ellipsoid;
    final double semiMajorAxis;
    double \u03c61;
    double \u03bb1;
    double \u03c62;
    double \u03bb2;
    double msin\u03b11;
    double mcos\u03b11;
    double msin\u03b12;
    double mcos\u03b12;
    double geodesicDistance;
    double rhumblineLength;
    double rhumblineAzimuth;
    private int validity;
    static final int START_POINT = 1;
    static final int END_POINT = 2;
    static final int STARTING_AZIMUTH = 4;
    static final int ENDING_AZIMUTH = 8;
    static final int GEODESIC_DISTANCE = 16;
    static final int RHUMBLINE_LENGTH = 32;
    static final int COEFFICIENTS_FOR_START_POINT = 64;
    private DefaultMathTransformFactory projectionFactory;
    private MapProjection projectionProvider;
    private Parameters projectionParameters;
    private MathTransform toProjectionBase;

    GeodeticCalculator(CoordinateReferenceSystem crs, Ellipsoid ellipsoid) {
        GeographicCRS geographic = ReferencingUtilities.toNormalizedGeographicCRS(crs, true, true);
        if (geographic == null) {
            throw new IllegalArgumentException(Errors.format((short)61, ReferencingUtilities.getInterface(CoordinateReferenceSystem.class, crs)));
        }
        this.ellipsoid = ellipsoid;
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.userToGeodetic = new PositionTransformer(crs, (CoordinateReferenceSystem)geographic, null);
    }

    public static GeodeticCalculator create(CoordinateReferenceSystem crs) {
        Ellipsoid ellipsoid = DatumOrEnsemble.getEllipsoid(Objects.requireNonNull(crs)).orElseThrow(() -> new IllegalArgumentException(Errors.format((short)61, ReferencingUtilities.getInterface(CoordinateReferenceSystem.class, crs))));
        if (ellipsoid.isSphere()) {
            return new GeodeticCalculator(crs, ellipsoid);
        }
        return new GeodesicsOnEllipsoid(crs, ellipsoid);
    }

    final boolean isInvalid(int mask) {
        return (this.validity & mask) != mask;
    }

    final void setValid(int mask) {
        this.validity |= mask;
    }

    public CoordinateReferenceSystem getPositionCRS() {
        return this.userToGeodetic.defaultCRS;
    }

    public GeographicCRS getGeographicCRS() {
        return (GeographicCRS)this.userToGeodetic.getCoordinateReferenceSystem();
    }

    private PositionTransformer geographic(double \u03c6, double \u03bb) {
        this.userToGeodetic.setCoordinate(0, Math.toDegrees(\u03c6));
        this.userToGeodetic.setCoordinate(1, Math.toDegrees(\u03bb));
        int i = this.userToGeodetic.getDimension();
        while (--i >= 2) {
            this.userToGeodetic.setCoordinate(i, 0.0);
        }
        return this.userToGeodetic;
    }

    private String transformError(boolean toCRS) {
        return Resources.format((short)89, toCRS ? 1 : 0, IdentifiedObjects.getDisplayName((IdentifiedObject)this.getPositionCRS(), null));
    }

    public DirectPosition getStartPoint() {
        if (this.isInvalid(1)) {
            throw new IllegalStateException(Resources.format((short)88, 0));
        }
        try {
            return this.geographic(this.\u03c61, this.\u03bb1).inverseTransform();
        }
        catch (TransformException e) {
            throw new GeodeticException(this.transformError(true), e);
        }
    }

    public void setStartPoint(DirectPosition point) {
        DirectPosition p;
        try {
            p = this.userToGeodetic.transform(point);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(this.transformError(false), e);
        }
        this.setStartGeographicPoint(p.getOrdinate(0), p.getOrdinate(1));
    }

    public void setStartGeographicPoint(double latitude, double longitude) {
        ArgumentChecks.ensureFinite((String)"latitude", (double)latitude);
        ArgumentChecks.ensureFinite((String)"longitude", (double)longitude);
        this.\u03c61 = Math.toRadians(Math.max(-90.0, Math.min(90.0, latitude)));
        this.\u03bb1 = Math.toRadians(longitude);
        this.validity = 1;
    }

    public DirectPosition getEndPoint() {
        if (this.isInvalid(2)) {
            this.computeEndPoint();
        }
        try {
            return this.geographic(this.\u03c62, this.\u03bb2).inverseTransform();
        }
        catch (TransformException e) {
            throw new GeodeticException(this.transformError(true), e);
        }
    }

    public void setEndPoint(DirectPosition position) {
        DirectPosition p;
        try {
            p = this.userToGeodetic.transform(position);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(this.transformError(false), e);
        }
        this.setEndGeographicPoint(p.getOrdinate(0), p.getOrdinate(1));
    }

    public void setEndGeographicPoint(double latitude, double longitude) {
        ArgumentChecks.ensureFinite((String)"latitude", (double)latitude);
        ArgumentChecks.ensureFinite((String)"longitude", (double)longitude);
        this.\u03c62 = Math.toRadians(Math.max(-90.0, Math.min(90.0, latitude)));
        this.\u03bb2 = Math.toRadians(longitude);
        this.setValid(2);
        this.validity &= 0xFFFFFF83;
    }

    public double getStartingAzimuth() {
        if (this.isInvalid(4)) {
            this.computeDistance();
        }
        return Math.toDegrees(Math.atan2(this.msin\u03b11, this.mcos\u03b11));
    }

    public void setStartingAzimuth(double azimuth) {
        ArgumentChecks.ensureFinite((String)"azimuth", (double)azimuth);
        azimuth = Math.toRadians(azimuth);
        this.msin\u03b11 = Math.sin(azimuth);
        this.mcos\u03b11 = Math.cos(azimuth);
        this.setValid(4);
        this.validity &= 0xFFFFFF95;
    }

    public double getEndingAzimuth() {
        if (this.isInvalid(8)) {
            if (this.isInvalid(2)) {
                this.computeEndPoint();
            } else {
                this.computeDistance();
            }
        }
        return Math.toDegrees(Math.atan2(this.msin\u03b12, this.mcos\u03b12));
    }

    public double getConstantAzimuth() {
        if (this.isInvalid(32)) {
            this.computeRhumbLine();
        }
        return Math.toDegrees(this.rhumblineAzimuth);
    }

    public double getGeodesicDistance() {
        if (this.isInvalid(16)) {
            this.computeDistance();
        }
        return this.geodesicDistance;
    }

    public void setGeodesicDistance(double distance) {
        ArgumentChecks.ensurePositive((String)"distance", (double)distance);
        this.geodesicDistance = distance;
        this.setValid(16);
        this.validity &= 0xFFFFFFD5;
    }

    public double getRhumblineLength() {
        if (this.isInvalid(32)) {
            this.computeRhumbLine();
        }
        return this.rhumblineLength;
    }

    public Unit<Length> getDistanceUnit() {
        return this.ellipsoid.getAxisUnit();
    }

    double d\u03c6_dy(double \u03c6) {
        return Math.cos(\u03c6);
    }

    final void canComputeDistance() {
        if (this.isInvalid(3)) {
            throw new IllegalStateException(Resources.format((short)88, Integer.signum(this.validity & 1)));
        }
    }

    void computeRhumbLine() {
        double factor;
        this.canComputeDistance();
        double \u0394\u03bb = Math.IEEEremainder(this.\u03bb2 - this.\u03bb1, Math.PI * 2);
        double \u0394\u03c6 = this.\u03c62 - this.\u03c61;
        if (Math.abs(\u0394\u03c6) < 1.5706706731410454E-10) {
            factor = \u0394\u03bb * Math.cos((this.\u03c61 + this.\u03c62) / 2.0);
            this.rhumblineAzimuth = Math.copySign(1.5707963267948966, \u0394\u03bb);
        } else {
            double \u0394\u03a8 = Math.log(Math.tan(0.7853981633974483 + this.\u03c62 / 2.0) / Math.tan(0.7853981633974483 + this.\u03c61 / 2.0));
            factor = \u0394\u03c6 / \u0394\u03a8 * Math.hypot(\u0394\u03bb, \u0394\u03a8);
            this.rhumblineAzimuth = Math.atan2(\u0394\u03bb, \u0394\u03a8);
        }
        this.rhumblineLength = this.semiMajorAxis * Math.abs(factor);
        this.setValid(32);
    }

    void computeDistance() {
        this.canComputeDistance();
        double \u0394\u03bb = this.\u03bb2 - this.\u03bb1;
        double sin\u0394\u03bb = Math.sin(\u0394\u03bb);
        double cos\u0394\u03bb = Math.cos(\u0394\u03bb);
        double sin\u03c61 = Math.sin(this.\u03c61);
        double cos\u03c61 = Math.cos(this.\u03c61);
        double sin\u03c62 = Math.sin(this.\u03c62);
        double cos\u03c62 = Math.cos(this.\u03c62);
        double cos\u03c61_sin\u03c62 = cos\u03c61 * sin\u03c62;
        double cos\u03c62_sin\u03c61 = cos\u03c62 * sin\u03c61;
        this.msin\u03b11 = cos\u03c62 * sin\u0394\u03bb;
        this.msin\u03b12 = cos\u03c61 * sin\u0394\u03bb;
        this.mcos\u03b11 = cos\u03c61_sin\u03c62 - cos\u03c62_sin\u03c61 * cos\u0394\u03bb;
        this.mcos\u03b12 = cos\u03c61_sin\u03c62 * cos\u0394\u03bb - cos\u03c62_sin\u03c61;
        double \u0394\u03c3 = sin\u03c61 * sin\u03c62 + cos\u03c61 * cos\u03c62 * cos\u0394\u03bb;
        \u0394\u03c3 = Math.atan2(Math.hypot(this.msin\u03b11, this.mcos\u03b11), \u0394\u03c3);
        this.geodesicDistance = this.semiMajorAxis * \u0394\u03c3;
        this.setValid(28);
    }

    final void canComputeEndPoint() {
        if (this.isInvalid(21)) {
            throw new IllegalStateException(this.isInvalid(1) ? Resources.format((short)88, 0) : Resources.format((short)87));
        }
    }

    void computeEndPoint() {
        this.canComputeEndPoint();
        double m = Math.hypot(this.msin\u03b11, this.mcos\u03b11);
        double \u0394\u03c3 = this.geodesicDistance / this.semiMajorAxis;
        double sin\u0394\u03c3 = Math.sin(\u0394\u03c3);
        double cos\u0394\u03c3 = Math.cos(\u0394\u03c3);
        double sin\u03c61 = Math.sin(this.\u03c61);
        double cos\u03c61 = Math.cos(this.\u03c61);
        double sin\u03b11 = this.msin\u03b11 / m;
        double cos\u03b11 = this.mcos\u03b11 / m;
        double sin\u0394\u03c3_cos\u03b11 = sin\u0394\u03c3 * cos\u03b11;
        double \u0394\u03bby = sin\u0394\u03c3 * sin\u03b11;
        double \u0394\u03bbx = cos\u0394\u03c3 * cos\u03c61 - sin\u03c61 * sin\u0394\u03c3_cos\u03b11;
        double \u0394\u03bb = Math.atan2(\u0394\u03bby, \u0394\u03bbx);
        double sin\u03c62 = sin\u03c61 * cos\u0394\u03c3 + cos\u03c61 * sin\u0394\u03c3_cos\u03b11;
        this.\u03c62 = Math.atan(sin\u03c62 / Math.hypot(\u0394\u03bbx, \u0394\u03bby));
        this.\u03bb2 = Math.IEEEremainder(this.\u03bb1 + \u0394\u03bb, Math.PI * 2);
        this.mcos\u03b12 = cos\u0394\u03c3 * cos\u03b11 - sin\u03c61 / cos\u03c61 * sin\u0394\u03c3;
        this.msin\u03b12 = sin\u03b11;
        this.setValid(10);
    }

    public void moveToEndPoint() {
        if (this.isInvalid(2)) {
            this.computeEndPoint();
        }
        this.\u03c61 = this.\u03c62;
        this.mcos\u03b11 = this.mcos\u03b12;
        this.\u03bb1 = this.\u03bb2;
        this.msin\u03b11 = this.msin\u03b12;
        this.validity = (this.validity & 8) >>> 1 | 1;
    }

    public Shape createGeodesicPath2D(double tolerance) {
        Path2D path;
        ArgumentChecks.ensureStrictlyPositive((String)"tolerance", (double)tolerance);
        if (this.isInvalid(31)) {
            if (this.isInvalid(2)) {
                this.computeEndPoint();
            } else {
                this.computeDistance();
            }
        }
        PathBuilder bezier = new PathBuilder(tolerance);
        try {
            path = bezier.build();
        }
        catch (TransformException e) {
            throw new GeodeticException(this.transformError(true), e);
        }
        finally {
            bezier.reset();
        }
        return ShapeUtilities.toPrimitive(path);
    }

    public Shape createGeodesicCircle2D(double tolerance) {
        Path2D path;
        ArgumentChecks.ensureStrictlyPositive((String)"tolerance", (double)tolerance);
        if (this.isInvalid(17)) {
            this.computeDistance();
        }
        CircularPath bezier = new CircularPath(tolerance);
        try {
            path = bezier.build();
        }
        catch (TransformException e) {
            throw new GeodeticException(this.transformError(true), e);
        }
        finally {
            bezier.reset();
        }
        path.closePath();
        return path;
    }

    String getProjectionMethod() {
        return "Azimuthal Equidistant (Spherical)";
    }

    public MathTransform createProjectionAroundStart() {
        if (this.isInvalid(1)) {
            throw new IllegalStateException(Resources.format((short)88, 0));
        }
        try {
            if (this.projectionParameters == null) {
                CoordinateReferenceSystem positionCRS = this.getPositionCRS();
                GeographicCRS baseCRS = ReferencingUtilities.toNormalizedGeographicCRS(positionCRS, false, false);
                Unit<?> crsUnit = ReferencingUtilities.getUnit(positionCRS);
                UnitConverter toLinearUnit = this.ellipsoid.getAxisUnit().getConverterTo(Units.isLinear(crsUnit) ? crsUnit.asType(Length.class) : Units.METRE);
                this.toProjectionBase = CRS.findOperation(positionCRS, (CoordinateReferenceSystem)baseCRS, null).getMathTransform();
                this.projectionFactory = DefaultMathTransformFactory.provider().caching(false);
                this.projectionProvider = (MapProjection)this.projectionFactory.getOperationMethod(this.getProjectionMethod());
                this.projectionParameters = Parameters.castOrWrap(this.projectionProvider.getParameters().createValue());
                this.projectionParameters.parameter("semi_major").setValue(toLinearUnit.convert(this.ellipsoid.getSemiMajorAxis()));
                this.projectionParameters.parameter("semi_minor").setValue(toLinearUnit.convert(this.ellipsoid.getSemiMinorAxis()));
            }
            this.projectionParameters.getOrCreate(ModifiedAzimuthalEquidistant.LATITUDE_OF_ORIGIN).setValue(this.\u03c61, Units.RADIAN);
            this.projectionParameters.getOrCreate(ModifiedAzimuthalEquidistant.LONGITUDE_OF_ORIGIN).setValue(this.\u03bb1, Units.RADIAN);
            return MathTransforms.concatenate(this.toProjectionBase, this.projectionProvider.createMathTransform(this.projectionFactory, this.projectionParameters));
        }
        catch (FactoryException e) {
            throw new GeodeticException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Locale locale = Locale.getDefault();
        Vocabulary resources = Vocabulary.forLocale((Locale)locale);
        String lineSeparator = System.lineSeparator();
        CoordinateReferenceSystem crs = this.getPositionCRS();
        try {
            resources.appendLabel((short)36, (Appendable)buffer);
            buffer.append(' ').append(crs.getName().getCode()).append(lineSeparator);
            if ((this.validity & 0xF) != 0) {
                String[] axes = ReferencingUtilities.getShortAxisNames(resources, crs);
                AngleFormat azimuthFormat = new AngleFormat("DD\u00b0MM\u2032SS\u2033", locale);
                CoordinateFormat pointFormat = new CoordinateFormat(locale, null);
                pointFormat.setSeparator("\t");
                pointFormat.setDefaultCRS(crs);
                pointFormat.setGroundPrecision(Quantities.create((double)0.01, (Unit)Units.METRE));
                TableAppender table = new TableAppender((Appendable)buffer, " \u2502 ");
                table.setCellAlignment((byte)0);
                table.appendHorizontalSeparator();
                for (String axis : axes) {
                    table.nextColumn();
                    table.append((CharSequence)axis);
                }
                table.nextColumn();
                table.append((CharSequence)resources.getString((short)13)).nextLine();
                boolean endPoint = false;
                do {
                    table.setCellAlignment((byte)-1);
                    table.append((CharSequence)resources.getString(endPoint ? (short)76 : 187)).nextColumn();
                    table.setCellAlignment((byte)1);
                    try {
                        pointFormat.format(endPoint ? this.getEndPoint() : this.getStartPoint(), (Appendable)table);
                        table.nextColumn();
                        table.append((CharSequence)azimuthFormat.format(endPoint ? this.getEndingAzimuth() : this.getStartingAzimuth()));
                    }
                    catch (IllegalStateException | GeodeticException runtimeException) {
                        // empty catch block
                    }
                    table.nextLine();
                } while (endPoint = !endPoint);
                table.appendHorizontalSeparator();
                table.flush();
            }
            try {
                Unit<Length> unit = this.getDistanceUnit();
                double distance = this.getGeodesicDistance();
                double precision = Units.METRE.getConverterTo(unit).convert(0.01);
                NumberFormat nf = NumberFormat.getNumberInstance(locale);
                nf.setMaximumFractionDigits(Numerics.fractionDigitsForDelta((double)precision));
                resources.appendLabel((short)89, (Appendable)buffer);
                buffer.append(' ').append(nf.format(distance)).append(' ').append(unit).append(lineSeparator);
            }
            catch (IllegalStateException | GeodeticException unit) {}
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }

    private class PathBuilder
    extends Bezier {
        private final double mcos\u03b1f;
        private final double msin\u03b1f;
        private final double \u03c6f;
        private final double \u03bbf;
        private final double distance;
        private final double length;
        private final int flags;
        private final double tolerance;

        PathBuilder(double \u03b5x) {
            super(ReferencingUtilities.getDimension(GeodeticCalculator.this.userToGeodetic.defaultCRS));
            this.\u03c6f = GeodeticCalculator.this.\u03c62;
            this.\u03bbf = GeodeticCalculator.this.\u03bb2;
            this.msin\u03b1f = GeodeticCalculator.this.msin\u03b12;
            this.mcos\u03b1f = GeodeticCalculator.this.mcos\u03b12;
            this.tolerance = Math.toDegrees(\u03b5x / GeodeticCalculator.this.semiMajorAxis);
            this.distance = GeodeticCalculator.this.geodesicDistance;
            this.length = GeodeticCalculator.this.rhumblineLength;
            this.flags = GeodeticCalculator.this.validity & 0x3F;
        }

        @Override
        protected void evaluateAt(double t) throws TransformException {
            if (t == 0.0) {
                GeodeticCalculator.this.\u03c62 = GeodeticCalculator.this.\u03c61;
                GeodeticCalculator.this.mcos\u03b12 = GeodeticCalculator.this.mcos\u03b11;
                GeodeticCalculator.this.\u03bb2 = GeodeticCalculator.this.\u03bb1;
                GeodeticCalculator.this.msin\u03b12 = GeodeticCalculator.this.msin\u03b11;
            } else if (t == 1.0) {
                GeodeticCalculator.this.\u03c62 = this.\u03c6f;
                GeodeticCalculator.this.mcos\u03b12 = this.mcos\u03b1f;
                GeodeticCalculator.this.\u03bb2 = this.\u03bbf;
                GeodeticCalculator.this.msin\u03b12 = this.msin\u03b1f;
            } else {
                GeodeticCalculator.this.geodesicDistance = this.distance * t;
                GeodeticCalculator.this.setValid(16);
                GeodeticCalculator.this.computeEndPoint();
            }
            this.evaluateAtEndPoint();
        }

        final void evaluateAtEndPoint() throws TransformException {
            if ((GeodeticCalculator.this.\u03bb2 - GeodeticCalculator.this.\u03bb1) * GeodeticCalculator.this.msin\u03b11 < 0.0) {
                GeodeticCalculator.this.\u03bb2 += Math.PI * 2 * Math.signum(GeodeticCalculator.this.msin\u03b11);
            }
            Matrix d = GeodeticCalculator.this.geographic(GeodeticCalculator.this.\u03c62, GeodeticCalculator.this.\u03bb2).inverseTransform(this.point);
            double d\u03c6_dy = GeodeticCalculator.this.d\u03c6_dy(GeodeticCalculator.this.\u03c62);
            double m00 = d.getElement(0, 0);
            double m01 = d.getElement(0, 1);
            double m10 = d.getElement(1, 0);
            double m11 = d.getElement(1, 1);
            double t = this.tolerance / d\u03c6_dy;
            this.\u03b5x = m00 * this.tolerance + m01 * t;
            this.\u03b5y = m10 * this.tolerance + m11 * t;
            t = GeodeticCalculator.this.mcos\u03b12 * d\u03c6_dy;
            this.dx = m00 * t + m01 * GeodeticCalculator.this.msin\u03b12;
            this.dy = m10 * t + m11 * GeodeticCalculator.this.msin\u03b12;
        }

        void reset() {
            GeodeticCalculator.this.\u03bb2 = this.\u03bbf;
            GeodeticCalculator.this.msin\u03b12 = this.msin\u03b1f;
            GeodeticCalculator.this.\u03c62 = this.\u03c6f;
            GeodeticCalculator.this.mcos\u03b12 = this.mcos\u03b1f;
            GeodeticCalculator.this.geodesicDistance = this.distance;
            GeodeticCalculator.this.rhumblineLength = this.length;
            GeodeticCalculator.this.validity = this.flags;
        }
    }

    private final class CircularPath
    extends PathBuilder {
        private final double mcos\u03b1i;
        private final double msin\u03b1i;

        CircularPath(double \u03b5x) {
            super(\u03b5x);
            this.msin\u03b1i = GeodeticCalculator.this.msin\u03b11;
            this.mcos\u03b1i = GeodeticCalculator.this.mcos\u03b11;
            this.forceCubic = true;
        }

        @Override
        protected void evaluateAt(double t) throws TransformException {
            double \u03b11 = t * (Math.PI * 2);
            GeodeticCalculator.this.msin\u03b11 = Math.sin(\u03b11);
            GeodeticCalculator.this.mcos\u03b11 = Math.cos(\u03b11);
            GeodeticCalculator.this.setValid(4);
            GeodeticCalculator.this.validity &= 0xFFFFFFBF;
            GeodeticCalculator.this.computeEndPoint();
            this.evaluateAtEndPoint();
            if (this.depth <= 1) {
                this.\u03b5y = -1.0;
                this.\u03b5x = -1.0;
            }
            double d = this.dx;
            this.dx = this.dy;
            this.dy = -d;
        }

        @Override
        void reset() {
            GeodeticCalculator.this.msin\u03b11 = this.msin\u03b1i;
            GeodeticCalculator.this.mcos\u03b11 = this.mcos\u03b1i;
            super.reset();
        }
    }
}

