// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.19.4
// source: definition.proto

package v2

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TransactionResolution int32

const (
	TransactionResolution_TRANSACTION_RESOLUTION_UNSPECIFIED TransactionResolution = 0
	TransactionResolution_COMMIT                             TransactionResolution = 1
	TransactionResolution_ROLLBACK                           TransactionResolution = 2
)

// Enum value maps for TransactionResolution.
var (
	TransactionResolution_name = map[int32]string{
		0: "TRANSACTION_RESOLUTION_UNSPECIFIED",
		1: "COMMIT",
		2: "ROLLBACK",
	}
	TransactionResolution_value = map[string]int32{
		"TRANSACTION_RESOLUTION_UNSPECIFIED": 0,
		"COMMIT":                             1,
		"ROLLBACK":                           2,
	}
)

func (x TransactionResolution) Enum() *TransactionResolution {
	p := new(TransactionResolution)
	*p = x
	return p
}

func (x TransactionResolution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionResolution) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[0].Descriptor()
}

func (TransactionResolution) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[0]
}

func (x TransactionResolution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionResolution.Descriptor instead.
func (TransactionResolution) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{0}
}

type TransactionSource int32

const (
	TransactionSource_SOURCE_UNSPECIFIED  TransactionSource = 0
	TransactionSource_SOURCE_CLIENT       TransactionSource = 1
	TransactionSource_SOURCE_SERVER_CHECK TransactionSource = 2
)

// Enum value maps for TransactionSource.
var (
	TransactionSource_name = map[int32]string{
		0: "SOURCE_UNSPECIFIED",
		1: "SOURCE_CLIENT",
		2: "SOURCE_SERVER_CHECK",
	}
	TransactionSource_value = map[string]int32{
		"SOURCE_UNSPECIFIED":  0,
		"SOURCE_CLIENT":       1,
		"SOURCE_SERVER_CHECK": 2,
	}
)

func (x TransactionSource) Enum() *TransactionSource {
	p := new(TransactionSource)
	*p = x
	return p
}

func (x TransactionSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionSource) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[1].Descriptor()
}

func (TransactionSource) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[1]
}

func (x TransactionSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionSource.Descriptor instead.
func (TransactionSource) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{1}
}

type Permission int32

const (
	Permission_PERMISSION_UNSPECIFIED Permission = 0
	Permission_NONE                   Permission = 1
	Permission_READ                   Permission = 2
	Permission_WRITE                  Permission = 3
	Permission_READ_WRITE             Permission = 4
)

// Enum value maps for Permission.
var (
	Permission_name = map[int32]string{
		0: "PERMISSION_UNSPECIFIED",
		1: "NONE",
		2: "READ",
		3: "WRITE",
		4: "READ_WRITE",
	}
	Permission_value = map[string]int32{
		"PERMISSION_UNSPECIFIED": 0,
		"NONE":                   1,
		"READ":                   2,
		"WRITE":                  3,
		"READ_WRITE":             4,
	}
)

func (x Permission) Enum() *Permission {
	p := new(Permission)
	*p = x
	return p
}

func (x Permission) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[2].Descriptor()
}

func (Permission) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[2]
}

func (x Permission) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission.Descriptor instead.
func (Permission) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{2}
}

type FilterType int32

const (
	FilterType_FILTER_TYPE_UNSPECIFIED FilterType = 0
	FilterType_TAG                     FilterType = 1
	FilterType_SQL                     FilterType = 2
)

// Enum value maps for FilterType.
var (
	FilterType_name = map[int32]string{
		0: "FILTER_TYPE_UNSPECIFIED",
		1: "TAG",
		2: "SQL",
	}
	FilterType_value = map[string]int32{
		"FILTER_TYPE_UNSPECIFIED": 0,
		"TAG":                     1,
		"SQL":                     2,
	}
)

func (x FilterType) Enum() *FilterType {
	p := new(FilterType)
	*p = x
	return p
}

func (x FilterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterType) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[3].Descriptor()
}

func (FilterType) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[3]
}

func (x FilterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterType.Descriptor instead.
func (FilterType) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{3}
}

type AddressScheme int32

const (
	AddressScheme_ADDRESS_SCHEME_UNSPECIFIED AddressScheme = 0
	AddressScheme_IPv4                       AddressScheme = 1
	AddressScheme_IPv6                       AddressScheme = 2
	AddressScheme_DOMAIN_NAME                AddressScheme = 3
)

// Enum value maps for AddressScheme.
var (
	AddressScheme_name = map[int32]string{
		0: "ADDRESS_SCHEME_UNSPECIFIED",
		1: "IPv4",
		2: "IPv6",
		3: "DOMAIN_NAME",
	}
	AddressScheme_value = map[string]int32{
		"ADDRESS_SCHEME_UNSPECIFIED": 0,
		"IPv4":                       1,
		"IPv6":                       2,
		"DOMAIN_NAME":                3,
	}
)

func (x AddressScheme) Enum() *AddressScheme {
	p := new(AddressScheme)
	*p = x
	return p
}

func (x AddressScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddressScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[4].Descriptor()
}

func (AddressScheme) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[4]
}

func (x AddressScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AddressScheme.Descriptor instead.
func (AddressScheme) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{4}
}

type MessageType int32

const (
	MessageType_MESSAGE_TYPE_UNSPECIFIED MessageType = 0
	MessageType_NORMAL                   MessageType = 1
	// Sequenced message
	MessageType_FIFO MessageType = 2
	// Messages that are delivered after the specified duration.
	MessageType_DELAY MessageType = 3
	// Messages that are transactional. Only committed messages are delivered to
	// subscribers.
	MessageType_TRANSACTION MessageType = 4
)

// Enum value maps for MessageType.
var (
	MessageType_name = map[int32]string{
		0: "MESSAGE_TYPE_UNSPECIFIED",
		1: "NORMAL",
		2: "FIFO",
		3: "DELAY",
		4: "TRANSACTION",
	}
	MessageType_value = map[string]int32{
		"MESSAGE_TYPE_UNSPECIFIED": 0,
		"NORMAL":                   1,
		"FIFO":                     2,
		"DELAY":                    3,
		"TRANSACTION":              4,
	}
)

func (x MessageType) Enum() *MessageType {
	p := new(MessageType)
	*p = x
	return p
}

func (x MessageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MessageType) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[5].Descriptor()
}

func (MessageType) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[5]
}

func (x MessageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MessageType.Descriptor instead.
func (MessageType) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{5}
}

type DigestType int32

const (
	DigestType_DIGEST_TYPE_UNSPECIFIED DigestType = 0
	// CRC algorithm achieves goal of detecting random data error with lowest
	// computation overhead.
	DigestType_CRC32 DigestType = 1
	// MD5 algorithm achieves good balance between collision rate and computation
	// overhead.
	DigestType_MD5 DigestType = 2
	// SHA-family has substantially fewer collision with fair amount of
	// computation.
	DigestType_SHA1 DigestType = 3
)

// Enum value maps for DigestType.
var (
	DigestType_name = map[int32]string{
		0: "DIGEST_TYPE_UNSPECIFIED",
		1: "CRC32",
		2: "MD5",
		3: "SHA1",
	}
	DigestType_value = map[string]int32{
		"DIGEST_TYPE_UNSPECIFIED": 0,
		"CRC32":                   1,
		"MD5":                     2,
		"SHA1":                    3,
	}
)

func (x DigestType) Enum() *DigestType {
	p := new(DigestType)
	*p = x
	return p
}

func (x DigestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DigestType) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[6].Descriptor()
}

func (DigestType) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[6]
}

func (x DigestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DigestType.Descriptor instead.
func (DigestType) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{6}
}

type ClientType int32

const (
	ClientType_CLIENT_TYPE_UNSPECIFIED ClientType = 0
	ClientType_PRODUCER                ClientType = 1
	ClientType_PUSH_CONSUMER           ClientType = 2
	ClientType_SIMPLE_CONSUMER         ClientType = 3
)

// Enum value maps for ClientType.
var (
	ClientType_name = map[int32]string{
		0: "CLIENT_TYPE_UNSPECIFIED",
		1: "PRODUCER",
		2: "PUSH_CONSUMER",
		3: "SIMPLE_CONSUMER",
	}
	ClientType_value = map[string]int32{
		"CLIENT_TYPE_UNSPECIFIED": 0,
		"PRODUCER":                1,
		"PUSH_CONSUMER":           2,
		"SIMPLE_CONSUMER":         3,
	}
)

func (x ClientType) Enum() *ClientType {
	p := new(ClientType)
	*p = x
	return p
}

func (x ClientType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientType) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[7].Descriptor()
}

func (ClientType) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[7]
}

func (x ClientType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientType.Descriptor instead.
func (ClientType) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{7}
}

type Encoding int32

const (
	Encoding_ENCODING_UNSPECIFIED Encoding = 0
	Encoding_IDENTITY             Encoding = 1
	Encoding_GZIP                 Encoding = 2
)

// Enum value maps for Encoding.
var (
	Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "IDENTITY",
		2: "GZIP",
	}
	Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"IDENTITY":             1,
		"GZIP":                 2,
	}
)

func (x Encoding) Enum() *Encoding {
	p := new(Encoding)
	*p = x
	return p
}

func (x Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[8].Descriptor()
}

func (Encoding) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[8]
}

func (x Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Encoding.Descriptor instead.
func (Encoding) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{8}
}

type Code int32

const (
	Code_CODE_UNSPECIFIED Code = 0
	// Generic code for success.
	Code_OK Code = 20000
	// Generic code for multiple return results.
	Code_MULTIPLE_RESULTS Code = 30000
	// Generic code for bad request, indicating that required fields or headers are missing.
	Code_BAD_REQUEST Code = 40000
	// Format of access point is illegal.
	Code_ILLEGAL_ACCESS_POINT Code = 40001
	// Format of topic is illegal.
	Code_ILLEGAL_TOPIC Code = 40002
	// Format of consumer group is illegal.
	Code_ILLEGAL_CONSUMER_GROUP Code = 40003
	// Format of message tag is illegal.
	Code_ILLEGAL_MESSAGE_TAG Code = 40004
	// Format of message key is illegal.
	Code_ILLEGAL_MESSAGE_KEY Code = 40005
	// Format of message group is illegal.
	Code_ILLEGAL_MESSAGE_GROUP Code = 40006
	// Format of message property key is illegal.
	Code_ILLEGAL_MESSAGE_PROPERTY_KEY Code = 40007
	// Transaction id is invalid.
	Code_INVALID_TRANSACTION_ID Code = 40008
	// Format of message id is illegal.
	Code_ILLEGAL_MESSAGE_ID Code = 40009
	// Format of filter expression is illegal.
	Code_ILLEGAL_FILTER_EXPRESSION Code = 40010
	// The invisible time of request is invalid.
	Code_ILLEGAL_INVISIBLE_TIME Code = 40011
	// The delivery timestamp of message is invalid.
	Code_ILLEGAL_DELIVERY_TIME Code = 40012
	// Receipt handle of message is invalid.
	Code_INVALID_RECEIPT_HANDLE Code = 40013
	// Message property conflicts with its type.
	Code_MESSAGE_PROPERTY_CONFLICT_WITH_TYPE Code = 40014
	// Client type could not be recognized.
	Code_UNRECOGNIZED_CLIENT_TYPE Code = 40015
	// Message is corrupted.
	Code_MESSAGE_CORRUPTED Code = 40016
	// Request is rejected due to missing of x-mq-client-id header.
	Code_CLIENT_ID_REQUIRED Code = 40017
	// Generic code indicates that the client request lacks valid authentication
	// credentials for the requested resource.
	Code_UNAUTHORIZED Code = 40100
	// Generic code indicates that the account is suspended due to overdue of payment.
	Code_PAYMENT_REQUIRED Code = 40200
	// Generic code for the case that user does not have the permission to operate.
	Code_FORBIDDEN Code = 40300
	// Generic code for resource not found.
	Code_NOT_FOUND Code = 40400
	// Message not found from server.
	Code_MESSAGE_NOT_FOUND Code = 40401
	// Topic resource does not exist.
	Code_TOPIC_NOT_FOUND Code = 40402
	// Consumer group resource does not exist.
	Code_CONSUMER_GROUP_NOT_FOUND Code = 40403
	// Generic code representing client side timeout when connecting to, reading data from, or write data to server.
	Code_REQUEST_TIMEOUT Code = 40800
	// Generic code represents that the request entity is larger than limits defined by server.
	Code_PAYLOAD_TOO_LARGE Code = 41300
	// Message body size exceeds the threshold.
	Code_MESSAGE_BODY_TOO_LARGE Code = 41301
	// Generic code for use cases where pre-conditions are not met.
	// For example, if a producer instance is used to publish messages without prior start() invocation,
	// this error code will be raised.
	Code_PRECONDITION_FAILED Code = 42800
	// Generic code indicates that too many requests are made in short period of duration.
	// Requests are throttled.
	Code_TOO_MANY_REQUESTS Code = 42900
	// Generic code for the case that the server is unwilling to process the request because its header fields are too large.
	// The request may be resubmitted after reducing the size of the request header fields.
	Code_REQUEST_HEADER_FIELDS_TOO_LARGE Code = 43100
	// Message properties total size exceeds the threshold.
	Code_MESSAGE_PROPERTIES_TOO_LARGE Code = 43101
	// Generic code indicates that server/client encountered an unexpected
	// condition that prevented it from fulfilling the request.
	Code_INTERNAL_ERROR Code = 50000
	// Code indicates that the server encountered an unexpected condition
	// that prevented it from fulfilling the request.
	// This error response is a generic "catch-all" response.
	// Usually, this indicates the server cannot find a better alternative
	// error code to response. Sometimes, server administrators log error
	// responses like the 500 status code with more details about the request
	// to prevent the error from happening again in the future.
	//
	// See https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/500
	Code_INTERNAL_SERVER_ERROR Code = 50001
	// The HA-mechanism is not working now.
	Code_HA_NOT_AVAILABLE Code = 50002
	// Generic code means that the server or client does not support the
	// functionality required to fulfill the request.
	Code_NOT_IMPLEMENTED Code = 50100
	// Generic code represents that the server, which acts as a gateway or proxy,
	// does not get an satisfied response in time from its upstream servers.
	// See https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/504
	Code_PROXY_TIMEOUT Code = 50400
	// Message persistence timeout.
	Code_MASTER_PERSISTENCE_TIMEOUT Code = 50401
	// Slave persistence timeout.
	Code_SLAVE_PERSISTENCE_TIMEOUT Code = 50402
	// Generic code for unsupported operation.
	Code_UNSUPPORTED Code = 50500
	// Operation is not allowed in current version.
	Code_VERSION_UNSUPPORTED Code = 50501
	// Not allowed to verify message. Chances are that you are verifying
	// a FIFO message, as is violating FIFO semantics.
	Code_VERIFY_FIFO_MESSAGE_UNSUPPORTED Code = 50502
	// Generic code for failed message consumption.
	Code_FAILED_TO_CONSUME_MESSAGE Code = 60000
)

// Enum value maps for Code.
var (
	Code_name = map[int32]string{
		0:     "CODE_UNSPECIFIED",
		20000: "OK",
		30000: "MULTIPLE_RESULTS",
		40000: "BAD_REQUEST",
		40001: "ILLEGAL_ACCESS_POINT",
		40002: "ILLEGAL_TOPIC",
		40003: "ILLEGAL_CONSUMER_GROUP",
		40004: "ILLEGAL_MESSAGE_TAG",
		40005: "ILLEGAL_MESSAGE_KEY",
		40006: "ILLEGAL_MESSAGE_GROUP",
		40007: "ILLEGAL_MESSAGE_PROPERTY_KEY",
		40008: "INVALID_TRANSACTION_ID",
		40009: "ILLEGAL_MESSAGE_ID",
		40010: "ILLEGAL_FILTER_EXPRESSION",
		40011: "ILLEGAL_INVISIBLE_TIME",
		40012: "ILLEGAL_DELIVERY_TIME",
		40013: "INVALID_RECEIPT_HANDLE",
		40014: "MESSAGE_PROPERTY_CONFLICT_WITH_TYPE",
		40015: "UNRECOGNIZED_CLIENT_TYPE",
		40016: "MESSAGE_CORRUPTED",
		40017: "CLIENT_ID_REQUIRED",
		40100: "UNAUTHORIZED",
		40200: "PAYMENT_REQUIRED",
		40300: "FORBIDDEN",
		40400: "NOT_FOUND",
		40401: "MESSAGE_NOT_FOUND",
		40402: "TOPIC_NOT_FOUND",
		40403: "CONSUMER_GROUP_NOT_FOUND",
		40800: "REQUEST_TIMEOUT",
		41300: "PAYLOAD_TOO_LARGE",
		41301: "MESSAGE_BODY_TOO_LARGE",
		42800: "PRECONDITION_FAILED",
		42900: "TOO_MANY_REQUESTS",
		43100: "REQUEST_HEADER_FIELDS_TOO_LARGE",
		43101: "MESSAGE_PROPERTIES_TOO_LARGE",
		50000: "INTERNAL_ERROR",
		50001: "INTERNAL_SERVER_ERROR",
		50002: "HA_NOT_AVAILABLE",
		50100: "NOT_IMPLEMENTED",
		50400: "PROXY_TIMEOUT",
		50401: "MASTER_PERSISTENCE_TIMEOUT",
		50402: "SLAVE_PERSISTENCE_TIMEOUT",
		50500: "UNSUPPORTED",
		50501: "VERSION_UNSUPPORTED",
		50502: "VERIFY_FIFO_MESSAGE_UNSUPPORTED",
		60000: "FAILED_TO_CONSUME_MESSAGE",
	}
	Code_value = map[string]int32{
		"CODE_UNSPECIFIED":                    0,
		"OK":                                  20000,
		"MULTIPLE_RESULTS":                    30000,
		"BAD_REQUEST":                         40000,
		"ILLEGAL_ACCESS_POINT":                40001,
		"ILLEGAL_TOPIC":                       40002,
		"ILLEGAL_CONSUMER_GROUP":              40003,
		"ILLEGAL_MESSAGE_TAG":                 40004,
		"ILLEGAL_MESSAGE_KEY":                 40005,
		"ILLEGAL_MESSAGE_GROUP":               40006,
		"ILLEGAL_MESSAGE_PROPERTY_KEY":        40007,
		"INVALID_TRANSACTION_ID":              40008,
		"ILLEGAL_MESSAGE_ID":                  40009,
		"ILLEGAL_FILTER_EXPRESSION":           40010,
		"ILLEGAL_INVISIBLE_TIME":              40011,
		"ILLEGAL_DELIVERY_TIME":               40012,
		"INVALID_RECEIPT_HANDLE":              40013,
		"MESSAGE_PROPERTY_CONFLICT_WITH_TYPE": 40014,
		"UNRECOGNIZED_CLIENT_TYPE":            40015,
		"MESSAGE_CORRUPTED":                   40016,
		"CLIENT_ID_REQUIRED":                  40017,
		"UNAUTHORIZED":                        40100,
		"PAYMENT_REQUIRED":                    40200,
		"FORBIDDEN":                           40300,
		"NOT_FOUND":                           40400,
		"MESSAGE_NOT_FOUND":                   40401,
		"TOPIC_NOT_FOUND":                     40402,
		"CONSUMER_GROUP_NOT_FOUND":            40403,
		"REQUEST_TIMEOUT":                     40800,
		"PAYLOAD_TOO_LARGE":                   41300,
		"MESSAGE_BODY_TOO_LARGE":              41301,
		"PRECONDITION_FAILED":                 42800,
		"TOO_MANY_REQUESTS":                   42900,
		"REQUEST_HEADER_FIELDS_TOO_LARGE":     43100,
		"MESSAGE_PROPERTIES_TOO_LARGE":        43101,
		"INTERNAL_ERROR":                      50000,
		"INTERNAL_SERVER_ERROR":               50001,
		"HA_NOT_AVAILABLE":                    50002,
		"NOT_IMPLEMENTED":                     50100,
		"PROXY_TIMEOUT":                       50400,
		"MASTER_PERSISTENCE_TIMEOUT":          50401,
		"SLAVE_PERSISTENCE_TIMEOUT":           50402,
		"UNSUPPORTED":                         50500,
		"VERSION_UNSUPPORTED":                 50501,
		"VERIFY_FIFO_MESSAGE_UNSUPPORTED":     50502,
		"FAILED_TO_CONSUME_MESSAGE":           60000,
	}
)

func (x Code) Enum() *Code {
	p := new(Code)
	*p = x
	return p
}

func (x Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Code) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[9].Descriptor()
}

func (Code) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[9]
}

func (x Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Code.Descriptor instead.
func (Code) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{9}
}

type Language int32

const (
	Language_LANGUAGE_UNSPECIFIED Language = 0
	Language_JAVA                 Language = 1
	Language_CPP                  Language = 2
	Language_DOT_NET              Language = 3
	Language_GOLANG               Language = 4
	Language_RUST                 Language = 5
	Language_PYTHON               Language = 6
	Language_PHP                  Language = 7
	Language_NODE_JS              Language = 8
	Language_RUBY                 Language = 9
	Language_OBJECTIVE_C          Language = 10
	Language_DART                 Language = 11
	Language_KOTLIN               Language = 12
)

// Enum value maps for Language.
var (
	Language_name = map[int32]string{
		0:  "LANGUAGE_UNSPECIFIED",
		1:  "JAVA",
		2:  "CPP",
		3:  "DOT_NET",
		4:  "GOLANG",
		5:  "RUST",
		6:  "PYTHON",
		7:  "PHP",
		8:  "NODE_JS",
		9:  "RUBY",
		10: "OBJECTIVE_C",
		11: "DART",
		12: "KOTLIN",
	}
	Language_value = map[string]int32{
		"LANGUAGE_UNSPECIFIED": 0,
		"JAVA":                 1,
		"CPP":                  2,
		"DOT_NET":              3,
		"GOLANG":               4,
		"RUST":                 5,
		"PYTHON":               6,
		"PHP":                  7,
		"NODE_JS":              8,
		"RUBY":                 9,
		"OBJECTIVE_C":          10,
		"DART":                 11,
		"KOTLIN":               12,
	}
)

func (x Language) Enum() *Language {
	p := new(Language)
	*p = x
	return p
}

func (x Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Language) Descriptor() protoreflect.EnumDescriptor {
	return file_definition_proto_enumTypes[10].Descriptor()
}

func (Language) Type() protoreflect.EnumType {
	return &file_definition_proto_enumTypes[10]
}

func (x Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Language.Descriptor instead.
func (Language) EnumDescriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{10}
}

type FilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type       FilterType `protobuf:"varint,1,opt,name=type,proto3,enum=apache.rocketmq.v2.FilterType" json:"type,omitempty"`
	Expression string     `protobuf:"bytes,2,opt,name=expression,proto3" json:"expression,omitempty"`
}

func (x *FilterExpression) Reset() {
	*x = FilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterExpression) ProtoMessage() {}

func (x *FilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterExpression.ProtoReflect.Descriptor instead.
func (*FilterExpression) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{0}
}

func (x *FilterExpression) GetType() FilterType {
	if x != nil {
		return x.Type
	}
	return FilterType_FILTER_TYPE_UNSPECIFIED
}

func (x *FilterExpression) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

type RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxAttempts int32 `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Types that are assignable to Strategy:
	//	*RetryPolicy_ExponentialBackoff
	//	*RetryPolicy_CustomizedBackoff
	Strategy isRetryPolicy_Strategy `protobuf_oneof:"strategy"`
}

func (x *RetryPolicy) Reset() {
	*x = RetryPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicy) ProtoMessage() {}

func (x *RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicy.ProtoReflect.Descriptor instead.
func (*RetryPolicy) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{1}
}

func (x *RetryPolicy) GetMaxAttempts() int32 {
	if x != nil {
		return x.MaxAttempts
	}
	return 0
}

func (m *RetryPolicy) GetStrategy() isRetryPolicy_Strategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (x *RetryPolicy) GetExponentialBackoff() *ExponentialBackoff {
	if x, ok := x.GetStrategy().(*RetryPolicy_ExponentialBackoff); ok {
		return x.ExponentialBackoff
	}
	return nil
}

func (x *RetryPolicy) GetCustomizedBackoff() *CustomizedBackoff {
	if x, ok := x.GetStrategy().(*RetryPolicy_CustomizedBackoff); ok {
		return x.CustomizedBackoff
	}
	return nil
}

type isRetryPolicy_Strategy interface {
	isRetryPolicy_Strategy()
}

type RetryPolicy_ExponentialBackoff struct {
	ExponentialBackoff *ExponentialBackoff `protobuf:"bytes,2,opt,name=exponential_backoff,json=exponentialBackoff,proto3,oneof"`
}

type RetryPolicy_CustomizedBackoff struct {
	CustomizedBackoff *CustomizedBackoff `protobuf:"bytes,3,opt,name=customized_backoff,json=customizedBackoff,proto3,oneof"`
}

func (*RetryPolicy_ExponentialBackoff) isRetryPolicy_Strategy() {}

func (*RetryPolicy_CustomizedBackoff) isRetryPolicy_Strategy() {}

// https://en.wikipedia.org/wiki/Exponential_backoff
type ExponentialBackoff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Initial    *durationpb.Duration `protobuf:"bytes,1,opt,name=initial,proto3" json:"initial,omitempty"`
	Max        *durationpb.Duration `protobuf:"bytes,2,opt,name=max,proto3" json:"max,omitempty"`
	Multiplier float32              `protobuf:"fixed32,3,opt,name=multiplier,proto3" json:"multiplier,omitempty"`
}

func (x *ExponentialBackoff) Reset() {
	*x = ExponentialBackoff{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExponentialBackoff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExponentialBackoff) ProtoMessage() {}

func (x *ExponentialBackoff) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExponentialBackoff.ProtoReflect.Descriptor instead.
func (*ExponentialBackoff) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{2}
}

func (x *ExponentialBackoff) GetInitial() *durationpb.Duration {
	if x != nil {
		return x.Initial
	}
	return nil
}

func (x *ExponentialBackoff) GetMax() *durationpb.Duration {
	if x != nil {
		return x.Max
	}
	return nil
}

func (x *ExponentialBackoff) GetMultiplier() float32 {
	if x != nil {
		return x.Multiplier
	}
	return 0
}

type CustomizedBackoff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// To support classic backoff strategy which is arbitrary defined by end users.
	// Typical values are: `1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h`
	Next []*durationpb.Duration `protobuf:"bytes,1,rep,name=next,proto3" json:"next,omitempty"`
}

func (x *CustomizedBackoff) Reset() {
	*x = CustomizedBackoff{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomizedBackoff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomizedBackoff) ProtoMessage() {}

func (x *CustomizedBackoff) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomizedBackoff.ProtoReflect.Descriptor instead.
func (*CustomizedBackoff) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{3}
}

func (x *CustomizedBackoff) GetNext() []*durationpb.Duration {
	if x != nil {
		return x.Next
	}
	return nil
}

type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ResourceNamespace string `protobuf:"bytes,1,opt,name=resource_namespace,json=resourceNamespace,proto3" json:"resource_namespace,omitempty"`
	// Resource name identifier, which remains unique within the abstract resource
	// namespace.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{4}
}

func (x *Resource) GetResourceNamespace() string {
	if x != nil {
		return x.ResourceNamespace
	}
	return ""
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type SubscriptionEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic      *Resource         `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Expression *FilterExpression `protobuf:"bytes,2,opt,name=expression,proto3" json:"expression,omitempty"`
}

func (x *SubscriptionEntry) Reset() {
	*x = SubscriptionEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubscriptionEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionEntry) ProtoMessage() {}

func (x *SubscriptionEntry) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionEntry.ProtoReflect.Descriptor instead.
func (*SubscriptionEntry) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{5}
}

func (x *SubscriptionEntry) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *SubscriptionEntry) GetExpression() *FilterExpression {
	if x != nil {
		return x.Expression
	}
	return nil
}

type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	Port int32  `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{6}
}

func (x *Address) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Address) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type Endpoints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Scheme    AddressScheme `protobuf:"varint,1,opt,name=scheme,proto3,enum=apache.rocketmq.v2.AddressScheme" json:"scheme,omitempty"`
	Addresses []*Address    `protobuf:"bytes,2,rep,name=addresses,proto3" json:"addresses,omitempty"`
}

func (x *Endpoints) Reset() {
	*x = Endpoints{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Endpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoints) ProtoMessage() {}

func (x *Endpoints) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoints.ProtoReflect.Descriptor instead.
func (*Endpoints) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{7}
}

func (x *Endpoints) GetScheme() AddressScheme {
	if x != nil {
		return x.Scheme
	}
	return AddressScheme_ADDRESS_SCHEME_UNSPECIFIED
}

func (x *Endpoints) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type Broker struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the broker
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Broker index. Canonically, index = 0 implies that the broker is playing
	// leader role while brokers with index > 0 play follower role.
	Id int32 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// Address of the broker, complying with the following scheme
	// 1. dns:[//authority/]host[:port]
	// 2. ipv4:address[:port][,address[:port],...] – IPv4 addresses
	// 3. ipv6:address[:port][,address[:port],...] – IPv6 addresses
	Endpoints *Endpoints `protobuf:"bytes,3,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
}

func (x *Broker) Reset() {
	*x = Broker{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Broker) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Broker) ProtoMessage() {}

func (x *Broker) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Broker.ProtoReflect.Descriptor instead.
func (*Broker) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{8}
}

func (x *Broker) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Broker) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Broker) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

type MessageQueue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic              *Resource     `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Id                 int32         `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	Permission         Permission    `protobuf:"varint,3,opt,name=permission,proto3,enum=apache.rocketmq.v2.Permission" json:"permission,omitempty"`
	Broker             *Broker       `protobuf:"bytes,4,opt,name=broker,proto3" json:"broker,omitempty"`
	AcceptMessageTypes []MessageType `protobuf:"varint,5,rep,packed,name=accept_message_types,json=acceptMessageTypes,proto3,enum=apache.rocketmq.v2.MessageType" json:"accept_message_types,omitempty"`
}

func (x *MessageQueue) Reset() {
	*x = MessageQueue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MessageQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageQueue) ProtoMessage() {}

func (x *MessageQueue) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageQueue.ProtoReflect.Descriptor instead.
func (*MessageQueue) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{9}
}

func (x *MessageQueue) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *MessageQueue) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *MessageQueue) GetPermission() Permission {
	if x != nil {
		return x.Permission
	}
	return Permission_PERMISSION_UNSPECIFIED
}

func (x *MessageQueue) GetBroker() *Broker {
	if x != nil {
		return x.Broker
	}
	return nil
}

func (x *MessageQueue) GetAcceptMessageTypes() []MessageType {
	if x != nil {
		return x.AcceptMessageTypes
	}
	return nil
}

// When publishing messages to or subscribing messages from brokers, clients
// shall include or validate digests of message body to ensure data integrity.
//
// For message publishing, when an invalid digest were detected, brokers need
// respond client with BAD_REQUEST.
//
// For messages subscription, when an invalid digest were detected, consumers
// need to handle this case according to message type:
// 1) Standard messages should be negatively acknowledged instantly, causing
// immediate re-delivery; 2) FIFO messages require special RPC, to re-fetch
// previously acquired messages batch;
type Digest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type     DigestType `protobuf:"varint,1,opt,name=type,proto3,enum=apache.rocketmq.v2.DigestType" json:"type,omitempty"`
	Checksum string     `protobuf:"bytes,2,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (x *Digest) Reset() {
	*x = Digest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Digest) ProtoMessage() {}

func (x *Digest) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Digest.ProtoReflect.Descriptor instead.
func (*Digest) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{10}
}

func (x *Digest) GetType() DigestType {
	if x != nil {
		return x.Type
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *Digest) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

type SystemProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tag, which is optional.
	Tag *string `protobuf:"bytes,1,opt,name=tag,proto3,oneof" json:"tag,omitempty"`
	// Message keys
	Keys []string `protobuf:"bytes,2,rep,name=keys,proto3" json:"keys,omitempty"`
	// Message identifier, client-side generated, remains unique.
	// if message_id is empty, the send message request will be aborted with
	// status `INVALID_ARGUMENT`
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// Message body digest
	BodyDigest *Digest `protobuf:"bytes,4,opt,name=body_digest,json=bodyDigest,proto3" json:"body_digest,omitempty"`
	// Message body encoding. Candidate options are identity, gzip, snappy etc.
	BodyEncoding Encoding `protobuf:"varint,5,opt,name=body_encoding,json=bodyEncoding,proto3,enum=apache.rocketmq.v2.Encoding" json:"body_encoding,omitempty"`
	// Message type, normal, FIFO or transactional.
	MessageType MessageType `protobuf:"varint,6,opt,name=message_type,json=messageType,proto3,enum=apache.rocketmq.v2.MessageType" json:"message_type,omitempty"`
	// Message born time-point.
	BornTimestamp *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=born_timestamp,json=bornTimestamp,proto3" json:"born_timestamp,omitempty"`
	// Message born host. Valid options are IPv4, IPv6 or client host domain name.
	BornHost string `protobuf:"bytes,8,opt,name=born_host,json=bornHost,proto3" json:"born_host,omitempty"`
	// Time-point at which the message is stored in the broker, which is absent
	// for message publishing.
	StoreTimestamp *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=store_timestamp,json=storeTimestamp,proto3,oneof" json:"store_timestamp,omitempty"`
	// The broker that stores this message. It may be broker name, IP or arbitrary
	// identifier that uniquely identify the server.
	StoreHost string `protobuf:"bytes,10,opt,name=store_host,json=storeHost,proto3" json:"store_host,omitempty"`
	// Time-point at which broker delivers to clients, which is optional.
	DeliveryTimestamp *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=delivery_timestamp,json=deliveryTimestamp,proto3,oneof" json:"delivery_timestamp,omitempty"`
	// If a message is acquired by way of POP, this field holds the receipt,
	// which is absent for message publishing.
	// Clients use the receipt to acknowledge or negatively acknowledge the
	// message.
	ReceiptHandle *string `protobuf:"bytes,12,opt,name=receipt_handle,json=receiptHandle,proto3,oneof" json:"receipt_handle,omitempty"`
	// Message queue identifier in which a message is physically stored.
	QueueId int32 `protobuf:"varint,13,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`
	// Message-queue offset at which a message is stored, which is absent for
	// message publishing.
	QueueOffset *int64 `protobuf:"varint,14,opt,name=queue_offset,json=queueOffset,proto3,oneof" json:"queue_offset,omitempty"`
	// Period of time servers would remain invisible once a message is acquired.
	InvisibleDuration *durationpb.Duration `protobuf:"bytes,15,opt,name=invisible_duration,json=invisibleDuration,proto3,oneof" json:"invisible_duration,omitempty"`
	// Business code may failed to process messages for the moment. Hence, clients
	// may request servers to deliver them again using certain back-off strategy,
	// the attempt is 1 not 0 if message is delivered first time, and it is absent
	// for message publishing.
	DeliveryAttempt *int32 `protobuf:"varint,16,opt,name=delivery_attempt,json=deliveryAttempt,proto3,oneof" json:"delivery_attempt,omitempty"`
	// Define the group name of message in the same topic, which is optional.
	MessageGroup *string `protobuf:"bytes,17,opt,name=message_group,json=messageGroup,proto3,oneof" json:"message_group,omitempty"`
	// Trace context for each message, which is optional.
	TraceContext *string `protobuf:"bytes,18,opt,name=trace_context,json=traceContext,proto3,oneof" json:"trace_context,omitempty"`
	// If a transactional message stay unresolved for more than
	// `transaction_orphan_threshold`, it would be regarded as an
	// orphan. Servers that manages orphan messages would pick up
	// a capable publisher to resolve
	OrphanedTransactionRecoveryDuration *durationpb.Duration `protobuf:"bytes,19,opt,name=orphaned_transaction_recovery_duration,json=orphanedTransactionRecoveryDuration,proto3,oneof" json:"orphaned_transaction_recovery_duration,omitempty"`
}

func (x *SystemProperties) Reset() {
	*x = SystemProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SystemProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemProperties) ProtoMessage() {}

func (x *SystemProperties) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemProperties.ProtoReflect.Descriptor instead.
func (*SystemProperties) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{11}
}

func (x *SystemProperties) GetTag() string {
	if x != nil && x.Tag != nil {
		return *x.Tag
	}
	return ""
}

func (x *SystemProperties) GetKeys() []string {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *SystemProperties) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *SystemProperties) GetBodyDigest() *Digest {
	if x != nil {
		return x.BodyDigest
	}
	return nil
}

func (x *SystemProperties) GetBodyEncoding() Encoding {
	if x != nil {
		return x.BodyEncoding
	}
	return Encoding_ENCODING_UNSPECIFIED
}

func (x *SystemProperties) GetMessageType() MessageType {
	if x != nil {
		return x.MessageType
	}
	return MessageType_MESSAGE_TYPE_UNSPECIFIED
}

func (x *SystemProperties) GetBornTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.BornTimestamp
	}
	return nil
}

func (x *SystemProperties) GetBornHost() string {
	if x != nil {
		return x.BornHost
	}
	return ""
}

func (x *SystemProperties) GetStoreTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.StoreTimestamp
	}
	return nil
}

func (x *SystemProperties) GetStoreHost() string {
	if x != nil {
		return x.StoreHost
	}
	return ""
}

func (x *SystemProperties) GetDeliveryTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.DeliveryTimestamp
	}
	return nil
}

func (x *SystemProperties) GetReceiptHandle() string {
	if x != nil && x.ReceiptHandle != nil {
		return *x.ReceiptHandle
	}
	return ""
}

func (x *SystemProperties) GetQueueId() int32 {
	if x != nil {
		return x.QueueId
	}
	return 0
}

func (x *SystemProperties) GetQueueOffset() int64 {
	if x != nil && x.QueueOffset != nil {
		return *x.QueueOffset
	}
	return 0
}

func (x *SystemProperties) GetInvisibleDuration() *durationpb.Duration {
	if x != nil {
		return x.InvisibleDuration
	}
	return nil
}

func (x *SystemProperties) GetDeliveryAttempt() int32 {
	if x != nil && x.DeliveryAttempt != nil {
		return *x.DeliveryAttempt
	}
	return 0
}

func (x *SystemProperties) GetMessageGroup() string {
	if x != nil && x.MessageGroup != nil {
		return *x.MessageGroup
	}
	return ""
}

func (x *SystemProperties) GetTraceContext() string {
	if x != nil && x.TraceContext != nil {
		return *x.TraceContext
	}
	return ""
}

func (x *SystemProperties) GetOrphanedTransactionRecoveryDuration() *durationpb.Duration {
	if x != nil {
		return x.OrphanedTransactionRecoveryDuration
	}
	return nil
}

type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Topic *Resource `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// User defined key-value pairs.
	// If user_properties contain the reserved keys by RocketMQ,
	// the send message request will be aborted with status `INVALID_ARGUMENT`.
	// See below links for the reserved keys
	// https://github.com/apache/rocketmq/blob/master/common/src/main/java/org/apache/rocketmq/common/message/MessageConst.java#L58
	UserProperties   map[string]string `protobuf:"bytes,2,rep,name=user_properties,json=userProperties,proto3" json:"user_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	SystemProperties *SystemProperties `protobuf:"bytes,3,opt,name=system_properties,json=systemProperties,proto3" json:"system_properties,omitempty"`
	Body             []byte            `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *Message) Reset() {
	*x = Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{12}
}

func (x *Message) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *Message) GetUserProperties() map[string]string {
	if x != nil {
		return x.UserProperties
	}
	return nil
}

func (x *Message) GetSystemProperties() *SystemProperties {
	if x != nil {
		return x.SystemProperties
	}
	return nil
}

func (x *Message) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

type Assignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MessageQueue *MessageQueue `protobuf:"bytes,1,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
}

func (x *Assignment) Reset() {
	*x = Assignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Assignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assignment) ProtoMessage() {}

func (x *Assignment) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assignment.ProtoReflect.Descriptor instead.
func (*Assignment) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{13}
}

func (x *Assignment) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

type Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Code    Code   `protobuf:"varint,1,opt,name=code,proto3,enum=apache.rocketmq.v2.Code" json:"code,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Status) Reset() {
	*x = Status{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{14}
}

func (x *Status) GetCode() Code {
	if x != nil {
		return x.Code
	}
	return Code_CODE_UNSPECIFIED
}

func (x *Status) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// User Agent
type UA struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SDK language
	Language Language `protobuf:"varint,1,opt,name=language,proto3,enum=apache.rocketmq.v2.Language" json:"language,omitempty"`
	// SDK version
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Platform details, including OS name, version, arch etc.
	Platform string `protobuf:"bytes,3,opt,name=platform,proto3" json:"platform,omitempty"`
	// Hostname of the node
	Hostname string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
}

func (x *UA) Reset() {
	*x = UA{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UA) ProtoMessage() {}

func (x *UA) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UA.ProtoReflect.Descriptor instead.
func (*UA) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{15}
}

func (x *UA) GetLanguage() Language {
	if x != nil {
		return x.Language
	}
	return Language_LANGUAGE_UNSPECIFIED
}

func (x *UA) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *UA) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *UA) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

type Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configurations for all clients.
	ClientType  *ClientType `protobuf:"varint,1,opt,name=client_type,json=clientType,proto3,enum=apache.rocketmq.v2.ClientType,oneof" json:"client_type,omitempty"`
	AccessPoint *Endpoints  `protobuf:"bytes,2,opt,name=access_point,json=accessPoint,proto3,oneof" json:"access_point,omitempty"`
	// If publishing of messages encounters throttling or server internal errors,
	// publishers should implement automatic retries after progressive longer
	// back-offs for consecutive errors.
	//
	// When processing message fails, `backoff_policy` describes an interval
	// after which the message should be available to consume again.
	//
	// For FIFO messages, the interval should be relatively small because
	// messages of the same message group would not be readily available until
	// the prior one depletes its lifecycle.
	BackoffPolicy *RetryPolicy `protobuf:"bytes,3,opt,name=backoff_policy,json=backoffPolicy,proto3,oneof" json:"backoff_policy,omitempty"`
	// Request timeout for RPCs excluding long-polling.
	RequestTimeout *durationpb.Duration `protobuf:"bytes,4,opt,name=request_timeout,json=requestTimeout,proto3,oneof" json:"request_timeout,omitempty"`
	// Types that are assignable to PubSub:
	//	*Settings_Publishing
	//	*Settings_Subscription
	PubSub isSettings_PubSub `protobuf_oneof:"pub_sub"`
	// User agent details
	UserAgent *UA     `protobuf:"bytes,7,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	Metric    *Metric `protobuf:"bytes,8,opt,name=metric,proto3" json:"metric,omitempty"`
}

func (x *Settings) Reset() {
	*x = Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{16}
}

func (x *Settings) GetClientType() ClientType {
	if x != nil && x.ClientType != nil {
		return *x.ClientType
	}
	return ClientType_CLIENT_TYPE_UNSPECIFIED
}

func (x *Settings) GetAccessPoint() *Endpoints {
	if x != nil {
		return x.AccessPoint
	}
	return nil
}

func (x *Settings) GetBackoffPolicy() *RetryPolicy {
	if x != nil {
		return x.BackoffPolicy
	}
	return nil
}

func (x *Settings) GetRequestTimeout() *durationpb.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (m *Settings) GetPubSub() isSettings_PubSub {
	if m != nil {
		return m.PubSub
	}
	return nil
}

func (x *Settings) GetPublishing() *Publishing {
	if x, ok := x.GetPubSub().(*Settings_Publishing); ok {
		return x.Publishing
	}
	return nil
}

func (x *Settings) GetSubscription() *Subscription {
	if x, ok := x.GetPubSub().(*Settings_Subscription); ok {
		return x.Subscription
	}
	return nil
}

func (x *Settings) GetUserAgent() *UA {
	if x != nil {
		return x.UserAgent
	}
	return nil
}

func (x *Settings) GetMetric() *Metric {
	if x != nil {
		return x.Metric
	}
	return nil
}

type isSettings_PubSub interface {
	isSettings_PubSub()
}

type Settings_Publishing struct {
	Publishing *Publishing `protobuf:"bytes,5,opt,name=publishing,proto3,oneof"`
}

type Settings_Subscription struct {
	Subscription *Subscription `protobuf:"bytes,6,opt,name=subscription,proto3,oneof"`
}

func (*Settings_Publishing) isSettings_PubSub() {}

func (*Settings_Subscription) isSettings_PubSub() {}

type Publishing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Publishing settings below here is appointed by client, thus it is
	// unnecessary for server to push at present.
	//
	// List of topics to which messages will publish to.
	Topics []*Resource `protobuf:"bytes,1,rep,name=topics,proto3" json:"topics,omitempty"`
	// If the message body size exceeds `max_body_size`, broker servers would
	// reject the request. As a result, it is advisable that Producer performs
	// client-side check validation.
	MaxBodySize int32 `protobuf:"varint,2,opt,name=max_body_size,json=maxBodySize,proto3" json:"max_body_size,omitempty"`
	// When `validate_message_type` flag set `false`, no need to validate message's type
	// with messageQueue's `accept_message_types` before publishing.
	ValidateMessageType bool `protobuf:"varint,3,opt,name=validate_message_type,json=validateMessageType,proto3" json:"validate_message_type,omitempty"`
}

func (x *Publishing) Reset() {
	*x = Publishing{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Publishing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Publishing) ProtoMessage() {}

func (x *Publishing) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Publishing.ProtoReflect.Descriptor instead.
func (*Publishing) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{17}
}

func (x *Publishing) GetTopics() []*Resource {
	if x != nil {
		return x.Topics
	}
	return nil
}

func (x *Publishing) GetMaxBodySize() int32 {
	if x != nil {
		return x.MaxBodySize
	}
	return 0
}

func (x *Publishing) GetValidateMessageType() bool {
	if x != nil {
		return x.ValidateMessageType
	}
	return false
}

type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subscription settings below here is appointed by client, thus it is
	// unnecessary for server to push at present.
	//
	// Consumer group.
	Group *Resource `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
	// Subscription for consumer.
	Subscriptions []*SubscriptionEntry `protobuf:"bytes,2,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Subscription settings below here are from server, it is essential for
	// server to push.
	//
	// When FIFO flag is `true`, messages of the same message group are processed
	// in first-in-first-out manner.
	//
	// Brokers will not deliver further messages of the same group until prior
	// ones are completely acknowledged.
	Fifo *bool `protobuf:"varint,3,opt,name=fifo,proto3,oneof" json:"fifo,omitempty"`
	// Message receive batch size here is essential for push consumer.
	ReceiveBatchSize *int32 `protobuf:"varint,4,opt,name=receive_batch_size,json=receiveBatchSize,proto3,oneof" json:"receive_batch_size,omitempty"`
	// Long-polling timeout for `ReceiveMessageRequest`, which is essential for
	// push consumer.
	LongPollingTimeout *durationpb.Duration `protobuf:"bytes,5,opt,name=long_polling_timeout,json=longPollingTimeout,proto3,oneof" json:"long_polling_timeout,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{18}
}

func (x *Subscription) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *Subscription) GetSubscriptions() []*SubscriptionEntry {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *Subscription) GetFifo() bool {
	if x != nil && x.Fifo != nil {
		return *x.Fifo
	}
	return false
}

func (x *Subscription) GetReceiveBatchSize() int32 {
	if x != nil && x.ReceiveBatchSize != nil {
		return *x.ReceiveBatchSize
	}
	return 0
}

func (x *Subscription) GetLongPollingTimeout() *durationpb.Duration {
	if x != nil {
		return x.LongPollingTimeout
	}
	return nil
}

type Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates that if client should export local metrics to server.
	On bool `protobuf:"varint,1,opt,name=on,proto3" json:"on,omitempty"`
	// The endpoint that client metrics should be exported to, which is required if the switch is on.
	Endpoints *Endpoints `protobuf:"bytes,2,opt,name=endpoints,proto3,oneof" json:"endpoints,omitempty"`
}

func (x *Metric) Reset() {
	*x = Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_definition_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_definition_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_definition_proto_rawDescGZIP(), []int{19}
}

func (x *Metric) GetOn() bool {
	if x != nil {
		return x.On
	}
	return false
}

func (x *Metric) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

var File_definition_proto protoreflect.FileDescriptor

var file_definition_proto_rawDesc = []byte{
	0x0a, 0x10, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x12, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x66, 0x0a, 0x10, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xef, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x78, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70,
	0x74, 0x73, 0x12, 0x59, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x56, 0x0a,
	0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x6f, 0x66, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66,
	0x48, 0x00, 0x52, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x61,
	0x63, 0x6b, 0x6f, 0x66, 0x66, 0x42, 0x0a, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x22, 0x96, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12, 0x33, 0x0a, 0x07, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x2b, 0x0a,
	0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x6d, 0x75,
	0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x22, 0x42, 0x0a, 0x11, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x12,
	0x2d, 0x0a, 0x04, 0x6e, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x65, 0x78, 0x74, 0x22, 0x4d,
	0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8d, 0x01,
	0x0a, 0x11, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x44, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x31, 0x0a,
	0x07, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74,
	0x22, 0x81, 0x01, 0x0a, 0x09, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x39,
	0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x09, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x09, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x22, 0x69, 0x0a, 0x06, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x3b, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22,
	0x99, 0x02, 0x0a, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x06, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f,
	0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72, 0x6f, 0x6b, 0x65, 0x72,
	0x52, 0x06, 0x62, 0x72, 0x6f, 0x6b, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x14, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x58, 0x0a, 0x06, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x75, 0x6d, 0x22, 0xc2, 0x09, 0x0a, 0x10, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x15, 0x0a, 0x03, 0x74, 0x61,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x74, 0x61, 0x67, 0x88, 0x01,
	0x01, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x62, 0x6f, 0x64, 0x79, 0x5f, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x52, 0x0a, 0x62, 0x6f, 0x64, 0x79, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x0d, 0x62, 0x6f, 0x64, 0x79, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e,
	0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0c, 0x62, 0x6f, 0x64, 0x79, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x42, 0x0a, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x0a, 0x0e, 0x62, 0x6f, 0x72, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x62, 0x6f,
	0x72, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x1b, 0x0a, 0x09, 0x62,
	0x6f, 0x72, 0x6e, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x62, 0x6f, 0x72, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52,
	0x0e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x88,
	0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x6f, 0x73,
	0x74, 0x12, 0x4e, 0x0a, 0x12, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x02, 0x52, 0x11, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x88, 0x01,
	0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x70, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a,
	0x08, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x07, 0x71, 0x75, 0x65, 0x75, 0x65, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x48, 0x04,
	0x52, 0x0b, 0x71, 0x75, 0x65, 0x75, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x4d, 0x0a, 0x12, 0x69, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x05, 0x52, 0x11, 0x69, 0x6e, 0x76, 0x69, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x2e, 0x0a, 0x10, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x65,
	0x6d, 0x70, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x48, 0x06, 0x52, 0x0f, 0x64, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x88, 0x01, 0x01, 0x12,
	0x28, 0x0a, 0x0d, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x08, 0x52, 0x0c, 0x74, 0x72, 0x61, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x88, 0x01, 0x01, 0x12, 0x73, 0x0a, 0x26, 0x6f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x65, 0x64, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x09,
	0x52, 0x23, 0x6f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x74, 0x61, 0x67,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x11, 0x0a, 0x0f, 0x5f,
	0x72, 0x65, 0x63, 0x65, 0x69, 0x70, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x42, 0x0f,
	0x0a, 0x0d, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42,
	0x15, 0x0a, 0x13, 0x5f, 0x69, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x5f,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42,
	0x29, 0x0a, 0x27, 0x5f, 0x6f, 0x72, 0x70, 0x68, 0x61, 0x6e, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x02, 0x0a, 0x07, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x58, 0x0a, 0x0f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x10, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x1a, 0x41, 0x0a, 0x13, 0x55,
	0x73, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x53,
	0x0a, 0x0a, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x0d,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x22, 0x50, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2c, 0x0a,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x02, 0x55, 0x41, 0x12, 0x38, 0x0a, 0x08,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1c,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x1a, 0x0a, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf5, 0x04, 0x0a, 0x08, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x44, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x48, 0x02, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x4b, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x03, 0x52, 0x0d, 0x62,
	0x61, 0x63, 0x6b, 0x6f, 0x66, 0x66, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x12,
	0x47, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x04, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x0a,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x12, 0x46, 0x0a, 0x0c, 0x73, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x41, 0x52, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x06, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42, 0x09, 0x0a,
	0x07, 0x70, 0x75, 0x62, 0x5f, 0x73, 0x75, 0x62, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x62, 0x61,
	0x63, 0x6b, 0x6f, 0x66, 0x66, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x22, 0x9a, 0x01, 0x0a, 0x0a, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x12,
	0x34, 0x0a, 0x06, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d,
	0x71, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x62, 0x6f, 0x64,
	0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61,
	0x78, 0x42, 0x6f, 0x64, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xf5, 0x02,
	0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37,
	0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x66, 0x69, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x01, 0x52, 0x04, 0x66, 0x69, 0x66, 0x6f, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a,
	0x12, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x10, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x50, 0x0a, 0x14, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x03, 0x52, 0x12, 0x6c, 0x6f, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x88,
	0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x66, 0x69, 0x66, 0x6f, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
	0x65, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x17, 0x0a, 0x15,
	0x5f, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x68, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12,
	0x0e, 0x0a, 0x02, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x02, 0x6f, 0x6e, 0x12,
	0x40, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x88, 0x01,
	0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2a,
	0x59, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x22, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x2a, 0x57, 0x0a, 0x11, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x16, 0x0a, 0x12, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x4f,
	0x55, 0x52, 0x43, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x43, 0x48, 0x45, 0x43,
	0x4b, 0x10, 0x02, 0x2a, 0x57, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x45, 0x41, 0x44, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x04, 0x2a, 0x3b, 0x0a, 0x0a,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x46, 0x49,
	0x4c, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x41, 0x47, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x53, 0x51, 0x4c, 0x10, 0x02, 0x2a, 0x54, 0x0a, 0x0d, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x44,
	0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50,
	0x76, 0x34, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50, 0x76, 0x36, 0x10, 0x02, 0x12, 0x0f,
	0x0a, 0x0b, 0x44, 0x4f, 0x4d, 0x41, 0x49, 0x4e, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x03, 0x2a,
	0x5d, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x49, 0x46, 0x4f,
	0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x2a, 0x47,
	0x0a, 0x0a, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x44, 0x49, 0x47, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x52, 0x43,
	0x33, 0x32, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4d, 0x44, 0x35, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x53, 0x48, 0x41, 0x31, 0x10, 0x03, 0x2a, 0x5f, 0x0a, 0x0a, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x45, 0x52, 0x10, 0x01,
	0x12, 0x11, 0x0a, 0x0d, 0x50, 0x55, 0x53, 0x48, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45,
	0x52, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x49, 0x4d, 0x50, 0x4c, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x10, 0x03, 0x2a, 0x3c, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x47, 0x5a, 0x49, 0x50, 0x10, 0x02, 0x2a, 0xe2, 0x09, 0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0xa0, 0x9c, 0x01, 0x12,
	0x16, 0x0a, 0x10, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x55,
	0x4c, 0x54, 0x53, 0x10, 0xb0, 0xea, 0x01, 0x12, 0x11, 0x0a, 0x0b, 0x42, 0x41, 0x44, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0xc0, 0xb8, 0x02, 0x12, 0x1a, 0x0a, 0x14, 0x49, 0x4c,
	0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x49,
	0x4e, 0x54, 0x10, 0xc1, 0xb8, 0x02, 0x12, 0x13, 0x0a, 0x0d, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41,
	0x4c, 0x5f, 0x54, 0x4f, 0x50, 0x49, 0x43, 0x10, 0xc2, 0xb8, 0x02, 0x12, 0x1c, 0x0a, 0x16, 0x49,
	0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f,
	0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0xc3, 0xb8, 0x02, 0x12, 0x19, 0x0a, 0x13, 0x49, 0x4c, 0x4c,
	0x45, 0x47, 0x41, 0x4c, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x41, 0x47,
	0x10, 0xc4, 0xb8, 0x02, 0x12, 0x19, 0x0a, 0x13, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f,
	0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0xc5, 0xb8, 0x02, 0x12,
	0x1b, 0x0a, 0x15, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x10, 0xc6, 0xb8, 0x02, 0x12, 0x22, 0x0a, 0x1c,
	0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f,
	0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x59, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0xc7, 0xb8, 0x02,
	0x12, 0x1c, 0x0a, 0x16, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x44, 0x10, 0xc8, 0xb8, 0x02, 0x12, 0x18,
	0x0a, 0x12, 0x49, 0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47,
	0x45, 0x5f, 0x49, 0x44, 0x10, 0xc9, 0xb8, 0x02, 0x12, 0x1f, 0x0a, 0x19, 0x49, 0x4c, 0x4c, 0x45,
	0x47, 0x41, 0x4c, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0xca, 0xb8, 0x02, 0x12, 0x1c, 0x0a, 0x16, 0x49, 0x4c, 0x4c,
	0x45, 0x47, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x56, 0x49, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0xcb, 0xb8, 0x02, 0x12, 0x1b, 0x0a, 0x15, 0x49, 0x4c, 0x4c, 0x45, 0x47,
	0x41, 0x4c, 0x5f, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x10, 0xcc, 0xb8, 0x02, 0x12, 0x1c, 0x0a, 0x16, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x52, 0x45, 0x43, 0x45, 0x49, 0x50, 0x54, 0x5f, 0x48, 0x41, 0x4e, 0x44, 0x4c, 0x45, 0x10, 0xcd,
	0xb8, 0x02, 0x12, 0x29, 0x0a, 0x23, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x52,
	0x4f, 0x50, 0x45, 0x52, 0x54, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54, 0x5f,
	0x57, 0x49, 0x54, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0xce, 0xb8, 0x02, 0x12, 0x1e, 0x0a,
	0x18, 0x55, 0x4e, 0x52, 0x45, 0x43, 0x4f, 0x47, 0x4e, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x43, 0x4c,
	0x49, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0xcf, 0xb8, 0x02, 0x12, 0x17, 0x0a,
	0x11, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x55, 0x50, 0x54,
	0x45, 0x44, 0x10, 0xd0, 0xb8, 0x02, 0x12, 0x18, 0x0a, 0x12, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54,
	0x5f, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0xd1, 0xb8, 0x02,
	0x12, 0x12, 0x0a, 0x0c, 0x55, 0x4e, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44,
	0x10, 0xa4, 0xb9, 0x02, 0x12, 0x16, 0x0a, 0x10, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x88, 0xba, 0x02, 0x12, 0x0f, 0x0a, 0x09,
	0x46, 0x4f, 0x52, 0x42, 0x49, 0x44, 0x44, 0x45, 0x4e, 0x10, 0xec, 0xba, 0x02, 0x12, 0x0f, 0x0a,
	0x09, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0xd0, 0xbb, 0x02, 0x12, 0x17,
	0x0a, 0x11, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0xd1, 0xbb, 0x02, 0x12, 0x15, 0x0a, 0x0f, 0x54, 0x4f, 0x50, 0x49, 0x43,
	0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0xd2, 0xbb, 0x02, 0x12, 0x1e,
	0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50,
	0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0xd3, 0xbb, 0x02, 0x12, 0x15,
	0x0a, 0x0f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55,
	0x54, 0x10, 0xe0, 0xbe, 0x02, 0x12, 0x17, 0x0a, 0x11, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0xd4, 0xc2, 0x02, 0x12, 0x1c,
	0x0a, 0x16, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x42, 0x4f, 0x44, 0x59, 0x5f, 0x54,
	0x4f, 0x4f, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0xd5, 0xc2, 0x02, 0x12, 0x19, 0x0a, 0x13,
	0x50, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0xb0, 0xce, 0x02, 0x12, 0x17, 0x0a, 0x11, 0x54, 0x4f, 0x4f, 0x5f, 0x4d,
	0x41, 0x4e, 0x59, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x53, 0x10, 0x94, 0xcf, 0x02,
	0x12, 0x25, 0x0a, 0x1f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x48, 0x45, 0x41, 0x44,
	0x45, 0x52, 0x5f, 0x46, 0x49, 0x45, 0x4c, 0x44, 0x53, 0x5f, 0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x41,
	0x52, 0x47, 0x45, 0x10, 0xdc, 0xd0, 0x02, 0x12, 0x22, 0x0a, 0x1c, 0x4d, 0x45, 0x53, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x49, 0x45, 0x53, 0x5f, 0x54, 0x4f,
	0x4f, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0xdd, 0xd0, 0x02, 0x12, 0x14, 0x0a, 0x0e, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0xd0, 0x86,
	0x03, 0x12, 0x1b, 0x0a, 0x15, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x45, 0x52, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0xd1, 0x86, 0x03, 0x12, 0x16,
	0x0a, 0x10, 0x48, 0x41, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42,
	0x4c, 0x45, 0x10, 0xd2, 0x86, 0x03, 0x12, 0x15, 0x0a, 0x0f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4d,
	0x50, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x45, 0x44, 0x10, 0xb4, 0x87, 0x03, 0x12, 0x13, 0x0a,
	0x0d, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54, 0x10, 0xe0,
	0x89, 0x03, 0x12, 0x20, 0x0a, 0x1a, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x50, 0x45, 0x52,
	0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55, 0x54,
	0x10, 0xe1, 0x89, 0x03, 0x12, 0x1f, 0x0a, 0x19, 0x53, 0x4c, 0x41, 0x56, 0x45, 0x5f, 0x50, 0x45,
	0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x4f, 0x55,
	0x54, 0x10, 0xe2, 0x89, 0x03, 0x12, 0x11, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f,
	0x52, 0x54, 0x45, 0x44, 0x10, 0xc4, 0x8a, 0x03, 0x12, 0x19, 0x0a, 0x13, 0x56, 0x45, 0x52, 0x53,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10,
	0xc5, 0x8a, 0x03, 0x12, 0x25, 0x0a, 0x1f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x5f, 0x46, 0x49,
	0x46, 0x4f, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x55, 0x50,
	0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0xc6, 0x8a, 0x03, 0x12, 0x1f, 0x0a, 0x19, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x5f,
	0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x10, 0xe0, 0xd4, 0x03, 0x2a, 0xad, 0x01, 0x0a, 0x08,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x41, 0x4e, 0x47,
	0x55, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x41, 0x56, 0x41, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x43, 0x50, 0x50, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x4f, 0x54, 0x5f, 0x4e, 0x45, 0x54,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x47, 0x4f, 0x4c, 0x41, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x08,
	0x0a, 0x04, 0x52, 0x55, 0x53, 0x54, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x59, 0x54, 0x48,
	0x4f, 0x4e, 0x10, 0x06, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x48, 0x50, 0x10, 0x07, 0x12, 0x0b, 0x0a,
	0x07, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x4a, 0x53, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x55,
	0x42, 0x59, 0x10, 0x09, 0x12, 0x0f, 0x0a, 0x0b, 0x4f, 0x42, 0x4a, 0x45, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x43, 0x10, 0x0a, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x52, 0x54, 0x10, 0x0b, 0x12,
	0x0a, 0x0a, 0x06, 0x4b, 0x4f, 0x54, 0x4c, 0x49, 0x4e, 0x10, 0x0c, 0x42, 0x52, 0x0a, 0x12, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x42, 0x08, 0x4d, 0x51, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x01, 0x5a, 0x15, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x72, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x76,
	0x32, 0x3b, 0x76, 0x32, 0xa0, 0x01, 0x01, 0xd8, 0x01, 0x01, 0xaa, 0x02, 0x12, 0x41, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x52, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x6d, 0x71, 0x2e, 0x56, 0x32, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_definition_proto_rawDescOnce sync.Once
	file_definition_proto_rawDescData = file_definition_proto_rawDesc
)

func file_definition_proto_rawDescGZIP() []byte {
	file_definition_proto_rawDescOnce.Do(func() {
		file_definition_proto_rawDescData = protoimpl.X.CompressGZIP(file_definition_proto_rawDescData)
	})
	return file_definition_proto_rawDescData
}

var file_definition_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_definition_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_definition_proto_goTypes = []interface{}{
	(TransactionResolution)(0),    // 0: apache.rocketmq.v2.TransactionResolution
	(TransactionSource)(0),        // 1: apache.rocketmq.v2.TransactionSource
	(Permission)(0),               // 2: apache.rocketmq.v2.Permission
	(FilterType)(0),               // 3: apache.rocketmq.v2.FilterType
	(AddressScheme)(0),            // 4: apache.rocketmq.v2.AddressScheme
	(MessageType)(0),              // 5: apache.rocketmq.v2.MessageType
	(DigestType)(0),               // 6: apache.rocketmq.v2.DigestType
	(ClientType)(0),               // 7: apache.rocketmq.v2.ClientType
	(Encoding)(0),                 // 8: apache.rocketmq.v2.Encoding
	(Code)(0),                     // 9: apache.rocketmq.v2.Code
	(Language)(0),                 // 10: apache.rocketmq.v2.Language
	(*FilterExpression)(nil),      // 11: apache.rocketmq.v2.FilterExpression
	(*RetryPolicy)(nil),           // 12: apache.rocketmq.v2.RetryPolicy
	(*ExponentialBackoff)(nil),    // 13: apache.rocketmq.v2.ExponentialBackoff
	(*CustomizedBackoff)(nil),     // 14: apache.rocketmq.v2.CustomizedBackoff
	(*Resource)(nil),              // 15: apache.rocketmq.v2.Resource
	(*SubscriptionEntry)(nil),     // 16: apache.rocketmq.v2.SubscriptionEntry
	(*Address)(nil),               // 17: apache.rocketmq.v2.Address
	(*Endpoints)(nil),             // 18: apache.rocketmq.v2.Endpoints
	(*Broker)(nil),                // 19: apache.rocketmq.v2.Broker
	(*MessageQueue)(nil),          // 20: apache.rocketmq.v2.MessageQueue
	(*Digest)(nil),                // 21: apache.rocketmq.v2.Digest
	(*SystemProperties)(nil),      // 22: apache.rocketmq.v2.SystemProperties
	(*Message)(nil),               // 23: apache.rocketmq.v2.Message
	(*Assignment)(nil),            // 24: apache.rocketmq.v2.Assignment
	(*Status)(nil),                // 25: apache.rocketmq.v2.Status
	(*UA)(nil),                    // 26: apache.rocketmq.v2.UA
	(*Settings)(nil),              // 27: apache.rocketmq.v2.Settings
	(*Publishing)(nil),            // 28: apache.rocketmq.v2.Publishing
	(*Subscription)(nil),          // 29: apache.rocketmq.v2.Subscription
	(*Metric)(nil),                // 30: apache.rocketmq.v2.Metric
	nil,                           // 31: apache.rocketmq.v2.Message.UserPropertiesEntry
	(*durationpb.Duration)(nil),   // 32: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil), // 33: google.protobuf.Timestamp
}
var file_definition_proto_depIdxs = []int32{
	3,  // 0: apache.rocketmq.v2.FilterExpression.type:type_name -> apache.rocketmq.v2.FilterType
	13, // 1: apache.rocketmq.v2.RetryPolicy.exponential_backoff:type_name -> apache.rocketmq.v2.ExponentialBackoff
	14, // 2: apache.rocketmq.v2.RetryPolicy.customized_backoff:type_name -> apache.rocketmq.v2.CustomizedBackoff
	32, // 3: apache.rocketmq.v2.ExponentialBackoff.initial:type_name -> google.protobuf.Duration
	32, // 4: apache.rocketmq.v2.ExponentialBackoff.max:type_name -> google.protobuf.Duration
	32, // 5: apache.rocketmq.v2.CustomizedBackoff.next:type_name -> google.protobuf.Duration
	15, // 6: apache.rocketmq.v2.SubscriptionEntry.topic:type_name -> apache.rocketmq.v2.Resource
	11, // 7: apache.rocketmq.v2.SubscriptionEntry.expression:type_name -> apache.rocketmq.v2.FilterExpression
	4,  // 8: apache.rocketmq.v2.Endpoints.scheme:type_name -> apache.rocketmq.v2.AddressScheme
	17, // 9: apache.rocketmq.v2.Endpoints.addresses:type_name -> apache.rocketmq.v2.Address
	18, // 10: apache.rocketmq.v2.Broker.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	15, // 11: apache.rocketmq.v2.MessageQueue.topic:type_name -> apache.rocketmq.v2.Resource
	2,  // 12: apache.rocketmq.v2.MessageQueue.permission:type_name -> apache.rocketmq.v2.Permission
	19, // 13: apache.rocketmq.v2.MessageQueue.broker:type_name -> apache.rocketmq.v2.Broker
	5,  // 14: apache.rocketmq.v2.MessageQueue.accept_message_types:type_name -> apache.rocketmq.v2.MessageType
	6,  // 15: apache.rocketmq.v2.Digest.type:type_name -> apache.rocketmq.v2.DigestType
	21, // 16: apache.rocketmq.v2.SystemProperties.body_digest:type_name -> apache.rocketmq.v2.Digest
	8,  // 17: apache.rocketmq.v2.SystemProperties.body_encoding:type_name -> apache.rocketmq.v2.Encoding
	5,  // 18: apache.rocketmq.v2.SystemProperties.message_type:type_name -> apache.rocketmq.v2.MessageType
	33, // 19: apache.rocketmq.v2.SystemProperties.born_timestamp:type_name -> google.protobuf.Timestamp
	33, // 20: apache.rocketmq.v2.SystemProperties.store_timestamp:type_name -> google.protobuf.Timestamp
	33, // 21: apache.rocketmq.v2.SystemProperties.delivery_timestamp:type_name -> google.protobuf.Timestamp
	32, // 22: apache.rocketmq.v2.SystemProperties.invisible_duration:type_name -> google.protobuf.Duration
	32, // 23: apache.rocketmq.v2.SystemProperties.orphaned_transaction_recovery_duration:type_name -> google.protobuf.Duration
	15, // 24: apache.rocketmq.v2.Message.topic:type_name -> apache.rocketmq.v2.Resource
	31, // 25: apache.rocketmq.v2.Message.user_properties:type_name -> apache.rocketmq.v2.Message.UserPropertiesEntry
	22, // 26: apache.rocketmq.v2.Message.system_properties:type_name -> apache.rocketmq.v2.SystemProperties
	20, // 27: apache.rocketmq.v2.Assignment.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	9,  // 28: apache.rocketmq.v2.Status.code:type_name -> apache.rocketmq.v2.Code
	10, // 29: apache.rocketmq.v2.UA.language:type_name -> apache.rocketmq.v2.Language
	7,  // 30: apache.rocketmq.v2.Settings.client_type:type_name -> apache.rocketmq.v2.ClientType
	18, // 31: apache.rocketmq.v2.Settings.access_point:type_name -> apache.rocketmq.v2.Endpoints
	12, // 32: apache.rocketmq.v2.Settings.backoff_policy:type_name -> apache.rocketmq.v2.RetryPolicy
	32, // 33: apache.rocketmq.v2.Settings.request_timeout:type_name -> google.protobuf.Duration
	28, // 34: apache.rocketmq.v2.Settings.publishing:type_name -> apache.rocketmq.v2.Publishing
	29, // 35: apache.rocketmq.v2.Settings.subscription:type_name -> apache.rocketmq.v2.Subscription
	26, // 36: apache.rocketmq.v2.Settings.user_agent:type_name -> apache.rocketmq.v2.UA
	30, // 37: apache.rocketmq.v2.Settings.metric:type_name -> apache.rocketmq.v2.Metric
	15, // 38: apache.rocketmq.v2.Publishing.topics:type_name -> apache.rocketmq.v2.Resource
	15, // 39: apache.rocketmq.v2.Subscription.group:type_name -> apache.rocketmq.v2.Resource
	16, // 40: apache.rocketmq.v2.Subscription.subscriptions:type_name -> apache.rocketmq.v2.SubscriptionEntry
	32, // 41: apache.rocketmq.v2.Subscription.long_polling_timeout:type_name -> google.protobuf.Duration
	18, // 42: apache.rocketmq.v2.Metric.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	43, // [43:43] is the sub-list for method output_type
	43, // [43:43] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_definition_proto_init() }
func file_definition_proto_init() {
	if File_definition_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_definition_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExponentialBackoff); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomizedBackoff); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubscriptionEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Address); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Endpoints); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Broker); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MessageQueue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Digest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SystemProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Assignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UA); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Publishing); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_definition_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_definition_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*RetryPolicy_ExponentialBackoff)(nil),
		(*RetryPolicy_CustomizedBackoff)(nil),
	}
	file_definition_proto_msgTypes[11].OneofWrappers = []interface{}{}
	file_definition_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*Settings_Publishing)(nil),
		(*Settings_Subscription)(nil),
	}
	file_definition_proto_msgTypes[18].OneofWrappers = []interface{}{}
	file_definition_proto_msgTypes[19].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_definition_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_definition_proto_goTypes,
		DependencyIndexes: file_definition_proto_depIdxs,
		EnumInfos:         file_definition_proto_enumTypes,
		MessageInfos:      file_definition_proto_msgTypes,
	}.Build()
	File_definition_proto = out.File
	file_definition_proto_rawDesc = nil
	file_definition_proto_goTypes = nil
	file_definition_proto_depIdxs = nil
}
