/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.aci.ACIItem;
import org.apache.directory.api.ldap.aci.ReusableAntlrACIItemLexer;
import org.apache.directory.api.ldap.aci.ReusableAntlrACIItemParser;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.NameComponentNormalizer;

public class ACIItemParser {
    private ReusableAntlrACIItemParser parser;
    private ReusableAntlrACIItemLexer lexer = new ReusableAntlrACIItemLexer(new StringReader(""));
    private final boolean isNormalizing;

    public ACIItemParser(SchemaManager schemaManager) {
        this.parser = new ReusableAntlrACIItemParser(this.lexer);
        this.parser.init(schemaManager);
        this.isNormalizing = false;
    }

    public ACIItemParser(NameComponentNormalizer normalizer, SchemaManager schemaManager) {
        this.parser = new ReusableAntlrACIItemParser(this.lexer);
        this.parser.setNormalizer(normalizer);
        this.isNormalizing = true;
        this.parser.init(schemaManager);
    }

    private synchronized void reset(String spec) {
        StringReader in = new StringReader(spec);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public synchronized ACIItem parse(String spec) throws ParseException {
        ACIItem aCIItem;
        if (spec == null || "".equals(spec.trim())) {
            return null;
        }
        this.reset(spec);
        try {
            aCIItem = this.parser.wrapperEntryPoint();
        }
        catch (TokenStreamException e) {
            throw new ParseException(I18n.err(I18n.ERR_07004_PARSER_FAILURE_ACI_ITEM, spec, e.getLocalizedMessage()), 0);
        }
        catch (RecognitionException e) {
            throw new ParseException(I18n.err(I18n.ERR_07004_PARSER_FAILURE_ACI_ITEM, spec, e.getLocalizedMessage(), e.getLine(), e.getColumn()), e.getColumn());
        }
        return aCIItem;
    }

    public boolean isNormizing() {
        return this.isNormalizing;
    }
}

