/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.wicketstuff.dashboard.WidgetLocation;

public abstract class SortableAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private static final String JSON_DATA = "data";

    public abstract void onSort(AjaxRequestTarget var1, Map<String, WidgetLocation> var2);

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        StringBuilder buffer = new StringBuilder();
        buffer.append("var data = serializeWidgetLocations();");
        buffer.append("return {'data': data};");
        attributes.getDynamicExtraParameters().add(buffer);
    }

    protected void respond(AjaxRequestTarget target) {
        String jsonData = this.getComponent().getRequest().getRequestParameters().getParameterValue(JSON_DATA).toString();
        Item[] items = this.getItems(jsonData);
        HashMap<String, WidgetLocation> locations = new HashMap<String, WidgetLocation>();
        for (Item item : items) {
            WidgetLocation location = new WidgetLocation(item.column, item.sortIndex);
            locations.put(item.widget, location);
        }
        this.onSort(target, locations);
    }

    private Item[] getItems(String jsonData) {
        Gson gson = new Gson();
        Item[] items = (Item[])gson.fromJson(jsonData, Item[].class);
        return items;
    }

    static class Item {
        public int column;
        public String widget;
        public int sortIndex;

        Item() {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Item[");
            buffer.append("column = ").append(this.column);
            buffer.append(" widget = ").append(this.widget);
            buffer.append(" sortIndex = ").append(this.sortIndex);
            buffer.append("]");
            return buffer.toString();
        }
    }
}

