/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.impl.util.AutoCloseableTraverser;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class TransformBatchedAutoCloseableP<T, R>
extends AbstractProcessor {
    private final Function<? super Iterable<T>, ? extends AutoCloseableTraverser<? extends R>> mapper;
    private AutoCloseableTraverser<? extends R> outputTraverser;
    private boolean isCooperative = true;

    public TransformBatchedAutoCloseableP(Function<? super Iterable<T>, ? extends AutoCloseableTraverser<? extends R>> mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean isCooperative() {
        return this.isCooperative;
    }

    public TransformBatchedAutoCloseableP<T, R> setCooperative(boolean cooperative) {
        this.isCooperative = cooperative;
        return this;
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.outputTraverser == null) {
            this.outputTraverser = this.mapper.apply(inbox);
        }
        if (this.emitFromTraverser(this.outputTraverser)) {
            inbox.clear();
            this.closeTraverser();
        }
    }

    @Override
    public void close() throws Exception {
        this.closeTraverser();
    }

    @Override
    public boolean closeIsCooperative() {
        return true;
    }

    private void closeTraverser() {
        if (this.outputTraverser != null) {
            try {
                this.outputTraverser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputTraverser = null;
        }
    }
}

