/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import java.io.Serializable;
import javax.sip.address.Hop;

public final class HopImpl
implements Hop,
Serializable {
    protected String host;
    protected int port;
    protected String transport;
    protected boolean defaultRoute;
    protected boolean uriRoute;

    @Override
    public String toString() {
        return this.host + ":" + this.port + "/" + this.transport;
    }

    public HopImpl(String hostName, int portNumber, String trans) {
        this.host = hostName;
        if (this.host.indexOf(":") >= 0 && this.host.indexOf("[") < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = portNumber;
        this.transport = trans;
    }

    HopImpl(String hop) throws IllegalArgumentException {
        if (hop == null) {
            throw new IllegalArgumentException("Null arg!");
        }
        int brack = hop.indexOf(93);
        int colon = hop.indexOf(58, brack);
        int slash = hop.indexOf(47, colon);
        if (colon > 0) {
            String portstr;
            this.host = hop.substring(0, colon);
            if (slash > 0) {
                portstr = hop.substring(colon + 1, slash);
                this.transport = hop.substring(slash + 1);
            } else {
                portstr = hop.substring(colon + 1);
                this.transport = "UDP";
            }
            try {
                this.port = Integer.parseInt(portstr);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Bad port spec");
            }
        } else if (slash > 0) {
            this.host = hop.substring(0, slash);
            this.transport = hop.substring(slash + 1);
            this.port = this.transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
        } else {
            this.host = hop;
            this.transport = "UDP";
            this.port = 5060;
        }
        if (this.host == null || this.host.length() == 0) {
            throw new IllegalArgumentException("no host!");
        }
        this.host = this.host.trim();
        this.transport = this.transport.trim();
        if (brack > 0 && this.host.charAt(0) != '[') {
            throw new IllegalArgumentException("Bad IPv6 reference spec");
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getTransport() {
        return this.transport;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }
}

