/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.plugins.wysiwyg;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.ui.plugins.wysiwyg.WysiwygBehavior;
import org.wicketstuff.jquery.ui.plugins.wysiwyg.toolbar.IWysiwygToolbar;

public class WysiwygEditor
extends FormComponentPanel<String>
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private HiddenField<String> textarea;
    private final WebMarkupContainer container = this.newMarkupContainer();

    public WysiwygEditor(String id) {
        this(id, null, null);
    }

    public WysiwygEditor(String id, IWysiwygToolbar toolbar) {
        this(id, null, toolbar);
    }

    public WysiwygEditor(String id, IModel<String> model) {
        this(id, model, null);
    }

    public WysiwygEditor(String id, IModel<String> model, IWysiwygToolbar toolbar) {
        super(id, model);
        this.add(new Component[]{this.container});
        if (toolbar != null) {
            toolbar.attachToEditor((Component)this.container);
        }
        this.setEscapeModelStrings(false);
    }

    public String getEditorMarkupId() {
        return this.container.getMarkupId();
    }

    public void convertInput() {
        PolicyFactory policy = this.newPolicyFactory();
        String input = (String)this.textarea.getConvertedInput();
        this.setConvertedInput(policy.sanitize(input));
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("wysiwygAddTextAreaMapper('%s', '%s')", this.container.getMarkupId(), this.textarea.getMarkupId())));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.textarea = new HiddenField("textarea", this.getModel());
        this.textarea.setOutputMarkupId(true);
        this.textarea.setEscapeModelStrings(false);
        this.add(new Component[]{this.textarea});
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((IJQueryWidget)this, (Component)this.container)});
    }

    public void onConfigure(JQueryBehavior behavior) {
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new WysiwygBehavior(selector);
    }

    private WebMarkupContainer newMarkupContainer() {
        return new WebMarkupContainer("container"){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!WysiwygEditor.this.getForm().isEnabled()) {
                    tag.put("contenteditable", (CharSequence)"false");
                }
            }
        };
    }

    protected PolicyFactory newPolicyFactory() {
        return new HtmlPolicyBuilder().allowCommonInlineFormattingElements().allowCommonBlockElements().allowElements(new String[]{"a"}).allowStandardUrlProtocols().allowAttributes(new String[]{"href", "target"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"size"}).onElements(new String[]{"font"}).allowAttributes(new String[]{"class", "style"}).globally().toFactory();
    }
}

