/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.executable.ExecutableValidator;
import jakarta.validation.executable.ValidateOnExecution;
import jakarta.validation.metadata.ConstructorDescriptor;
import jakarta.validation.metadata.MethodDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import org.apache.bval.cdi.BValBinding;
import org.apache.bval.cdi.BValExtension;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.ExecutableTypes;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.Proxies;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;

@Interceptor
@BValBinding
@Priority(value=4800)
public class BValInterceptor
implements Serializable {
    private volatile transient Set<ExecutableType> classConfiguration;
    private volatile transient Map<Signature, Boolean> executableValidation;
    @Inject
    private Validator validator;
    @Inject
    private BValExtension globalConfiguration;
    private volatile transient ExecutableValidator executableValidator;
    private volatile transient ConcurrentMap<Class<?>, Class<?>> classMapping;

    private static Collection<ExecutableType> removeFrom(Collection<ExecutableType> coll, ExecutableType ... executableTypes) {
        List<ExecutableType> toRemove;
        Validate.notNull(coll, "collection was null", new Object[0]);
        if (!(coll.isEmpty() || ObjectUtils.isEmptyArray(executableTypes) || Collections.disjoint(coll, toRemove = Arrays.asList(executableTypes)))) {
            EnumSet<ExecutableType> result = EnumSet.copyOf(coll);
            result.removeAll(toRemove);
            return result;
        }
        return coll;
    }

    @AroundConstruct
    public Object construct(InvocationContext context) throws Exception {
        Set<ConstraintViolation<Object>> violations;
        Set violations2;
        Constructor ctor = context.getConstructor();
        if (!this.isConstructorValidated(ctor)) {
            return context.proceed();
        }
        ConstructorDescriptor constraints = this.validator.getConstraintsForClass(ctor.getDeclaringClass()).getConstraintsForConstructor(ctor.getParameterTypes());
        if (!DescriptorManager.isConstrained(constraints)) {
            return context.proceed();
        }
        this.initExecutableValidator();
        if (constraints.hasConstrainedParameters() && !(violations2 = this.executableValidator.validateConstructorParameters(ctor, context.getParameters(), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        Object result = context.proceed();
        if (constraints.hasConstrainedReturnValue() && !(violations = this.executableValidator.validateConstructorReturnValue(ctor, context.getTarget(), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        return result;
    }

    @AroundInvoke
    public Object invoke(InvocationContext context) throws Exception {
        Set<ConstraintViolation<Object>> violations;
        Set<ConstraintViolation<Object>> violations2;
        Method method = context.getMethod();
        Class<?> targetClass = this.getTargetClass(context);
        if (!this.isExecutableValidated(targetClass, method, this::computeIsMethodValidated)) {
            return context.proceed();
        }
        MethodDescriptor constraintsForMethod = this.validator.getConstraintsForClass(targetClass).getConstraintsForMethod(method.getName(), method.getParameterTypes());
        if (!DescriptorManager.isConstrained(constraintsForMethod)) {
            return context.proceed();
        }
        this.initExecutableValidator();
        if (constraintsForMethod.hasConstrainedParameters() && !(violations2 = this.executableValidator.validateParameters(context.getTarget(), method, context.getParameters(), new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations2);
        }
        Object result = context.proceed();
        if (constraintsForMethod.hasConstrainedReturnValue() && !(violations = this.executableValidator.validateReturnValue(context.getTarget(), method, result, new Class[0])).isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getTargetClass(InvocationContext context) {
        Class<?> mapped;
        Class<?> key = context.getTarget().getClass();
        if (this.classMapping == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.classMapping == null) {
                    this.classMapping = new ConcurrentHashMap();
                }
            }
        }
        if ((mapped = (Class<?>)this.classMapping.get(key)) == null) {
            mapped = Proxies.classFor(key);
            this.classMapping.putIfAbsent(key, mapped);
        }
        return mapped;
    }

    private <T> boolean isConstructorValidated(Constructor<T> constructor) {
        return this.isExecutableValidated(constructor.getDeclaringClass(), constructor, this::computeIsConstructorValidated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Executable> boolean isExecutableValidated(Class<T> targetClass, E executable, BiPredicate<? super Class<T>, ? super E> compute) {
        this.initClassConfig(targetClass);
        if (this.executableValidation == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.executableValidation == null) {
                    this.executableValidation = new ConcurrentHashMap<Signature, Boolean>();
                }
            }
        }
        return this.executableValidation.computeIfAbsent(Signature.of(executable), s -> compute.test((Object)targetClass, (Object)executable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClassConfig(Class<?> targetClass) {
        if (this.classConfiguration == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.classConfiguration == null) {
                    AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(targetClass);
                    this.classConfiguration = annotatedType.isAnnotationPresent(ValidateOnExecution.class) ? ExecutableTypes.interpret(BValInterceptor.removeFrom(Arrays.asList(((ValidateOnExecution)annotatedType.getAnnotation(ValidateOnExecution.class)).type()), ExecutableType.IMPLICIT)) : this.globalConfiguration.getGlobalExecutableTypes();
                }
            }
        }
    }

    private <T> boolean computeIsConstructorValidated(Class<T> targetClass, Constructor<T> ctor) {
        AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(ctor.getDeclaringClass());
        ValidateOnExecution annotation = annotatedType.getConstructors().stream().filter(ac -> ctor.equals(ac.getJavaMember())).findFirst().map(ac -> (ValidateOnExecution)ac.getAnnotation(ValidateOnExecution.class)).orElseGet(() -> ctor.getAnnotation(ValidateOnExecution.class));
        Set<ExecutableType> validatedExecutableTypes = annotation == null ? this.classConfiguration : ExecutableTypes.interpret(annotation.type());
        return validatedExecutableTypes.contains((Object)ExecutableType.CONSTRUCTORS);
    }

    private <T> boolean computeIsMethodValidated(Class<T> targetClass, Method method) {
        Collection<ExecutableType> declaredExecutableTypes;
        Signature signature = Signature.of(method);
        AnnotatedMethod declaringMethod = null;
        for (Class<?> c : Reflection.hierarchy(targetClass, Reflection.Interfaces.INCLUDE)) {
            AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(c);
            AnnotatedMethod annotatedMethod = annotatedType.getMethods().stream().filter(am -> Signature.of(am.getJavaMember()).equals(signature)).findFirst().orElse(null);
            if (annotatedMethod == null) continue;
            declaringMethod = annotatedMethod;
        }
        if (declaringMethod == null) {
            return false;
        }
        if (declaringMethod.isAnnotationPresent(ValidateOnExecution.class)) {
            List<ExecutableType> validatedTypesOnMethod = Arrays.asList(((ValidateOnExecution)declaringMethod.getAnnotation(ValidateOnExecution.class)).type());
            if (validatedTypesOnMethod.contains((Object)ExecutableType.IMPLICIT)) {
                return true;
            }
            declaredExecutableTypes = validatedTypesOnMethod;
        } else {
            Package pkg;
            AnnotatedType declaringType = declaringMethod.getDeclaringType();
            declaredExecutableTypes = declaringType.isAnnotationPresent(ValidateOnExecution.class) ? BValInterceptor.removeFrom(Arrays.asList(((ValidateOnExecution)declaringType.getAnnotation(ValidateOnExecution.class)).type()), ExecutableType.IMPLICIT) : ((pkg = declaringType.getJavaClass().getPackage()) != null && pkg.isAnnotationPresent(ValidateOnExecution.class) ? BValInterceptor.removeFrom(Arrays.asList(pkg.getAnnotation(ValidateOnExecution.class).type()), ExecutableType.IMPLICIT) : null);
        }
        ExecutableType methodType = Methods.isGetter(method) ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS;
        return Optional.ofNullable(declaredExecutableTypes).map(ExecutableTypes::interpret).orElse(this.globalConfiguration.getGlobalExecutableTypes()).contains((Object)methodType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExecutableValidator() {
        if (this.executableValidator == null) {
            BValInterceptor bValInterceptor = this;
            synchronized (bValInterceptor) {
                if (this.executableValidator == null) {
                    this.executableValidator = this.validator.forExecutables();
                }
            }
        }
    }
}

