/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfoBuilder;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.logs.SdkLogger;
import javax.annotation.Nullable;

final class SdkLoggerBuilder
implements LoggerBuilder {
    private final ComponentRegistry<SdkLogger> registry;
    private final InstrumentationScopeInfoBuilder scopeBuilder;
    @Nullable
    private String eventDomain;

    SdkLoggerBuilder(ComponentRegistry<SdkLogger> registry, String instrumentationScopeName) {
        this.registry = registry;
        this.scopeBuilder = InstrumentationScopeInfo.builder((String)instrumentationScopeName);
    }

    public LoggerBuilder setEventDomain(String eventDomain) {
        this.eventDomain = eventDomain;
        return this;
    }

    public SdkLoggerBuilder setSchemaUrl(String schemaUrl) {
        this.scopeBuilder.setSchemaUrl(schemaUrl);
        return this;
    }

    public SdkLoggerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        this.scopeBuilder.setVersion(instrumentationScopeVersion);
        return this;
    }

    public SdkLogger build() {
        SdkLogger logger = (SdkLogger)this.registry.get(this.scopeBuilder.build());
        return this.eventDomain == null ? logger : logger.withEventDomain(this.eventDomain);
    }
}

