/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum DeprecationIssueType {
    AUTHORIZATIONCOVEREDBYWILDCARD("AuthorizationCoveredByWildcard"),
    CANREQUESTURLHTTPCONTAININGNEWLINE("CanRequestURLHTTPContainingNewline"),
    CHROMELOADTIMESCONNECTIONINFO("ChromeLoadTimesConnectionInfo"),
    CHROMELOADTIMESFIRSTPAINTAFTERLOADTIME("ChromeLoadTimesFirstPaintAfterLoadTime"),
    CHROMELOADTIMESWASALTERNATEPROTOCOLAVAILABLE("ChromeLoadTimesWasAlternateProtocolAvailable"),
    COOKIEWITHTRUNCATINGCHAR("CookieWithTruncatingChar"),
    CROSSORIGINACCESSBASEDONDOCUMENTDOMAIN("CrossOriginAccessBasedOnDocumentDomain"),
    CROSSORIGINWINDOWALERT("CrossOriginWindowAlert"),
    CROSSORIGINWINDOWCONFIRM("CrossOriginWindowConfirm"),
    CSSSELECTORINTERNALMEDIACONTROLSOVERLAYCASTBUTTON("CSSSelectorInternalMediaControlsOverlayCastButton"),
    DEPRECATIONEXAMPLE("DeprecationExample"),
    DOCUMENTDOMAINSETTINGWITHOUTORIGINAGENTCLUSTERHEADER("DocumentDomainSettingWithoutOriginAgentClusterHeader"),
    EVENTPATH("EventPath"),
    EXPECTCTHEADER("ExpectCTHeader"),
    GEOLOCATIONINSECUREORIGIN("GeolocationInsecureOrigin"),
    GEOLOCATIONINSECUREORIGINDEPRECATEDNOTREMOVED("GeolocationInsecureOriginDeprecatedNotRemoved"),
    GETUSERMEDIAINSECUREORIGIN("GetUserMediaInsecureOrigin"),
    HOSTCANDIDATEATTRIBUTEGETTER("HostCandidateAttributeGetter"),
    IDENTITYINCANMAKEPAYMENTEVENT("IdentityInCanMakePaymentEvent"),
    INSECUREPRIVATENETWORKSUBRESOURCEREQUEST("InsecurePrivateNetworkSubresourceRequest"),
    LEGACYCONSTRAINTGOOGIPV6("LegacyConstraintGoogIPv6"),
    LOCALCSSFILEEXTENSIONREJECTED("LocalCSSFileExtensionRejected"),
    MEDIASOURCEABORTREMOVE("MediaSourceAbortRemove"),
    MEDIASOURCEDURATIONTRUNCATINGBUFFERED("MediaSourceDurationTruncatingBuffered"),
    NAVIGATEEVENTRESTORESCROLL("NavigateEventRestoreScroll"),
    NAVIGATEEVENTTRANSITIONWHILE("NavigateEventTransitionWhile"),
    NOSYSEXWEBMIDIWITHOUTPERMISSION("NoSysexWebMIDIWithoutPermission"),
    NOTIFICATIONINSECUREORIGIN("NotificationInsecureOrigin"),
    NOTIFICATIONPERMISSIONREQUESTEDIFRAME("NotificationPermissionRequestedIframe"),
    OBSOLETEWEBRTCCIPHERSUITE("ObsoleteWebRtcCipherSuite"),
    OPENWEBDATABASEINSECURECONTEXT("OpenWebDatabaseInsecureContext"),
    OVERFLOWVISIBLEONREPLACEDELEMENT("OverflowVisibleOnReplacedElement"),
    PERSISTENTQUOTATYPE("PersistentQuotaType"),
    PICTURESOURCESRC("PictureSourceSrc"),
    PREFIXEDCANCELANIMATIONFRAME("PrefixedCancelAnimationFrame"),
    PREFIXEDREQUESTANIMATIONFRAME("PrefixedRequestAnimationFrame"),
    PREFIXEDSTORAGEINFO("PrefixedStorageInfo"),
    PREFIXEDVIDEODISPLAYINGFULLSCREEN("PrefixedVideoDisplayingFullscreen"),
    PREFIXEDVIDEOENTERFULLSCREEN("PrefixedVideoEnterFullscreen"),
    PREFIXEDVIDEOEXITFULLSCREEN("PrefixedVideoExitFullscreen"),
    PREFIXEDVIDEOSUPPORTSFULLSCREEN("PrefixedVideoSupportsFullscreen"),
    RANGEEXPAND("RangeExpand"),
    REQUESTEDSUBRESOURCEWITHEMBEDDEDCREDENTIALS("RequestedSubresourceWithEmbeddedCredentials"),
    RTCCONSTRAINTENABLEDTLSSRTPFALSE("RTCConstraintEnableDtlsSrtpFalse"),
    RTCCONSTRAINTENABLEDTLSSRTPTRUE("RTCConstraintEnableDtlsSrtpTrue"),
    RTCPEERCONNECTIONCOMPLEXPLANBSDPUSINGDEFAULTSDPSEMANTICS("RTCPeerConnectionComplexPlanBSdpUsingDefaultSdpSemantics"),
    RTCPEERCONNECTIONSDPSEMANTICSPLANB("RTCPeerConnectionSdpSemanticsPlanB"),
    RTCPMUXPOLICYNEGOTIATE("RtcpMuxPolicyNegotiate"),
    SHAREDARRAYBUFFERCONSTRUCTEDWITHOUTISOLATION("SharedArrayBufferConstructedWithoutIsolation"),
    TEXTTOSPEECH_DISALLOWEDBYAUTOPLAY("TextToSpeech_DisallowedByAutoplay"),
    V8SHAREDARRAYBUFFERCONSTRUCTEDINEXTENSIONWITHOUTISOLATION("V8SharedArrayBufferConstructedInExtensionWithoutIsolation"),
    XHRJSONENCODINGDETECTION("XHRJSONEncodingDetection"),
    XMLHTTPREQUESTSYNCHRONOUSINNONWORKEROUTSIDEBEFOREUNLOAD("XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload"),
    XRSUPPORTSSESSION("XRSupportsSession");

    private String value;

    private DeprecationIssueType(String value) {
        this.value = value;
    }

    public static DeprecationIssueType fromString(String s) {
        return Arrays.stream(DeprecationIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within DeprecationIssueType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static DeprecationIssueType fromJson(JsonInput input) {
        return DeprecationIssueType.fromString(input.nextString());
    }
}

