/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class ShorthandEntry {
    private final String name;
    private final String value;
    private final Optional<Boolean> important;

    public ShorthandEntry(String name, String value, Optional<Boolean> important) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.important = important;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<Boolean> getImportant() {
        return this.important;
    }

    private static ShorthandEntry fromJson(JsonInput input) {
        String name = null;
        String value = null;
        Optional<Boolean> important = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block10;
                }
                case "value": {
                    value = input.nextString();
                    continue block10;
                }
                case "important": {
                    important = Optional.ofNullable(input.nextBoolean());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ShorthandEntry(name, value, important);
    }
}

