/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.archive.util.TextUtils;

public class PublicSuffixes {
    protected static Pattern topmostAssignedSurtPrefixPattern;
    protected static String topmostAssignedSurtPrefixRegex;

    public static void main(String[] args) throws IOException {
        BufferedWriter writer;
        InputStream is = args.length == 0 || "=".equals(args[0]) ? PublicSuffixes.class.getClassLoader().getResourceAsStream("effective_tld_names.dat") : new FileInputStream(args[0]);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String regex = PublicSuffixes.getTopmostAssignedSurtPrefixRegex(reader);
        IOUtils.closeQuietly((InputStream)is);
        boolean needsClose = false;
        if (args.length >= 2) {
            writer = new BufferedWriter(new FileWriter(args[1]));
            needsClose = true;
        } else {
            writer = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        writer.append(regex);
        writer.flush();
        if (needsClose) {
            writer.close();
        }
    }

    protected static Node readPublishedFileToSurtTrie(BufferedReader reader) throws IOException {
        String line;
        Node alt = new Node(null, new ArrayList<Node>());
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("//")) continue;
            line = line.split("\\s+")[0];
            line = line.toLowerCase();
            String[] segs = line.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (int i = segs.length - 1; i >= 0; --i) {
                if (segs[i].length() == 0) continue;
                sb.append(segs[i]).append(',');
            }
            alt.addBranch(sb.toString());
        }
        return alt;
    }

    public static void dump(Node alt, int lv, PrintWriter out) {
        for (int i = 0; i < lv; ++i) {
            out.print("  ");
        }
        out.println(alt.cs != null ? '\"' + alt.cs.toString() + '\"' : "(null)");
        if (alt.branches != null) {
            for (Node br : alt.branches) {
                PublicSuffixes.dump(br, lv + 1, out);
            }
        }
    }

    protected static void buildRegex(Node alt, StringBuilder sb) {
        String close = null;
        if (alt.cs != null) {
            for (int i = 0; i < alt.cs.length(); ++i) {
                char c = alt.cs.charAt(i);
                if (c == '!') {
                    if (close != null) {
                        throw new RuntimeException("more than one '!'");
                    }
                    sb.append("(?=");
                    close = ")";
                    continue;
                }
                if (c == '*') {
                    sb.append("[-\\w]+");
                    continue;
                }
                sb.append(c);
            }
        }
        if (alt.branches != null) {
            if (alt.branches.size() > 1) {
                sb.append("(?:");
            }
            String sep = "";
            for (Node alt1 : alt.branches) {
                sb.append(sep);
                sep = "|";
                PublicSuffixes.buildRegex(alt1, sb);
            }
            if (alt.branches.size() > 1) {
                sb.append(")");
            }
        }
        if (close != null) {
            sb.append(close);
        }
    }

    private static String surtPrefixRegexFromTrie(Node trie) {
        StringBuilder regex = new StringBuilder();
        regex.append("(?ix)^\n");
        trie.addBranch("*,");
        PublicSuffixes.buildRegex(trie, regex);
        regex.append("\n([-\\w]+,)");
        return regex.toString();
    }

    public static synchronized Pattern getTopmostAssignedSurtPrefixPattern() {
        if (topmostAssignedSurtPrefixPattern == null) {
            topmostAssignedSurtPrefixPattern = Pattern.compile(PublicSuffixes.getTopmostAssignedSurtPrefixRegex());
        }
        return topmostAssignedSurtPrefixPattern;
    }

    public static synchronized String getTopmostAssignedSurtPrefixRegex() {
        if (topmostAssignedSurtPrefixRegex == null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(PublicSuffixes.class.getClassLoader().getResourceAsStream("effective_tld_names.dat"), "UTF-8"));
                topmostAssignedSurtPrefixRegex = PublicSuffixes.getTopmostAssignedSurtPrefixRegex(reader);
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return topmostAssignedSurtPrefixRegex;
    }

    public static String getTopmostAssignedSurtPrefixRegex(BufferedReader reader) {
        try {
            Node trie = PublicSuffixes.readPublishedFileToSurtTrie(reader);
            return PublicSuffixes.surtPrefixRegexFromTrie(trie);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String reduceSurtToAssignmentLevel(String surt) {
        Matcher matcher = TextUtils.getMatcher(PublicSuffixes.getTopmostAssignedSurtPrefixRegex(), surt);
        if (matcher.find()) {
            surt = matcher.group();
        }
        TextUtils.recycleMatcher(matcher);
        return surt;
    }

    public static class Node
    implements Comparable<Node> {
        protected CharSequence cs;
        protected List<Node> branches;

        public Node() {
            this("", null);
        }

        protected Node(CharSequence cs) {
            this(cs, null);
        }

        protected Node(CharSequence cs, List<Node> branches) {
            this.cs = cs;
            this.branches = branches;
        }

        public void addBranch(CharSequence s) {
            if (this.branches == null) {
                this.branches = new ArrayList<Node>();
                this.branches.add(new Node("", null));
            }
            for (int i = 0; i < this.branches.size(); ++i) {
                Node alt = this.branches.get(i);
                if (alt.add(s)) {
                    return;
                }
                if (alt.compareTo(s.charAt(0)) <= 0) continue;
                Node alt1 = new Node(s, null);
                this.branches.add(i, alt1);
                return;
            }
            Node alt2 = new Node(s, null);
            this.branches.add(alt2);
        }

        public boolean add(CharSequence s) {
            int i;
            int l = Math.min(s.length(), this.cs.length());
            for (i = 0; i < l && s.charAt(i) == this.cs.charAt(i); ++i) {
            }
            if (i == 0) {
                return this.cs.length() == 0 && s.length() == 0;
            }
            if (i < this.cs.length()) {
                CharSequence cs0 = this.cs.subSequence(0, i);
                CharSequence cs1 = this.cs.subSequence(i, this.cs.length());
                CharSequence cs2 = s.subSequence(i, s.length());
                this.cs = cs0;
                Node alt1 = new Node(cs1, this.branches);
                this.branches = new ArrayList<Node>();
                this.branches.add(alt1);
                this.addBranch(cs2);
            } else {
                assert (i == this.cs.length());
                this.addBranch(s.subSequence(i, s.length()));
            }
            return true;
        }

        @Override
        public int compareTo(Node other) {
            if (other.cs == null || other.cs.length() == 0) {
                return this.cs == null || this.cs.length() == 0 ? 0 : -1;
            }
            return this.compareTo(other.cs.charAt(0));
        }

        @Override
        public int compareTo(char oc) {
            if (this.cs == null || this.cs.length() == 0) {
                return 1;
            }
            char c = this.cs.charAt(0);
            if (c == oc) {
                return 0;
            }
            if (c == '!') {
                return oc == '*' ? -1 : 1;
            }
            if (c == '*') {
                return 1;
            }
            if (oc == '*' || oc == '!') {
                return -1;
            }
            return Character.valueOf(c).compareTo(Character.valueOf(oc));
        }
    }
}

