/*
 * Decompiled with CFR 0.152.
 */
package org.archive.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.archive.format.json.JSONView;
import org.archive.hadoop.ArchiveMetadataLoader;
import org.json.JSONException;
import org.json.JSONObject;

public class ArchiveJSONViewLoader
extends ArchiveMetadataLoader {
    private static final Logger LOG = Logger.getLogger(ArchiveJSONViewLoader.class.getName());
    protected TupleFactory mCacheTupleFactory = TupleFactory.getInstance();
    private ArrayList<Object> mCacheProtoTuple = null;
    private JSONView view;
    ArrayList<Tuple> cached;

    public ArchiveJSONViewLoader(String ... fieldArgs) {
        Logger.getLogger("org.archive").setLevel(Level.WARNING);
        this.mCacheProtoTuple = new ArrayList();
        this.cached = null;
        if (fieldArgs.length == 0) {
            LOG.info("Constructed with NO foo");
            throw new RuntimeException("No field definition");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("ArchiveJSONViewLoader:(" + StringUtils.join((Object[])fieldArgs, (String)",") + ")");
        }
        this.view = new JSONView(fieldArgs);
    }

    @Override
    public Tuple getNext() throws IOException {
        Tuple inner;
        if (this.cached == null && (inner = super.getNext()) != null) {
            this.cached = this.applyView(inner);
        }
        if (this.cached != null) {
            Tuple n = this.cached.remove(0);
            if (this.cached.size() == 0) {
                this.cached = null;
            }
            return n;
        }
        return null;
    }

    private ArrayList<Tuple> applyView(Tuple inner) {
        if (inner == null || inner.size() == 0) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(inner.get(2).toString());
            List<List<String>> matches = this.view.apply(json);
            if (matches.size() == 0) {
                return null;
            }
            ArrayList<Tuple> results = new ArrayList<Tuple>();
            for (List<String> t : matches) {
                this.mCacheProtoTuple.addAll(t);
                Tuple tup = this.mCacheTupleFactory.newTuple(this.mCacheProtoTuple);
                this.mCacheProtoTuple.clear();
                results.add(tup);
            }
            return results;
        }
        catch (JSONException e) {
            LOG.warning("Failed to parse JSON:" + e.getMessage());
        }
        catch (ExecException e) {
            LOG.warning("ExecException:" + e.getMessage());
        }
        return null;
    }
}

