/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggStreamIdentifier;
import org.gagravarr.skeleton.SkeletonPacket;
import org.gagravarr.skeleton.SkeletonPacketFactory;

public class OggDetector
implements Detector {
    private static final long serialVersionUID = 591382028699008553L;
    public static final MediaType OGG_GENERAL = MediaType.application((String)"ogg");
    protected static final MediaType OGG_AUDIO = MediaType.audio((String)"ogg");
    protected static final MediaType OGG_VIDEO = MediaType.video((String)"ogg");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        if (!input.markSupported()) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(4);
        try {
            if (input.read() != 79 || input.read() != 103 || input.read() != 103 || input.read() != 83) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        finally {
            input.reset();
        }
        TikaInputStream tis = TikaInputStream.cast((InputStream)input);
        if (tis != null) {
            OggStreamIdentifier.OggStreamType type;
            OggPacket p;
            tis.mark((int)tis.getLength() + 1);
            OggFile ogg = new OggFile((InputStream)tis);
            int totalStreams = 0;
            ArrayList<Integer> sids = new ArrayList<Integer>();
            HashMap<OggStreamIdentifier.OggStreamType, Integer> streams = new HashMap<OggStreamIdentifier.OggStreamType, Integer>();
            HashMap skeletonStreams = new HashMap();
            OggPacketReader r = ogg.getPacketReader();
            while ((p = r.getNextPacket()) != null) {
                if (p.isBeginningOfStream()) {
                    Integer num;
                    ++totalStreams;
                    sids.add(p.getSid());
                    type = OggStreamIdentifier.identifyType(p);
                    if (type == OggStreamIdentifier.SKELETON) {
                        ArrayList<SkeletonPacket> sp = new ArrayList<SkeletonPacket>();
                        sp.add(SkeletonPacketFactory.create(p));
                        skeletonStreams.put(p.getSid(), sp);
                    }
                    num = (num = (Integer)streams.get(type)) == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
                    streams.put(type, num);
                    continue;
                }
                Integer sid = p.getSid();
                if (!skeletonStreams.containsKey(sid)) continue;
                ((List)skeletonStreams.get(sid)).add(SkeletonPacketFactory.create(p));
            }
            tis.reset();
            if (totalStreams == 1) {
                type = (OggStreamIdentifier.OggStreamType)streams.keySet().iterator().next();
                return OggDetector.toMediaType(type);
            }
            int nonMetadataStreams = 0;
            for (OggStreamIdentifier.OggStreamType type2 : streams.keySet()) {
                if (type2.kind == OggStreamIdentifier.OggStreamType.Kind.METADATA) continue;
                nonMetadataStreams += ((Integer)streams.get(type2)).intValue();
            }
            if (nonMetadataStreams == 0) {
                return OGG_GENERAL;
            }
            if (nonMetadataStreams == 1) {
                for (OggStreamIdentifier.OggStreamType type2 : streams.keySet()) {
                    if (type2.kind == OggStreamIdentifier.OggStreamType.Kind.METADATA) continue;
                    return OggDetector.toMediaType(type2);
                }
            }
            int videoCount = 0;
            int audioCount = 0;
            int kateCount = 0;
            HashSet<OggStreamIdentifier.OggStreamType> audioTypes = new HashSet<OggStreamIdentifier.OggStreamType>();
            HashSet<OggStreamIdentifier.OggStreamType> videoTypes = new HashSet<OggStreamIdentifier.OggStreamType>();
            for (OggStreamIdentifier.OggStreamType type3 : streams.keySet()) {
                if (type3.kind == OggStreamIdentifier.OggStreamType.Kind.VIDEO) {
                    videoCount += ((Integer)streams.get(type3)).intValue();
                    videoTypes.add(type3);
                    continue;
                }
                if (type3.kind == OggStreamIdentifier.OggStreamType.Kind.AUDIO) {
                    audioCount += ((Integer)streams.get(type3)).intValue();
                    audioTypes.add(type3);
                    continue;
                }
                if (type3 != OggStreamIdentifier.KATE) continue;
                ++kateCount;
            }
            if (videoCount == 1) {
                return OggDetector.toMediaType((OggStreamIdentifier.OggStreamType)videoTypes.iterator().next());
            }
            if (videoCount == 0 && audioCount > 1) {
                if (audioTypes.size() == 1) {
                    return OggDetector.toMediaType((OggStreamIdentifier.OggStreamType)audioTypes.iterator().next());
                }
                return OGG_AUDIO;
            }
            if (videoCount > 1) {
                if (videoTypes.size() == 1) {
                    return OggDetector.toMediaType((OggStreamIdentifier.OggStreamType)videoTypes.iterator().next());
                }
                return OGG_VIDEO;
            }
            if (kateCount > 0) {
                return OggDetector.toMediaType(OggStreamIdentifier.KATE);
            }
        }
        return OGG_GENERAL;
    }

    protected static MediaType toMediaType(OggStreamIdentifier.OggStreamType type) {
        if (type == OggStreamIdentifier.UNKNOWN) {
            return OGG_GENERAL;
        }
        return MediaType.parse((String)type.mimetype);
    }
}

