/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.TaggedContentHandler;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.io.input.CloseShieldInputStream;

public class XMLParser
extends AbstractParser {
    private static final long serialVersionUID = -6028836725280212837L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"xml"), MediaType.image((String)"svg+xml"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (metadata.get("Content-Type") == null) {
            metadata.set("Content-Type", "application/xml");
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement("p");
        TaggedContentHandler tagged = new TaggedContentHandler(handler);
        try {
            XMLReaderUtils.parseSAX((InputStream)new CloseShieldInputStream(stream), (ContentHandler)new EmbeddedContentHandler(this.getContentHandler((ContentHandler)tagged, metadata, context)), (ParseContext)context);
        }
        catch (SAXException e) {
            tagged.throwIfCauseOf((Exception)e);
            throw new TikaException("XML parse error", (Throwable)e);
        }
        finally {
            xhtml.endElement("p");
            xhtml.endDocument();
        }
    }

    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        return new TextContentHandler(handler, true);
    }
}

