/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.tika.mime.MediaType;
import shaded.org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;

public class DataURIScheme {
    private final String rawMediaTypeString;
    private final boolean isBase64;
    private final byte[] data;

    DataURIScheme(String mediaTypeString, boolean isBase64, byte[] data) {
        this.rawMediaTypeString = mediaTypeString;
        this.isBase64 = isBase64;
        this.data = data;
    }

    public InputStream getInputStream() {
        return new UnsynchronizedByteArrayInputStream(this.data);
    }

    public MediaType getMediaType() {
        if (this.rawMediaTypeString != null) {
            return MediaType.parse((String)this.rawMediaTypeString);
        }
        return null;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataURIScheme)) {
            return false;
        }
        DataURIScheme that = (DataURIScheme)o;
        return this.isBase64() == that.isBase64() && Objects.equals(this.rawMediaTypeString, that.rawMediaTypeString) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = Objects.hash(this.rawMediaTypeString, this.isBase64());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }
}

